/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.dataflow.executor;

import java.util.List;
import org.apache.shardingsphere.elasticjob.api.JobConfiguration;
import org.apache.shardingsphere.elasticjob.dataflow.job.DataflowJob;
import org.apache.shardingsphere.elasticjob.spi.executor.item.param.JobRuntimeService;
import org.apache.shardingsphere.elasticjob.spi.executor.item.param.ShardingContext;
import org.apache.shardingsphere.elasticjob.spi.executor.item.type.ClassedJobItemExecutor;

public final class DataflowJobExecutor
implements ClassedJobItemExecutor<DataflowJob> {
    public void process(DataflowJob elasticJob, JobConfiguration jobConfig, JobRuntimeService jobRuntimeService, ShardingContext shardingContext) {
        if (Boolean.parseBoolean(jobConfig.getProps().getOrDefault((Object)"streaming.process", (Object)false).toString())) {
            this.streamingExecute(elasticJob, jobConfig, jobRuntimeService, shardingContext);
        } else {
            this.oneOffExecute(elasticJob, shardingContext);
        }
    }

    private void streamingExecute(DataflowJob elasticJob, JobConfiguration jobConfig, JobRuntimeService jobRuntimeService, ShardingContext shardingContext) {
        List<Object> data = this.fetchData(elasticJob, shardingContext);
        while (null != data && !data.isEmpty()) {
            this.processData(elasticJob, shardingContext, data);
            if (!this.isEligibleForJobRunning(jobConfig, jobRuntimeService)) break;
            data = this.fetchData(elasticJob, shardingContext);
        }
    }

    private boolean isEligibleForJobRunning(JobConfiguration jobConfig, JobRuntimeService jobRuntimeService) {
        return !jobRuntimeService.isNeedSharding() && Boolean.parseBoolean(jobConfig.getProps().getOrDefault((Object)"streaming.process", (Object)false).toString());
    }

    private void oneOffExecute(DataflowJob elasticJob, ShardingContext shardingContext) {
        List<Object> data = this.fetchData(elasticJob, shardingContext);
        if (null != data && !data.isEmpty()) {
            this.processData(elasticJob, shardingContext, data);
        }
    }

    private List<Object> fetchData(DataflowJob elasticJob, ShardingContext shardingContext) {
        return elasticJob.fetchData(shardingContext);
    }

    private void processData(DataflowJob elasticJob, ShardingContext shardingContext, List<Object> data) {
        elasticJob.processData(shardingContext, data);
    }

    public Class<DataflowJob> getElasticJobClass() {
        return DataflowJob.class;
    }
}

