/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.elasticjob.kernel.internal.schedule;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import org.apache.shardingsphere.elasticjob.kernel.internal.listener.ListenerNotifierManager;
import org.apache.shardingsphere.elasticjob.kernel.internal.schedule.JobScheduleController;
import org.apache.shardingsphere.elasticjob.kernel.internal.sharding.JobInstance;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;

public final class JobRegistry {
    private static volatile JobRegistry instance;
    private final Map<String, JobScheduleController> schedulerMap = new ConcurrentHashMap<String, JobScheduleController>();
    private final Map<String, CoordinatorRegistryCenter> regCenterMap = new ConcurrentHashMap<String, CoordinatorRegistryCenter>();
    private final Map<String, JobInstance> jobInstanceMap = new ConcurrentHashMap<String, JobInstance>();
    private final Map<String, Boolean> jobRunningMap = new ConcurrentHashMap<String, Boolean>();
    private final Map<String, Integer> currentShardingTotalCountMap = new ConcurrentHashMap<String, Integer>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static JobRegistry getInstance() {
        if (null != instance) return instance;
        Class<JobRegistry> clazz = JobRegistry.class;
        synchronized (JobRegistry.class) {
            if (null != instance) return instance;
            instance = new JobRegistry();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void registerRegistryCenter(String jobName, CoordinatorRegistryCenter regCenter) {
        this.regCenterMap.put(jobName, regCenter);
        regCenter.addCacheData("/" + jobName);
    }

    public void registerJob(String jobName, JobScheduleController jobScheduleController) {
        this.schedulerMap.put(jobName, jobScheduleController);
    }

    public JobScheduleController getJobScheduleController(String jobName) {
        return this.schedulerMap.get(jobName);
    }

    public CoordinatorRegistryCenter getRegCenter(String jobName) {
        return this.regCenterMap.get(jobName);
    }

    public void addJobInstance(String jobName, JobInstance jobInstance) {
        this.jobInstanceMap.put(jobName, jobInstance);
    }

    public JobInstance getJobInstance(String jobName) {
        return this.jobInstanceMap.get(jobName);
    }

    public boolean isJobRunning(String jobName) {
        return this.jobRunningMap.getOrDefault(jobName, false);
    }

    public void setJobRunning(String jobName, boolean isRunning) {
        this.jobRunningMap.put(jobName, isRunning);
    }

    public int getCurrentShardingTotalCount(String jobName) {
        return this.currentShardingTotalCountMap.getOrDefault(jobName, 0);
    }

    public void setCurrentShardingTotalCount(String jobName, int currentShardingTotalCount) {
        this.currentShardingTotalCountMap.put(jobName, currentShardingTotalCount);
    }

    public void shutdown(String jobName) {
        Optional.ofNullable(this.schedulerMap.remove(jobName)).ifPresent(JobScheduleController::shutdown);
        Optional.ofNullable(this.regCenterMap.remove(jobName)).ifPresent(regCenter -> regCenter.evictCacheData("/" + jobName));
        ListenerNotifierManager.getInstance().removeJobNotifyExecutor(jobName);
        this.jobInstanceMap.remove(jobName);
        this.jobRunningMap.remove(jobName);
        this.currentShardingTotalCountMap.remove(jobName);
    }

    public boolean isShutdown(String jobName) {
        return !this.schedulerMap.containsKey(jobName) || !this.jobInstanceMap.containsKey(jobName);
    }

    @Generated
    private JobRegistry() {
    }
}

