/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.grpc.handler;

import java.util.Objects;
import org.apache.shenyu.common.dto.PluginData;
import org.apache.shenyu.common.dto.RuleData;
import org.apache.shenyu.common.dto.SelectorData;
import org.apache.shenyu.common.dto.convert.plugin.GrpcRegisterConfig;
import org.apache.shenyu.common.enums.PluginEnum;
import org.apache.shenyu.common.utils.GsonUtils;
import org.apache.shenyu.common.utils.Singleton;
import org.apache.shenyu.plugin.base.handler.PluginDataHandler;
import org.apache.shenyu.plugin.base.utils.CacheKeyUtils;
import org.apache.shenyu.plugin.grpc.cache.ApplicationConfigCache;
import org.apache.shenyu.plugin.grpc.cache.GrpcClientCache;

public class GrpcPluginDataHandler
implements PluginDataHandler {
    public void handlerPlugin(PluginData pluginData) {
        if (Objects.nonNull(pluginData) && Boolean.TRUE.equals(pluginData.getEnabled())) {
            GrpcRegisterConfig grpcRegisterConfig = (GrpcRegisterConfig)GsonUtils.getInstance().fromJson(pluginData.getConfig(), GrpcRegisterConfig.class);
            GrpcRegisterConfig exist = (GrpcRegisterConfig)Singleton.INST.get(GrpcRegisterConfig.class);
            if (Objects.isNull(grpcRegisterConfig)) {
                return;
            }
            if (Objects.isNull(exist) || !grpcRegisterConfig.equals((Object)exist)) {
                Singleton.INST.single(GrpcRegisterConfig.class, (Object)grpcRegisterConfig);
            }
        }
    }

    public void handlerSelector(SelectorData selectorData) {
        if (Objects.isNull(selectorData.getId())) {
            return;
        }
        if (!selectorData.getContinued().booleanValue()) {
            ApplicationConfigCache.getInstance().cacheRuleHandle(CacheKeyUtils.INST.getKey(selectorData.getId(), "default_rule"), "{}");
        }
        GrpcClientCache.initGrpcClient(selectorData.getId());
    }

    public void removeSelector(SelectorData selectorData) {
        if (Objects.isNull(selectorData.getId())) {
            return;
        }
        ApplicationConfigCache.getInstance().invalidate(selectorData.getId());
    }

    public void handlerRule(RuleData ruleData) {
        ApplicationConfigCache.getInstance().cacheRuleHandle(ruleData.getId(), ruleData.getHandle());
    }

    public void removeRule(RuleData ruleData) {
        ApplicationConfigCache.getInstance().removeRuleHandle(ruleData.getId());
    }

    public String pluginNamed() {
        return PluginEnum.GRPC.getName();
    }
}

