/*
 * Decompiled with CFR 0.152.
 */
package com.weibo.api.motan.transport.netty4;

import com.weibo.api.motan.core.DefaultThreadFactory;
import com.weibo.api.motan.core.StandardThreadExecutor;
import com.weibo.api.motan.transport.SharedObjectFactory;
import com.weibo.api.motan.transport.netty4.NettyChannel;
import com.weibo.api.motan.transport.netty4.NettyClient;
import com.weibo.api.motan.util.LoggerUtil;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public class NettyChannelFactory
implements SharedObjectFactory<NettyChannel> {
    private static final ExecutorService rebuildExecutorService = new StandardThreadExecutor(5, 30, 10L, TimeUnit.SECONDS, 100, (ThreadFactory)new DefaultThreadFactory("RebuildExecutorService", true), (RejectedExecutionHandler)new ThreadPoolExecutor.CallerRunsPolicy());
    private NettyClient nettyClient;
    private String factoryName;

    public NettyChannelFactory(NettyClient nettyClient) {
        this.nettyClient = nettyClient;
        this.factoryName = "NettyChannelFactory_" + nettyClient.getUrl().getHost() + "_" + nettyClient.getUrl().getPort();
    }

    public NettyChannel makeObject() {
        return new NettyChannel(this.nettyClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean rebuildObject(NettyChannel nettyChannel, boolean async) {
        ReentrantLock lock = nettyChannel.getLock();
        if (lock.tryLock()) {
            try {
                if (!nettyChannel.isAvailable() && !nettyChannel.isReconnect()) {
                    nettyChannel.reconnect();
                    if (async) {
                        rebuildExecutorService.submit(new RebuildTask(nettyChannel));
                    } else {
                        nettyChannel.close();
                        nettyChannel.open();
                        LoggerUtil.info((String)("rebuild channel success: " + nettyChannel.getUrl()));
                    }
                }
            }
            catch (Exception e) {
                LoggerUtil.error((String)("rebuild error: " + this.toString() + ", " + nettyChannel.getUrl()), (Throwable)e);
            }
            finally {
                lock.unlock();
            }
            return true;
        }
        return false;
    }

    public String toString() {
        return this.factoryName;
    }

    class RebuildTask
    implements Runnable {
        private NettyChannel channel;

        public RebuildTask(NettyChannel channel) {
            this.channel = channel;
        }

        @Override
        public void run() {
            try {
                this.channel.getLock().lock();
                this.channel.close();
                this.channel.open();
                LoggerUtil.info((String)("rebuild channel success: " + this.channel.getUrl()));
            }
            catch (Exception e) {
                LoggerUtil.error((String)("rebuild error: " + this.toString() + ", " + this.channel.getUrl()), (Throwable)e);
            }
            finally {
                this.channel.getLock().unlock();
            }
        }
    }
}

