/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.csp.sentinel.eagleeye;

import com.alibaba.csp.sentinel.concurrent.NamedThreadFactory;
import com.alibaba.csp.sentinel.eagleeye.EagleEye;
import com.alibaba.csp.sentinel.eagleeye.EagleEyeAppender;
import com.alibaba.csp.sentinel.eagleeye.EagleEyeCoreUtils;
import com.alibaba.csp.sentinel.eagleeye.FastDateFormat;
import com.alibaba.csp.sentinel.eagleeye.StatEntry;
import com.alibaba.csp.sentinel.eagleeye.StatEntryFunc;
import com.alibaba.csp.sentinel.eagleeye.StatLogger;
import com.alibaba.csp.sentinel.eagleeye.StatLoggerBuilder;
import com.alibaba.csp.sentinel.eagleeye.StatRollingData;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

class StatLogController {
    private static final Map<String, StatLogger> statLoggers = new ConcurrentHashMap<String, StatLogger>();
    private static final int STAT_ENTRY_COOL_DOWN_MILLIS = 200;
    private static final ScheduledThreadPoolExecutor rollerThreadPool = new ScheduledThreadPoolExecutor(1, new NamedThreadFactory("EagleEye-StatLogController-roller", true));
    private static final ScheduledThreadPoolExecutor writerThreadPool = new ScheduledThreadPoolExecutor(1, new NamedThreadFactory("EagleEye-StatLogController-writer", true));
    private static AtomicBoolean running = new AtomicBoolean(false);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static StatLogger createLoggerIfNotExists(StatLoggerBuilder builder) {
        String loggerName = builder.getLoggerName();
        StatLogger statLogger = statLoggers.get(loggerName);
        if (statLogger != null) return statLogger;
        Class<StatLogController> clazz = StatLogController.class;
        synchronized (StatLogController.class) {
            statLogger = statLoggers.get(loggerName);
            if (statLogger != null) return statLogger;
            statLogger = builder.create();
            statLoggers.put(loggerName, statLogger);
            writerThreadPool.setMaximumPoolSize(Math.max(1, statLoggers.size()));
            StatLogController.scheduleNextRollingTask(statLogger);
            EagleEye.selfLog("[INFO] created statLogger[" + statLogger.getLoggerName() + "]: " + statLogger.getAppender());
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return statLogger;
        }
    }

    static Map<String, StatLogger> getAllStatLoggers() {
        return Collections.unmodifiableMap(statLoggers);
    }

    private static void scheduleNextRollingTask(StatLogger statLogger) {
        if (!running.get()) {
            EagleEye.selfLog("[INFO] stopped rolling statLogger[" + statLogger.getLoggerName() + "]");
            return;
        }
        StatLogRollingTask rollingTask = new StatLogRollingTask(statLogger);
        long rollingTimeMillis = statLogger.getRollingData().getRollingTimeMillis();
        long delayMillis = rollingTimeMillis - System.currentTimeMillis();
        if (delayMillis > 5L) {
            rollerThreadPool.schedule(rollingTask, delayMillis, TimeUnit.MILLISECONDS);
        } else if (-delayMillis > statLogger.getIntervalMillis()) {
            EagleEye.selfLog("[WARN] unusual delay of statLogger[" + statLogger.getLoggerName() + "], delay=" + -delayMillis + "ms, submit now");
            rollerThreadPool.submit(rollingTask);
        } else {
            rollerThreadPool.submit(rollingTask);
        }
    }

    static void scheduleWriteTask(StatRollingData statRollingData) {
        if (statRollingData != null) {
            try {
                StatLogWriteTask task = new StatLogWriteTask(statRollingData);
                writerThreadPool.schedule(task, 200L, TimeUnit.MILLISECONDS);
            }
            catch (Throwable t) {
                EagleEye.selfLog("[ERROR] fail to roll statLogger[" + statRollingData.getStatLogger().getLoggerName() + "]", t);
            }
        }
    }

    static void start() {
        if (running.compareAndSet(false, true)) {
            rollerThreadPool.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            writerThreadPool.setExecuteExistingDelayedTasksAfterShutdownPolicy(true);
        }
    }

    static void stop() {
        if (running.compareAndSet(true, false)) {
            EagleEyeCoreUtils.shutdownThreadPool(rollerThreadPool, 0L);
            EagleEye.selfLog("[INFO] StatLoggerController: roller ThreadPool shutdown successfully");
            for (StatLogger statLogger : statLoggers.values()) {
                new StatLogRollingTask(statLogger).run();
            }
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            EagleEyeCoreUtils.shutdownThreadPool(writerThreadPool, 2000L);
            EagleEye.selfLog("[INFO] StatLoggerController: writer ThreadPool shutdown successfully");
        }
    }

    private StatLogController() {
    }

    private static class StatLogWriteTask
    implements Runnable {
        final StatRollingData statRollingData;

        StatLogWriteTask(StatRollingData statRollingData) {
            this.statRollingData = statRollingData;
        }

        @Override
        public void run() {
            StatRollingData data = this.statRollingData;
            StatLogger logger = data.getStatLogger();
            try {
                FastDateFormat fmt = new FastDateFormat();
                StringBuilder buffer = new StringBuilder(256);
                String timeStr = fmt.formatWithoutMs(data.getTimeSlot());
                EagleEyeAppender appender = logger.getAppender();
                Set<Map.Entry<StatEntry, StatEntryFunc>> entrySet = data.getStatEntrySet();
                char entryDelimiter = logger.getEntryDelimiter();
                char keyDelimiter = logger.getKeyDelimiter();
                char valueDelimiter = logger.getValueDelimiter();
                for (Map.Entry<StatEntry, StatEntryFunc> entry : entrySet) {
                    buffer.delete(0, buffer.length());
                    StatEntryFunc func = entry.getValue();
                    buffer.append(timeStr).append(entryDelimiter);
                    buffer.append(func.getStatType()).append(entryDelimiter);
                    entry.getKey().appendTo(buffer, keyDelimiter);
                    buffer.append(entryDelimiter);
                    func.appendTo(buffer, valueDelimiter);
                    buffer.append("\r\n");
                    appender.append(buffer.toString());
                }
                appender.flush();
            }
            catch (Throwable t) {
                EagleEye.selfLog("[WARN] fail to write statLogger[" + logger.getLoggerName() + "]", t);
            }
        }
    }

    private static class StatLogRollingTask
    implements Runnable {
        final StatLogger statLogger;

        StatLogRollingTask(StatLogger statLogger) {
            this.statLogger = statLogger;
        }

        @Override
        public void run() {
            StatLogController.scheduleWriteTask(this.statLogger.rolling());
            StatLogController.scheduleNextRollingTask(this.statLogger);
        }
    }
}

