/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch.ml.put_trained_model;

import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class TrainedModelTreeNode
implements JsonpSerializable {
    @Nullable
    private final String decisionType;
    @Nullable
    private final Boolean defaultLeft;
    @Nullable
    private final Double leafValue;
    @Nullable
    private final Integer leftChild;
    private final int nodeIndex;
    @Nullable
    private final Integer rightChild;
    @Nullable
    private final Integer splitFeature;
    @Nullable
    private final Integer splitGain;
    @Nullable
    private final Double threshold;
    public static final JsonpDeserializer<TrainedModelTreeNode> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, TrainedModelTreeNode::setupTrainedModelTreeNodeDeserializer);

    private TrainedModelTreeNode(Builder builder) {
        this.decisionType = builder.decisionType;
        this.defaultLeft = builder.defaultLeft;
        this.leafValue = builder.leafValue;
        this.leftChild = builder.leftChild;
        this.nodeIndex = ApiTypeHelper.requireNonNull(builder.nodeIndex, this, "nodeIndex");
        this.rightChild = builder.rightChild;
        this.splitFeature = builder.splitFeature;
        this.splitGain = builder.splitGain;
        this.threshold = builder.threshold;
    }

    public static TrainedModelTreeNode of(Function<Builder, ObjectBuilder<TrainedModelTreeNode>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final String decisionType() {
        return this.decisionType;
    }

    @Nullable
    public final Boolean defaultLeft() {
        return this.defaultLeft;
    }

    @Nullable
    public final Double leafValue() {
        return this.leafValue;
    }

    @Nullable
    public final Integer leftChild() {
        return this.leftChild;
    }

    public final int nodeIndex() {
        return this.nodeIndex;
    }

    @Nullable
    public final Integer rightChild() {
        return this.rightChild;
    }

    @Nullable
    public final Integer splitFeature() {
        return this.splitFeature;
    }

    @Nullable
    public final Integer splitGain() {
        return this.splitGain;
    }

    @Nullable
    public final Double threshold() {
        return this.threshold;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (this.decisionType != null) {
            generator.writeKey("decision_type");
            generator.write(this.decisionType);
        }
        if (this.defaultLeft != null) {
            generator.writeKey("default_left");
            generator.write(this.defaultLeft.booleanValue());
        }
        if (this.leafValue != null) {
            generator.writeKey("leaf_value");
            generator.write(this.leafValue.doubleValue());
        }
        if (this.leftChild != null) {
            generator.writeKey("left_child");
            generator.write(this.leftChild.intValue());
        }
        generator.writeKey("node_index");
        generator.write(this.nodeIndex);
        if (this.rightChild != null) {
            generator.writeKey("right_child");
            generator.write(this.rightChild.intValue());
        }
        if (this.splitFeature != null) {
            generator.writeKey("split_feature");
            generator.write(this.splitFeature.intValue());
        }
        if (this.splitGain != null) {
            generator.writeKey("split_gain");
            generator.write(this.splitGain.intValue());
        }
        if (this.threshold != null) {
            generator.writeKey("threshold");
            generator.write(this.threshold.doubleValue());
        }
    }

    public String toString() {
        return JsonpUtils.toString(this);
    }

    protected static void setupTrainedModelTreeNodeDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::decisionType, JsonpDeserializer.stringDeserializer(), "decision_type");
        op.add(Builder::defaultLeft, JsonpDeserializer.booleanDeserializer(), "default_left");
        op.add(Builder::leafValue, JsonpDeserializer.doubleDeserializer(), "leaf_value");
        op.add(Builder::leftChild, JsonpDeserializer.integerDeserializer(), "left_child");
        op.add(Builder::nodeIndex, JsonpDeserializer.integerDeserializer(), "node_index");
        op.add(Builder::rightChild, JsonpDeserializer.integerDeserializer(), "right_child");
        op.add(Builder::splitFeature, JsonpDeserializer.integerDeserializer(), "split_feature");
        op.add(Builder::splitGain, JsonpDeserializer.integerDeserializer(), "split_gain");
        op.add(Builder::threshold, JsonpDeserializer.doubleDeserializer(), "threshold");
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<TrainedModelTreeNode> {
        @Nullable
        private String decisionType;
        @Nullable
        private Boolean defaultLeft;
        @Nullable
        private Double leafValue;
        @Nullable
        private Integer leftChild;
        private Integer nodeIndex;
        @Nullable
        private Integer rightChild;
        @Nullable
        private Integer splitFeature;
        @Nullable
        private Integer splitGain;
        @Nullable
        private Double threshold;

        public final Builder decisionType(@Nullable String value) {
            this.decisionType = value;
            return this;
        }

        public final Builder defaultLeft(@Nullable Boolean value) {
            this.defaultLeft = value;
            return this;
        }

        public final Builder leafValue(@Nullable Double value) {
            this.leafValue = value;
            return this;
        }

        public final Builder leftChild(@Nullable Integer value) {
            this.leftChild = value;
            return this;
        }

        public final Builder nodeIndex(int value) {
            this.nodeIndex = value;
            return this;
        }

        public final Builder rightChild(@Nullable Integer value) {
            this.rightChild = value;
            return this;
        }

        public final Builder splitFeature(@Nullable Integer value) {
            this.splitFeature = value;
            return this;
        }

        public final Builder splitGain(@Nullable Integer value) {
            this.splitGain = value;
            return this;
        }

        public final Builder threshold(@Nullable Double value) {
            this.threshold = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        @Override
        public TrainedModelTreeNode build() {
            this._checkSingleUse();
            return new TrainedModelTreeNode(this);
        }
    }
}

