/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.transport;

import com.alipay.sofa.rpc.common.struct.TwoWayMap;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;

public class ChannelContext {
    protected volatile TwoWayMap<Short, String> headerCache;
    protected Integer dstVersion;
    protected String clientAppId;
    protected String clientAppName;
    protected String clientInstanceId;
    private String protocol;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putHeadCache(Short key, String value) {
        if (this.headerCache == null) {
            ChannelContext channelContext = this;
            synchronized (channelContext) {
                if (this.headerCache == null) {
                    this.headerCache = new TwoWayMap();
                }
            }
        }
        if (this.headerCache != null && !this.headerCache.containsKey(key)) {
            this.headerCache.put(key, value);
        }
    }

    public void invalidateHeadCache(Byte key, String value) {
        if (this.headerCache != null && this.headerCache.containsKey(key)) {
            String old = this.headerCache.get(key);
            if (!old.equals(value)) {
                throw new SofaRpcRuntimeException("Value of old is not match current");
            }
            this.headerCache.remove(key);
        }
    }

    public String getHeader(Short key) {
        if (key != null && this.headerCache != null) {
            return this.headerCache.get(key);
        }
        return null;
    }

    public Short getHeaderKey(String value) {
        if (StringUtils.isNotEmpty(value) && this.headerCache != null) {
            return this.headerCache.getKey(value);
        }
        return null;
    }

    public Integer getDstVersion() {
        return this.dstVersion;
    }

    public ChannelContext setDstVersion(Integer dstVersion) {
        this.dstVersion = dstVersion;
        return this;
    }

    public String getClientAppId() {
        return this.clientAppId;
    }

    public ChannelContext setClientAppId(String clientAppId) {
        this.clientAppId = clientAppId;
        return this;
    }

    public String getClientAppName() {
        return this.clientAppName;
    }

    public ChannelContext setClientAppName(String clientAppName) {
        this.clientAppName = clientAppName;
        return this;
    }

    public String getClientInstanceId() {
        return this.clientInstanceId;
    }

    public ChannelContext setClientInstanceId(String clientInstanceId) {
        this.clientInstanceId = clientInstanceId;
        return this;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Short getAvailableRefIndex(boolean consumerToProvider) {
        if (this.headerCache == null) {
            ChannelContext channelContext = this;
            synchronized (channelContext) {
                if (this.headerCache == null) {
                    this.headerCache = new TwoWayMap();
                }
            }
        }
        if (consumerToProvider) {
            for (short i = 0; i < Short.MAX_VALUE; i = (short)(i + 1)) {
                if (this.headerCache.containsKey(i)) continue;
                return i;
            }
        } else {
            for (short i = -1; i > Short.MIN_VALUE; i = (short)(i - 1)) {
                if (this.headerCache.containsKey(i)) continue;
                return i;
            }
        }
        return null;
    }
}

