/*
 * Decompiled with CFR 0.152.
 */
package com.tencentcloudapi.cls.producer.common;

import com.tencentcloudapi.cls.producer.AsyncProducerConfig;
import com.tencentcloudapi.cls.producer.Result;
import com.tencentcloudapi.cls.producer.common.Attempt;
import com.tencentcloudapi.cls.producer.common.LogException;
import com.tencentcloudapi.cls.producer.common.LogItem;
import com.tencentcloudapi.cls.producer.common.LogSizeCalculator;
import com.tencentcloudapi.cls.producer.common.Logs;
import com.tencentcloudapi.cls.producer.common.SendProducerBatchTask;
import com.tencentcloudapi.cls.producer.errors.LogSizeTooLargeException;
import com.tencentcloudapi.cls.producer.http.client.Sender;
import com.tencentcloudapi.cls.producer.http.comm.HttpMethod;
import com.tencentcloudapi.cls.producer.http.comm.RequestMessage;
import com.tencentcloudapi.cls.producer.request.PutLogsRequest;
import com.tencentcloudapi.cls.producer.response.PutLogsResponse;
import com.tencentcloudapi.cls.producer.util.LZ4Encoder;
import com.tencentcloudapi.cls.producer.util.QcloudClsSignature;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendProducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SendProducerBatchTask.class);
    private final AsyncProducerConfig producerConfig;

    public SendProducer(AsyncProducerConfig producerConfig) {
        this.producerConfig = producerConfig;
    }

    private Map<String, String> getCommonHeadPara() {
        HashMap<String, String> headParameter = new HashMap<String, String>(3);
        headParameter.put("Content-Length", "0");
        headParameter.put("Content-Type", "application/x-protobuf");
        headParameter.put("Host", this.producerConfig.getHostName());
        return headParameter;
    }

    private PutLogsRequest buildPutLogsRequest(List<LogItem> logItems, String topicID) {
        Logs.LogGroup.Builder logGroup = Logs.LogGroup.newBuilder();
        for (LogItem tmp : logItems) {
            logGroup.addLogs(tmp.mContents);
        }
        return new PutLogsRequest(topicID, this.producerConfig.getSourceIp(), "", logGroup);
    }

    private PutLogsResponse sendLogs(Map<String, String> urlParameter, Map<String, String> headParameter, byte[] body) throws LogException {
        PutLogsResponse response;
        String signature;
        headParameter.put("Content-Length", String.valueOf(body.length));
        try {
            signature = QcloudClsSignature.buildSignature(this.producerConfig.getSecretId(), this.producerConfig.getSecretKey(), HttpMethod.POST.toString(), "/structuredlog", urlParameter, headParameter, 300000L);
        }
        catch (UnsupportedEncodingException e) {
            throw new LogException("EncodingException", e.getMessage());
        }
        headParameter.put("Authorization", signature);
        headParameter.put("x-cls-compress-type", "lz4");
        if (null != this.producerConfig.getSecretToken() && !this.producerConfig.getSecretToken().isEmpty()) {
            headParameter.put("X-Cls-Token", this.producerConfig.getSecretToken());
        }
        headParameter.put("cls-java-sdk-version", "1.0.13");
        URI uri = this.getHostURI();
        byte[] compressedData = LZ4Encoder.compressToLhLz4Chunk(body);
        RequestMessage requestMessage = SendProducer.buildRequest(uri, urlParameter, headParameter, compressedData, compressedData.length);
        String requestId = "";
        try {
            response = Sender.doPost(requestMessage);
            if (response != null) {
                requestId = response.GetRequestId();
            }
        }
        catch (Exception e) {
            throw new LogException("SendFailed", e.getMessage());
        }
        switch (response.GetHttpStatusCode()) {
            case 200: {
                return response;
            }
            case 500: {
                throw new LogException(response.GetHttpStatusCode(), "BadResponse", "internal server error", requestId);
            }
            case 429: {
                throw new LogException(response.GetHttpStatusCode(), "SpeedQuotaExceed", "speed quota exceed", requestId);
            }
            case 413: {
                throw new LogException(response.GetHttpStatusCode(), "ContentIsTooLarge", "content is too large", requestId);
            }
            case 404: {
                throw new LogException(response.GetHttpStatusCode(), "TopicNotExists", "topic not exists", requestId);
            }
            case 403: {
                throw new LogException(response.GetHttpStatusCode(), "SingleValueExceed1M", "single log value exceed 1M", requestId);
            }
            case 401: {
                throw new LogException(response.GetHttpStatusCode(), "AuthFailure", "auth failed", requestId);
            }
            case 400: {
                throw new LogException(response.GetHttpStatusCode(), "InvalidParam", "invalid param", requestId);
            }
        }
        throw new LogException(response.GetHttpStatusCode(), "BadResponse", response.GetAllHeaders().toString(), requestId);
    }

    private URI getHostURI() {
        String endPointUrl = this.producerConfig.getHttpType() + this.producerConfig.getHostName();
        try {
            return new URI(endPointUrl);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("EndpointInvalid", e);
        }
    }

    private static RequestMessage buildRequest(URI endpoint, Map<String, String> parameters, Map<String, String> headers, byte[] content, long size) {
        RequestMessage request = new RequestMessage();
        request.setMethod(HttpMethod.POST);
        request.setEndpoint(endpoint);
        request.setResourcePath("/structuredlog");
        request.setParameters(parameters);
        request.setHeaders(headers);
        request.setContent(content);
        request.setContentLength(size);
        return request;
    }

    private Attempt buildAttempt(Exception e, long nowMs, String requestId) {
        if (e instanceof LogException) {
            LogException logException = (LogException)e;
            return new Attempt(false, logException.GetRequestId(), logException.GetErrorCode(), logException.GetErrorMessage(), nowMs);
        }
        return new Attempt(false, "", "BadResponse", e.getMessage(), nowMs);
    }

    private void ensureValidLogSize(int sizeInBytes) throws LogSizeTooLargeException {
        if (sizeInBytes > 0x500000) {
            throw new LogSizeTooLargeException("the logs is " + sizeInBytes + " bytes which is larger than MAX_BATCH_SIZE_IN_BYTES " + 0x500000);
        }
        if (sizeInBytes > this.producerConfig.getTotalSizeInBytes()) {
            throw new LogSizeTooLargeException("the logs is " + sizeInBytes + " bytes which is larger than the totalSizeInBytes you specified");
        }
    }

    public Result sendProducer(long nowMs, String topicID, List<LogItem> logItems) throws LogException, LogSizeTooLargeException {
        int sizeInBytes = LogSizeCalculator.calculate(logItems);
        this.ensureValidLogSize(sizeInBytes);
        ArrayList<Attempt> attempts = new ArrayList<Attempt>();
        PutLogsRequest request = this.buildPutLogsRequest(logItems, topicID);
        Map<String, String> headParameter = this.getCommonHeadPara();
        request.SetParam("topic_id", request.GetTopic());
        Map<String, String> urlParameter = request.GetAllParams();
        byte[] logBytes = request.GetLogGroupBytes(this.producerConfig.getSourceIp(), "");
        PutLogsResponse response = this.sendLogs(urlParameter, headParameter, logBytes);
        Attempt attempt = new Attempt(true, response.GetRequestId(), "", "", nowMs);
        attempts.add(attempt);
        return new Result(true, attempts, 1);
    }
}

