/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.receiver.clr.provider.handler;

import org.apache.skywalking.apm.network.common.v3.CPU;
import org.apache.skywalking.apm.network.language.agent.v3.CLRMetric;
import org.apache.skywalking.apm.network.language.agent.v3.ClrGC;
import org.apache.skywalking.apm.network.language.agent.v3.ClrThread;
import org.apache.skywalking.oap.server.core.analysis.IDManager;
import org.apache.skywalking.oap.server.core.source.ISource;
import org.apache.skywalking.oap.server.core.source.ServiceInstanceCLRCPU;
import org.apache.skywalking.oap.server.core.source.ServiceInstanceCLRGC;
import org.apache.skywalking.oap.server.core.source.ServiceInstanceCLRThread;
import org.apache.skywalking.oap.server.core.source.SourceReceiver;
import org.apache.skywalking.oap.server.library.module.ModuleManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CLRSourceDispatcher {
    private static final Logger LOGGER = LoggerFactory.getLogger(CLRSourceDispatcher.class);
    private final SourceReceiver sourceReceiver;

    public CLRSourceDispatcher(ModuleManager moduleManager) {
        this.sourceReceiver = (SourceReceiver)moduleManager.find("core").provider().getService(SourceReceiver.class);
    }

    void sendMetric(String service, String serviceInstance, long minuteTimeBucket, CLRMetric metrics) {
        String serviceId = IDManager.ServiceID.buildId((String)service, (boolean)true);
        String serviceInstanceId = IDManager.ServiceInstanceID.buildId((String)serviceId, (String)serviceInstance);
        CPU cpu = metrics.getCpu();
        ServiceInstanceCLRCPU serviceInstanceCLRCPU = new ServiceInstanceCLRCPU();
        serviceInstanceCLRCPU.setUsePercent(cpu.getUsagePercent());
        serviceInstanceCLRCPU.setTimeBucket(minuteTimeBucket);
        serviceInstanceCLRCPU.setId(serviceInstanceId);
        serviceInstanceCLRCPU.setName("");
        serviceInstanceCLRCPU.setServiceId(serviceId);
        serviceInstanceCLRCPU.setServiceName(service);
        this.sourceReceiver.receive((ISource)serviceInstanceCLRCPU);
        ClrGC gc = metrics.getGc();
        ServiceInstanceCLRGC serviceInstanceCLRGC = new ServiceInstanceCLRGC();
        serviceInstanceCLRGC.setGen0CollectCount(gc.getGen0CollectCount());
        serviceInstanceCLRGC.setGen1CollectCount(gc.getGen1CollectCount());
        serviceInstanceCLRGC.setGen2CollectCount(gc.getGen2CollectCount());
        serviceInstanceCLRGC.setHeapMemory(gc.getHeapMemory());
        serviceInstanceCLRGC.setTimeBucket(minuteTimeBucket);
        serviceInstanceCLRGC.setId(serviceInstanceId);
        serviceInstanceCLRGC.setName(serviceInstance);
        serviceInstanceCLRGC.setServiceId(serviceId);
        serviceInstanceCLRGC.setServiceName(service);
        this.sourceReceiver.receive((ISource)serviceInstanceCLRGC);
        ClrThread thread = metrics.getThread();
        ServiceInstanceCLRThread serviceInstanceCLRThread = new ServiceInstanceCLRThread();
        serviceInstanceCLRThread.setAvailableCompletionPortThreads((long)thread.getAvailableCompletionPortThreads());
        serviceInstanceCLRThread.setAvailableWorkerThreads((long)thread.getAvailableWorkerThreads());
        serviceInstanceCLRThread.setMaxCompletionPortThreads((long)thread.getMaxCompletionPortThreads());
        serviceInstanceCLRThread.setMaxWorkerThreads((long)thread.getMaxWorkerThreads());
        serviceInstanceCLRThread.setTimeBucket(minuteTimeBucket);
        serviceInstanceCLRThread.setId(serviceInstanceId);
        serviceInstanceCLRThread.setName(service);
        serviceInstanceCLRThread.setServiceId(serviceId);
        serviceInstanceCLRThread.setServiceName(serviceInstance);
        this.sourceReceiver.receive((ISource)serviceInstanceCLRThread);
    }
}

