/*
 * Decompiled with CFR 0.152.
 */
package org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.skywalking.oap.server.core.analysis.metrics.DataTable;
import org.apache.skywalking.oap.server.core.query.input.Duration;
import org.apache.skywalking.oap.server.core.query.input.MetricsCondition;
import org.apache.skywalking.oap.server.core.query.type.HeatMap;
import org.apache.skywalking.oap.server.core.query.type.IntValues;
import org.apache.skywalking.oap.server.core.query.type.KVInt;
import org.apache.skywalking.oap.server.core.query.type.KeyValue;
import org.apache.skywalking.oap.server.core.query.type.MetricsValues;
import org.apache.skywalking.oap.server.core.storage.annotation.ValueColumnMetadata;
import org.apache.skywalking.oap.server.core.storage.query.IMetricsQueryDAO;
import org.apache.skywalking.oap.server.library.client.jdbc.hikaricp.JDBCClient;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.TableHelper;
import org.apache.skywalking.oap.server.storage.plugin.jdbc.common.dao.JDBCSQLExecutor;

public class JDBCMetricsQueryDAO
extends JDBCSQLExecutor
implements IMetricsQueryDAO {
    private final JDBCClient jdbcClient;
    private final TableHelper tableHelper;

    protected StringBuilder buildMetricsValueSql(String op, String valueColumnName, String conditionName) {
        return new StringBuilder("select entity_id id, " + op + "(" + valueColumnName + ") result from " + conditionName + " where ");
    }

    public MetricsValues readMetricsValues(MetricsCondition condition, String valueColumnName, Duration duration) {
        MetricsValues metricsValues = new MetricsValues();
        IntValues intValues = metricsValues.getValues();
        List<String> tables = this.tableHelper.getTablesForRead(condition.getName(), duration.getStartTimeBucket(), duration.getEndTimeBucket());
        List pointOfTimes = duration.assembleDurationPoints();
        String entityId = condition.getEntity().buildId();
        List<Object> ids = pointOfTimes.stream().map(pointOfTime -> TableHelper.generateId(condition.getName(), pointOfTime.id(entityId))).collect(Collectors.toList());
        for (String table : tables) {
            StringBuilder sql = new StringBuilder("select id, " + valueColumnName + " from " + table).append(" where id in ").append(ids.stream().map(it -> "?").collect(Collectors.joining(", ", "(", ")")));
            this.jdbcClient.executeQuery(sql.toString(), resultSet -> {
                while (resultSet.next()) {
                    KVInt kv = new KVInt();
                    kv.setId(resultSet.getString("id"));
                    kv.setValue(resultSet.getLong(valueColumnName));
                    intValues.addKVInt(kv);
                }
                return null;
            }, ids.toArray(new Object[0]));
        }
        metricsValues.setValues(IMetricsQueryDAO.Util.sortValues((IntValues)intValues, ids, (int)ValueColumnMetadata.INSTANCE.getDefaultValue(condition.getName())));
        return metricsValues;
    }

    public List<MetricsValues> readLabeledMetricsValues(MetricsCondition condition, String valueColumnName, List<KeyValue> labels, Duration duration) {
        HashMap idMap = new HashMap();
        List<String> tables = this.tableHelper.getTablesForRead(condition.getName(), duration.getStartTimeBucket(), duration.getEndTimeBucket());
        List pointOfTimes = duration.assembleDurationPoints();
        String entityId = condition.getEntity().buildId();
        List<Object> ids = pointOfTimes.stream().map(pointOfTime -> TableHelper.generateId(condition.getName(), pointOfTime.id(entityId))).collect(Collectors.toList());
        for (String table : tables) {
            StringBuilder sql = new StringBuilder("select id, " + valueColumnName + " from " + table).append(" where id in ").append(ids.stream().map(it -> "?").collect(Collectors.joining(", ", "(", ")")));
            this.jdbcClient.executeQuery(sql.toString(), resultSet -> {
                while (resultSet.next()) {
                    String id = resultSet.getString("id");
                    DataTable multipleValues = new DataTable(5);
                    multipleValues.toObject(resultSet.getString(valueColumnName));
                    idMap.put(id, multipleValues);
                }
                return null;
            }, ids.toArray(new Object[0]));
        }
        return IMetricsQueryDAO.Util.sortValues((List)IMetricsQueryDAO.Util.composeLabelValue((String)condition.getName(), labels, ids, idMap), ids, (int)ValueColumnMetadata.INSTANCE.getDefaultValue(condition.getName()));
    }

    public List<MetricsValues> readLabeledMetricsValuesWithoutEntity(String metricName, String valueColumnName, List<KeyValue> labels, Duration duration) {
        HashMap idMap = new HashMap();
        List<String> tables = this.tableHelper.getTablesForRead(metricName, duration.getStartTimeBucket(), duration.getEndTimeBucket());
        for (String table : tables) {
            StringBuilder sql = new StringBuilder("select id, " + valueColumnName + " from " + table).append(" where ").append("table_name").append(" = ? ").append(" and ").append("time_bucket").append(" >= ? ").append(" and ").append("time_bucket").append(" <= ?").append(" limit ").append(10);
            this.jdbcClient.executeQuery(sql.toString(), resultSet -> {
                while (resultSet.next()) {
                    String id = resultSet.getString("id");
                    DataTable multipleValues = new DataTable(resultSet.getString(valueColumnName));
                    idMap.put(id, multipleValues);
                }
                return null;
            }, new Object[]{metricName, duration.getStartTimeBucket(), duration.getEndTimeBucket()});
        }
        Map<String, DataTable> result = idMap.entrySet().stream().limit(10L).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        ArrayList<String> ids = new ArrayList<String>(result.keySet());
        return IMetricsQueryDAO.Util.sortValues((List)IMetricsQueryDAO.Util.composeLabelValue((String)metricName, labels, ids, result), ids, (int)ValueColumnMetadata.INSTANCE.getDefaultValue(metricName));
    }

    public HeatMap readHeatMap(MetricsCondition condition, String valueColumnName, Duration duration) {
        List<String> tables = this.tableHelper.getTablesForRead(condition.getName(), duration.getStartTimeBucket(), duration.getEndTimeBucket());
        HeatMap heatMap = new HeatMap();
        for (String table : tables) {
            List pointOfTimes = duration.assembleDurationPoints();
            String entityId = condition.getEntity().buildId();
            List<Object> ids = pointOfTimes.stream().map(pointOfTime -> TableHelper.generateId(condition.getName(), pointOfTime.id(entityId))).collect(Collectors.toList());
            StringBuilder sql = new StringBuilder("select id, " + valueColumnName + " dataset, id from " + table).append(" where id in ").append(ids.stream().map(it -> "?").collect(Collectors.joining(", ", "(", ")")));
            int defaultValue = ValueColumnMetadata.INSTANCE.getDefaultValue(condition.getName());
            this.jdbcClient.executeQuery(sql.toString(), resultSet -> {
                while (resultSet.next()) {
                    heatMap.buildColumn(resultSet.getString("id"), resultSet.getString("dataset"), defaultValue);
                }
                heatMap.fixMissingColumns(ids, defaultValue);
                return null;
            }, ids.toArray(new Object[0]));
        }
        return heatMap;
    }

    @Generated
    public JDBCMetricsQueryDAO(JDBCClient jdbcClient, TableHelper tableHelper) {
        this.jdbcClient = jdbcClient;
        this.tableHelper = tableHelper;
    }
}

