/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.attribute;

import java.io.Serializable;
import org.apache.spark.ml.attribute.Attribute;
import org.apache.spark.ml.attribute.AttributeGroup;
import org.apache.spark.ml.attribute.AttributeKeys$;
import org.apache.spark.ml.attribute.AttributeType$;
import org.apache.spark.ml.attribute.BinaryAttribute;
import org.apache.spark.ml.attribute.BinaryAttribute$;
import org.apache.spark.ml.attribute.NominalAttribute;
import org.apache.spark.ml.attribute.NominalAttribute$;
import org.apache.spark.ml.attribute.NumericAttribute;
import org.apache.spark.ml.attribute.NumericAttribute$;
import org.apache.spark.ml.linalg.VectorUDT;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.Metadata;
import org.apache.spark.sql.types.StructField;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class AttributeGroup$
implements scala.Serializable {
    public static AttributeGroup$ MODULE$;

    static {
        new AttributeGroup$();
    }

    public AttributeGroup fromMetadata(Metadata metadata2, String name) {
        if (metadata2.contains(AttributeKeys$.MODULE$.ATTRIBUTES())) {
            int numAttrs = (int)metadata2.getLong(AttributeKeys$.MODULE$.NUM_ATTRIBUTES());
            Attribute[] attributes = new Attribute[numAttrs];
            Metadata attrMetadata = metadata2.getMetadata(AttributeKeys$.MODULE$.ATTRIBUTES());
            if (attrMetadata.contains(AttributeType$.MODULE$.Numeric().name())) {
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])attrMetadata.getMetadataArray(AttributeType$.MODULE$.Numeric().name()))).map((Function1 & Serializable & scala.Serializable)metadata -> NumericAttribute$.MODULE$.fromMetadata((Metadata)metadata), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(NumericAttribute.class))))).foreach((Function1 & Serializable & scala.Serializable)attr -> {
                    attributes[BoxesRunTime.unboxToInt((Object)attr.index().get())] = attr;
                    return BoxedUnit.UNIT;
                });
            }
            if (attrMetadata.contains(AttributeType$.MODULE$.Nominal().name())) {
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])attrMetadata.getMetadataArray(AttributeType$.MODULE$.Nominal().name()))).map((Function1 & Serializable & scala.Serializable)metadata -> NominalAttribute$.MODULE$.fromMetadata((Metadata)metadata), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(NominalAttribute.class))))).foreach((Function1 & Serializable & scala.Serializable)attr -> {
                    attributes[BoxesRunTime.unboxToInt((Object)attr.index().get())] = attr;
                    return BoxedUnit.UNIT;
                });
            }
            if (attrMetadata.contains(AttributeType$.MODULE$.Binary().name())) {
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])attrMetadata.getMetadataArray(AttributeType$.MODULE$.Binary().name()))).map((Function1 & Serializable & scala.Serializable)metadata -> BinaryAttribute$.MODULE$.fromMetadata((Metadata)metadata), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(BinaryAttribute.class))))).foreach((Function1 & Serializable & scala.Serializable)attr -> {
                    attributes[BoxesRunTime.unboxToInt((Object)attr.index().get())] = attr;
                    return BoxedUnit.UNIT;
                });
            }
            for (int i = 0; i < numAttrs; ++i) {
                if (attributes[i] != null) continue;
                attributes[i] = NumericAttribute$.MODULE$.defaultAttr();
            }
            return new AttributeGroup(name, attributes);
        }
        if (metadata2.contains(AttributeKeys$.MODULE$.NUM_ATTRIBUTES())) {
            return new AttributeGroup(name, (int)metadata2.getLong(AttributeKeys$.MODULE$.NUM_ATTRIBUTES()));
        }
        return new AttributeGroup(name);
    }

    public AttributeGroup fromStructField(StructField field) {
        DataType dataType = field.dataType();
        VectorUDT vectorUDT = new VectorUDT();
        Predef$.MODULE$.require(!(dataType != null ? !dataType.equals((Object)vectorUDT) : vectorUDT != null));
        if (field.metadata().contains(AttributeKeys$.MODULE$.ML_ATTR())) {
            return this.fromMetadata(field.metadata().getMetadata(AttributeKeys$.MODULE$.ML_ATTR()), field.name());
        }
        return new AttributeGroup(field.name());
    }

    private Object readResolve() {
        return MODULE$;
    }

    private AttributeGroup$() {
        MODULE$ = this;
    }
}

