/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.kll;

import java.util.Objects;
import org.apache.datasketches.Util;
import org.apache.datasketches.kll.KllDirectCompactFloatsSketch;
import org.apache.datasketches.kll.KllDirectFloatsSketch;
import org.apache.datasketches.kll.KllFloatsHelper;
import org.apache.datasketches.kll.KllFloatsSketchIterator;
import org.apache.datasketches.kll.KllHeapFloatsSketch;
import org.apache.datasketches.kll.KllHelper;
import org.apache.datasketches.kll.KllMemoryValidate;
import org.apache.datasketches.kll.KllPreambleUtil;
import org.apache.datasketches.kll.KllSketch;
import org.apache.datasketches.memory.Memory;
import org.apache.datasketches.memory.MemoryRequestServer;
import org.apache.datasketches.memory.WritableMemory;

public abstract class KllFloatsSketch
extends KllSketch {
    KllFloatsSketch(WritableMemory wmem, MemoryRequestServer memReqSvr) {
        super(KllSketch.SketchType.FLOATS_SKETCH, wmem, memReqSvr);
    }

    public static int getMaxSerializedSizeBytes(int k, long n, boolean updatableMemoryFormat) {
        return KllFloatsSketch.getMaxSerializedSizeBytes(k, n, KllSketch.SketchType.FLOATS_SKETCH, updatableMemoryFormat);
    }

    public static KllFloatsSketch heapify(Memory srcMem) {
        Objects.requireNonNull(srcMem, "Parameter 'srcMem' must not be null");
        if (KllPreambleUtil.getMemoryUpdatableFormatFlag(srcMem)) {
            KllSketch.Error.kllSketchThrow(KllSketch.Error.MUST_NOT_BE_UPDATABLE_FORMAT);
        }
        return KllHeapFloatsSketch.heapifyImpl(srcMem);
    }

    public static KllFloatsSketch newDirectInstance(int k, WritableMemory dstMem, MemoryRequestServer memReqSvr) {
        Objects.requireNonNull(dstMem, "Parameter 'dstMem' must not be null");
        Objects.requireNonNull(memReqSvr, "Parameter 'memReqSvr' must not be null");
        return KllDirectFloatsSketch.newDirectInstance(k, 8, dstMem, memReqSvr);
    }

    public static KllFloatsSketch newDirectInstance(WritableMemory dstMem, MemoryRequestServer memReqSvr) {
        Objects.requireNonNull(dstMem, "Parameter 'dstMem' must not be null");
        Objects.requireNonNull(memReqSvr, "Parameter 'memReqSvr' must not be null");
        return KllDirectFloatsSketch.newDirectInstance(200, 8, dstMem, memReqSvr);
    }

    public static KllFloatsSketch newHeapInstance() {
        return new KllHeapFloatsSketch(200, 8);
    }

    public static KllFloatsSketch newHeapInstance(int k) {
        return new KllHeapFloatsSketch(k, 8);
    }

    public static KllFloatsSketch wrap(Memory srcMem) {
        Objects.requireNonNull(srcMem, "Parameter 'srcMem' must not be null");
        KllMemoryValidate memVal = new KllMemoryValidate(srcMem);
        if (memVal.updatableMemFormat) {
            return new KllDirectFloatsSketch((WritableMemory)srcMem, null, memVal);
        }
        return new KllDirectCompactFloatsSketch(srcMem, memVal);
    }

    public static KllFloatsSketch writableWrap(WritableMemory srcMem, MemoryRequestServer memReqSvr) {
        Objects.requireNonNull(srcMem, "Parameter 'srcMem' must not be null");
        KllMemoryValidate memVal = new KllMemoryValidate((Memory)srcMem);
        if (memVal.updatableMemFormat) {
            if (!memVal.readOnly) {
                Objects.requireNonNull(memReqSvr, "Parameter 'memReqSvr' must not be null");
            }
            return new KllDirectFloatsSketch(srcMem, memReqSvr, memVal);
        }
        return new KllDirectCompactFloatsSketch((Memory)srcMem, memVal);
    }

    public double[] getCDF(float[] splitPoints) {
        return KllFloatsHelper.getFloatsPmfOrCdf(this, splitPoints, true);
    }

    public float getMaxValue() {
        return this.getMaxFloatValue();
    }

    public float getMinValue() {
        return this.getMinFloatValue();
    }

    public double[] getPMF(float[] splitPoints) {
        return KllFloatsHelper.getFloatsPmfOrCdf(this, splitPoints, false);
    }

    public float getQuantile(double fraction) {
        return KllFloatsHelper.getFloatsQuantile(this, fraction);
    }

    public float getQuantileLowerBound(double fraction) {
        return this.getQuantile(Math.max(0.0, fraction - KllHelper.getNormalizedRankError(this.getMinK(), false)));
    }

    public float[] getQuantiles(double[] fractions) {
        return KllFloatsHelper.getFloatsQuantiles(this, fractions);
    }

    public float[] getQuantiles(int numEvenlySpaced) {
        if (this.isEmpty()) {
            return null;
        }
        return this.getQuantiles(Util.evenlySpaced(0.0, 1.0, numEvenlySpaced));
    }

    public float getQuantileUpperBound(double fraction) {
        return this.getQuantile(Math.min(1.0, fraction + KllHelper.getNormalizedRankError(this.getMinK(), false)));
    }

    public double getRank(float value) {
        return KllFloatsHelper.getFloatRank(this, value);
    }

    public KllFloatsSketchIterator iterator() {
        return new KllFloatsSketchIterator(this.getFloatItemsArray(), this.getLevelsArray(), this.getNumLevels());
    }

    public void update(float value) {
        if (this.readOnly) {
            KllSketch.Error.kllSketchThrow(KllSketch.Error.TGT_IS_READ_ONLY);
        }
        KllFloatsHelper.updateFloat(this, value);
    }

    @Override
    double[] getDoubleItemsArray() {
        KllSketch.Error.kllSketchThrow(KllSketch.Error.MUST_NOT_CALL);
        return null;
    }

    @Override
    double getMaxDoubleValue() {
        KllSketch.Error.kllSketchThrow(KllSketch.Error.MUST_NOT_CALL);
        return Double.NaN;
    }

    @Override
    double getMinDoubleValue() {
        KllSketch.Error.kllSketchThrow(KllSketch.Error.MUST_NOT_CALL);
        return Double.NaN;
    }

    @Override
    void setDoubleItemsArray(double[] doubleItems) {
        KllSketch.Error.kllSketchThrow(KllSketch.Error.MUST_NOT_CALL);
    }

    @Override
    void setDoubleItemsArrayAt(int index, double value) {
        KllSketch.Error.kllSketchThrow(KllSketch.Error.MUST_NOT_CALL);
    }

    @Override
    void setMaxDoubleValue(double value) {
        KllSketch.Error.kllSketchThrow(KllSketch.Error.MUST_NOT_CALL);
    }

    @Override
    void setMinDoubleValue(double value) {
        KllSketch.Error.kllSketchThrow(KllSketch.Error.MUST_NOT_CALL);
    }
}

