/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.Chr$;
import org.apache.spark.sql.catalyst.expressions.DefaultStringProducingExpression;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.ImplicitCastInputTypes;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.unsafe.types.UTF8String;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="_FUNC_(expr) - Returns the ASCII character having the binary equivalent to `expr`. If n is larger than 256 the result is equivalent to chr(n % 256)", examples="\n    Examples:\n      > SELECT _FUNC_(65);\n       A\n  ", since="2.3.0", group="string_funcs")
@ScalaSignature(bytes="\u0006\u0005\u0005mf\u0001\u0002\u000e\u001c\u0001\"B\u0001\"\u0012\u0001\u0003\u0016\u0004%\tA\u0012\u0005\t\u0015\u0002\u0011\t\u0012)A\u0005\u000f\")1\n\u0001C\u0001\u0019\")q\n\u0001C!!\")A\u000b\u0001C!+\")q\f\u0001C)A\")a\r\u0001C!!\")q\r\u0001C!Q\")a\u000f\u0001C)o\"9!\u0010AA\u0001\n\u0003Y\bbB?\u0001#\u0003%\tA \u0005\n\u0003'\u0001\u0011\u0011!C!\u0003+A\u0011\"a\n\u0001\u0003\u0003%\t!!\u000b\t\u0013\u0005E\u0002!!A\u0005\u0002\u0005M\u0002\"CA\u001d\u0001\u0005\u0005I\u0011IA\u001e\u0011%\tI\u0005AA\u0001\n\u0003\tY\u0005C\u0005\u0002P\u0001\t\t\u0011\"\u0011\u0002R!I\u0011Q\u000b\u0001\u0002\u0002\u0013\u0005\u0013qK\u0004\n\u0003wZ\u0012\u0011!E\u0001\u0003{2\u0001BG\u000e\u0002\u0002#\u0005\u0011q\u0010\u0005\u0007\u0017R!\t!a&\t\u0013\u0005eE#!A\u0005F\u0005m\u0005\"CAO)\u0005\u0005I\u0011QAP\u0011%\t\u0019\u000bFA\u0001\n\u0003\u000b)\u000bC\u0005\u00022R\t\t\u0011\"\u0003\u00024\n\u00191\t\u001b:\u000b\u0005qi\u0012aC3yaJ,7o]5p]NT!AH\u0010\u0002\u0011\r\fG/\u00197zgRT!\u0001I\u0011\u0002\u0007M\fHN\u0003\u0002#G\u0005)1\u000f]1sW*\u0011A%J\u0001\u0007CB\f7\r[3\u000b\u0003\u0019\n1a\u001c:h\u0007\u0001\u0019b\u0001A\u0015.aMJ\u0004C\u0001\u0016,\u001b\u0005Y\u0012B\u0001\u0017\u001c\u0005=)f.\u0019:z\u000bb\u0004(/Z:tS>t\u0007C\u0001\u0016/\u0013\ty3D\u0001\fJ[Bd\u0017nY5u\u0007\u0006\u001cH/\u00138qkR$\u0016\u0010]3t!\tQ\u0013'\u0003\u000237\t\u0001C)\u001a4bk2$8\u000b\u001e:j]\u001e\u0004&o\u001c3vG&tw-\u0012=qe\u0016\u001c8/[8o!\t!t'D\u00016\u0015\u00051\u0014!B:dC2\f\u0017B\u0001\u001d6\u0005\u001d\u0001&o\u001c3vGR\u0004\"A\u000f\"\u000f\u0005m\u0002eB\u0001\u001f@\u001b\u0005i$B\u0001 (\u0003\u0019a$o\\8u}%\ta'\u0003\u0002Bk\u00059\u0001/Y2lC\u001e,\u0017BA\"E\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t\tU'A\u0003dQ&dG-F\u0001H!\tQ\u0003*\u0003\u0002J7\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\r\rD\u0017\u000e\u001c3!\u0003\u0019a\u0014N\\5u}Q\u0011QJ\u0014\t\u0003U\u0001AQ!R\u0002A\u0002\u001d\u000baB\\;mY&sGo\u001c7fe\u0006tG/F\u0001R!\t!$+\u0003\u0002Tk\t9!i\\8mK\u0006t\u0017AC5oaV$H+\u001f9fgV\ta\u000bE\u0002;/fK!\u0001\u0017#\u0003\u0007M+\u0017\u000f\u0005\u0002[;6\t1L\u0003\u0002]?\u0005)A/\u001f9fg&\u0011al\u0017\u0002\t\t\u0006$\u0018\rV=qK\u0006aa.\u001e7m'\u00064W-\u0012<bYR\u0011\u0011\r\u001a\t\u0003i\tL!aY\u001b\u0003\u0007\u0005s\u0017\u0010C\u0003f\r\u0001\u0007\u0011-A\u0002m_:\f!dY8oi\u0016DH/\u00138eKB,g\u000eZ3oi\u001a{G\u000eZ1cY\u0016\f\u0011\u0002Z8HK:\u001cu\u000eZ3\u0015\u0007%|G\u000f\u0005\u0002k[6\t1N\u0003\u0002m7\u000591m\u001c3fO\u0016t\u0017B\u00018l\u0005!)\u0005\u0010\u001d:D_\u0012,\u0007\"\u00029\t\u0001\u0004\t\u0018aA2uqB\u0011!N]\u0005\u0003g.\u0014abQ8eK\u001e,gnQ8oi\u0016DH\u000fC\u0003v\u0011\u0001\u0007\u0011.\u0001\u0002fm\u0006!r/\u001b;i\u001d\u0016<8\t[5mI&sG/\u001a:oC2$\"!\u0014=\t\u000beL\u0001\u0019A$\u0002\u00119,wo\u00115jY\u0012\fAaY8qsR\u0011Q\n \u0005\b\u000b*\u0001\n\u00111\u0001H\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uIE*\u0012a \u0016\u0004\u000f\u0006\u00051FAA\u0002!\u0011\t)!a\u0004\u000e\u0005\u0005\u001d!\u0002BA\u0005\u0003\u0017\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u00055Q'\u0001\u0006b]:|G/\u0019;j_:LA!!\u0005\u0002\b\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\t9\u0002\u0005\u0003\u0002\u001a\u0005\rRBAA\u000e\u0015\u0011\ti\"a\b\u0002\t1\fgn\u001a\u0006\u0003\u0003C\tAA[1wC&!\u0011QEA\u000e\u0005\u0019\u0019FO]5oO\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011\u00111\u0006\t\u0004i\u00055\u0012bAA\u0018k\t\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR\u0019\u0011-!\u000e\t\u0013\u0005]b\"!AA\u0002\u0005-\u0012a\u0001=%c\u0005y\u0001O]8ek\u000e$\u0018\n^3sCR|'/\u0006\u0002\u0002>A)\u0011qHA#C6\u0011\u0011\u0011\t\u0006\u0004\u0003\u0007*\u0014AC2pY2,7\r^5p]&!\u0011qIA!\u0005!IE/\u001a:bi>\u0014\u0018\u0001C2b]\u0016\u000bX/\u00197\u0015\u0007E\u000bi\u0005\u0003\u0005\u00028A\t\t\u00111\u0001b\u0003I\u0001(o\u001c3vGR,E.Z7f]Rt\u0015-\\3\u0015\t\u0005]\u00111\u000b\u0005\n\u0003o\t\u0012\u0011!a\u0001\u0003W\ta!Z9vC2\u001cHcA)\u0002Z!A\u0011q\u0007\n\u0002\u0002\u0003\u0007\u0011\rK\n\u0001\u0003;\n\u0019'!\u001a\u0002j\u0005-\u0014qNA9\u0003k\n9\bE\u0002+\u0003?J1!!\u0019\u001c\u0005U)\u0005\u0010\u001d:fgNLwN\u001c#fg\u000e\u0014\u0018\u000e\u001d;j_:\fQ!^:bO\u0016\f#!a\u001a\u0002\u0003Oyf)\u0016(D?\"*\u0007\u0010\u001d:*A5\u0002#+\u001a;ve:\u001c\b\u0005\u001e5fA\u0005\u001b6)S%!G\"\f'/Y2uKJ\u0004\u0003.\u0019<j]\u001e\u0004C\u000f[3!E&t\u0017M]=!KF,\u0018N^1mK:$\b\u0005^8!A\u0016D\bO\u001d1/A%3\u0007E\u001c\u0011jg\u0002b\u0017M]4fe\u0002\"\b.\u00198!eU2\u0004\u0005\u001e5fAI,7/\u001e7uA%\u001c\b%Z9vSZ\fG.\u001a8uAQ|\u0007e\u00195sQ9\u0004S\u0005\t\u001a6m%\n\u0001\"\u001a=b[BdWm]\u0011\u0003\u0003[\nQG\u0003\u0011!A\u0001*\u00050Y7qY\u0016\u001c(H\u0003\u0011!A\u0001\u0002\u0003E\u0010\u0011T\u000b2+5\t\u0016\u0011`\rVs5i\u0018\u00157k%Z$\u0002\t\u0011!A\u0001\u0002\u0003%\u0011\u0006!A\u0005)1/\u001b8dK\u0006\u0012\u00111O\u0001\u0006e9\u001ad\u0006M\u0001\u0006OJ|W\u000f]\u0011\u0003\u0003s\nAb\u001d;sS:<wLZ;oGN\f1a\u00115s!\tQCcE\u0003\u0015\u0003\u0003\u000bi\t\u0005\u0004\u0002\u0004\u0006%u)T\u0007\u0003\u0003\u000bS1!a\"6\u0003\u001d\u0011XO\u001c;j[\u0016LA!a#\u0002\u0006\n\t\u0012IY:ue\u0006\u001cGOR;oGRLwN\\\u0019\u0011\t\u0005=\u0015QS\u0007\u0003\u0003#SA!a%\u0002 \u0005\u0011\u0011n\\\u0005\u0004\u0007\u0006EECAA?\u0003!!xn\u0015;sS:<GCAA\f\u0003\u0015\t\u0007\u000f\u001d7z)\ri\u0015\u0011\u0015\u0005\u0006\u000b^\u0001\raR\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\t9+!,\u0011\tQ\nIkR\u0005\u0004\u0003W+$AB(qi&|g\u000e\u0003\u0005\u00020b\t\t\u00111\u0001N\u0003\rAH\u0005M\u0001\roJLG/\u001a*fa2\f7-\u001a\u000b\u0003\u0003k\u0003B!!\u0007\u00028&!\u0011\u0011XA\u000e\u0005\u0019y%M[3di\u0002")
public class Chr
extends UnaryExpression
implements ImplicitCastInputTypes,
DefaultStringProducingExpression,
Serializable {
    private final Expression child;

    public static Option<Expression> unapply(Chr x$0) {
        return Chr$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Expression, A> andThen(Function1<Chr, A> g) {
        return Chr$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, Chr> compose(Function1<A$, Expression> g) {
        return Chr$.MODULE$.compose(g);
    }

    @Override
    public DataType dataType() {
        return DefaultStringProducingExpression.dataType$(this);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    public Seq<DataType> inputTypes() {
        return new .colon.colon((Object)LongType$.MODULE$, (List)Nil$.MODULE$);
    }

    @Override
    public Object nullSafeEval(Object lon) {
        long longVal = BoxesRunTime.unboxToLong((Object)lon);
        if (longVal < 0L) {
            return UTF8String.EMPTY_UTF8;
        }
        if ((longVal & 0xFFL) == 0L) {
            return UTF8String.fromString((String)Character.toString('\u0000'));
        }
        return UTF8String.fromString((String)Character.toString((char)(longVal & 0xFFL)));
    }

    @Override
    public boolean contextIndependentFoldable() {
        return this.child().contextIndependentFoldable();
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return this.nullSafeCodeGen(ctx, ev, (Function1<String, String>)(Function1 & Serializable)lon -> "\n        if (" + lon + " < 0) {\n          " + ev.value() + " = UTF8String.EMPTY_UTF8;\n        } else if ((" + lon + " & 0xFF) == 0) {\n          " + ev.value() + " = UTF8String.fromString(String.valueOf(Character.MIN_VALUE));\n        } else {\n          char c = (char)(" + lon + " & 0xFF);\n          " + ev.value() + " = UTF8String.fromString(String.valueOf(c));\n        }\n      ");
    }

    @Override
    public Chr withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    public Chr copy(Expression child) {
        return new Chr(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "Chr";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof Chr;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof Chr)) return false;
        boolean bl = true;
        if (!bl) return false;
        Chr chr = (Chr)x$1;
        Expression expression = this.child();
        Expression expression2 = chr.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!chr.canEqual(this)) return false;
        return true;
    }

    public Chr(Expression child) {
        this.child = child;
        ExpectsInputTypes.$init$(this);
        DefaultStringProducingExpression.$init$(this);
    }
}

