/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.ml.classification;

import breeze.linalg.DenseVector;
import breeze.linalg.DenseVector$;
import breeze.math.MutableEnumeratedCoordinateField;
import breeze.optimize.CachedDiffFunction;
import breeze.optimize.FirstOrderMinimizer;
import breeze.optimize.OWLQN;
import breeze.optimize.StochasticDiffFunction;
import java.io.IOException;
import java.io.Serializable;
import org.apache.spark.SparkException;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.ml.classification.Classifier;
import org.apache.spark.ml.classification.LinearSVC$;
import org.apache.spark.ml.classification.LinearSVCModel;
import org.apache.spark.ml.classification.LinearSVCParams;
import org.apache.spark.ml.feature.Instance;
import org.apache.spark.ml.feature.InstanceBlock;
import org.apache.spark.ml.feature.InstanceBlock$;
import org.apache.spark.ml.feature.StandardScalerModel$;
import org.apache.spark.ml.linalg.BLAS$;
import org.apache.spark.ml.linalg.Vector;
import org.apache.spark.ml.linalg.Vectors$;
import org.apache.spark.ml.optim.aggregator.HingeBlockAggregator;
import org.apache.spark.ml.optim.loss.L2Regularization;
import org.apache.spark.ml.optim.loss.RDDLossFunction;
import org.apache.spark.ml.param.BooleanParam;
import org.apache.spark.ml.param.DoubleParam;
import org.apache.spark.ml.param.IntParam;
import org.apache.spark.ml.param.Param;
import org.apache.spark.ml.param.ParamMap;
import org.apache.spark.ml.param.shared.HasAggregationDepth;
import org.apache.spark.ml.param.shared.HasFitIntercept;
import org.apache.spark.ml.param.shared.HasMaxBlockSizeInMB;
import org.apache.spark.ml.param.shared.HasMaxIter;
import org.apache.spark.ml.param.shared.HasRegParam;
import org.apache.spark.ml.param.shared.HasStandardization;
import org.apache.spark.ml.param.shared.HasThreshold;
import org.apache.spark.ml.param.shared.HasTol;
import org.apache.spark.ml.param.shared.HasWeightCol;
import org.apache.spark.ml.stat.MultiClassSummarizer;
import org.apache.spark.ml.stat.Summarizer$;
import org.apache.spark.ml.stat.SummarizerBuffer;
import org.apache.spark.ml.util.DatasetUtils$;
import org.apache.spark.ml.util.DefaultParamsWritable;
import org.apache.spark.ml.util.Identifiable$;
import org.apache.spark.ml.util.Instrumentation;
import org.apache.spark.ml.util.Instrumentation$;
import org.apache.spark.ml.util.MLReader;
import org.apache.spark.ml.util.MLWritable;
import org.apache.spark.ml.util.MLWriter;
import org.apache.spark.ml.util.MetadataUtils$;
import org.apache.spark.mllib.util.MLUtils$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuilder;
import scala.collection.mutable.ArrayBuilder$;
import scala.math.Ordering;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0005\t\u001dc\u0001\u0002\r\u001a\u0001\u0011B\u0001\u0002\u0010\u0001\u0003\u0006\u0004%\t%\u0010\u0005\t)\u0002\u0011\t\u0011)A\u0005}!)a\u000b\u0001C\u0001/\")a\u000b\u0001C\u00017\")Q\f\u0001C\u0001=\")q\r\u0001C\u0001Q\")a\u000e\u0001C\u0001_\")Q\u000f\u0001C\u0001m\")\u0011\u0010\u0001C\u0001u\")Q\u0010\u0001C\u0001}\"9\u00111\u0001\u0001\u0005\u0002\u0005\u0015\u0001bBA\u0006\u0001\u0011\u0005\u0011Q\u0002\u0005\b\u0003'\u0001A\u0011AA\u000b\u0011!\ty\u0002\u0001C!;\u0005\u0005\u0002bBA)\u0001\u0011\u0005\u00131\u000b\u0005\b\u0003O\u0002A\u0011KA5\u0011\u001d\t9\b\u0001C\u0005\u0003sBq!!'\u0001\t\u0013\tYjB\u0004\u0003\u0006eA\tAa\u0002\u0007\raI\u0002\u0012\u0001B\u0005\u0011\u00191F\u0003\"\u0001\u0003(!9!\u0011\u0006\u000b\u0005B\t-\u0002\"\u0003B\u001a)\u0005\u0005I\u0011\u0002B\u001b\u0005%a\u0015N\\3beN36I\u0003\u0002\u001b7\u0005q1\r\\1tg&4\u0017nY1uS>t'B\u0001\u000f\u001e\u0003\tiGN\u0003\u0002\u001f?\u0005)1\u000f]1sW*\u0011\u0001%I\u0001\u0007CB\f7\r[3\u000b\u0003\t\n1a\u001c:h\u0007\u0001\u0019B\u0001A\u00134mA)aeJ\u00150a5\t\u0011$\u0003\u0002)3\tQ1\t\\1tg&4\u0017.\u001a:\u0011\u0005)jS\"A\u0016\u000b\u00051Z\u0012A\u00027j]\u0006dw-\u0003\u0002/W\t1a+Z2u_J\u0004\"A\n\u0001\u0011\u0005\u0019\n\u0014B\u0001\u001a\u001a\u00059a\u0015N\\3beN36)T8eK2\u0004\"A\n\u001b\n\u0005UJ\"a\u0004'j]\u0016\f'o\u0015,D!\u0006\u0014\u0018-\\:\u0011\u0005]RT\"\u0001\u001d\u000b\u0005eZ\u0012\u0001B;uS2L!a\u000f\u001d\u0003+\u0011+g-Y;miB\u000b'/Y7t/JLG/\u00192mK\u0006\u0019Q/\u001b3\u0016\u0003y\u0002\"a\u0010%\u000f\u0005\u00013\u0005CA!E\u001b\u0005\u0011%BA\"$\u0003\u0019a$o\\8u})\tQ)A\u0003tG\u0006d\u0017-\u0003\u0002H\t\u00061\u0001K]3eK\u001aL!!\u0013&\u0003\rM#(/\u001b8h\u0015\t9E\tK\u0002\u0002\u0019J\u0003\"!\u0014)\u000e\u00039S!aT\u000f\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0002R\u001d\n)1+\u001b8dK\u0006\n1+A\u00033]Ir\u0003'\u0001\u0003vS\u0012\u0004\u0003f\u0001\u0002M%\u00061A(\u001b8jiz\"\"a\f-\t\u000bq\u001a\u0001\u0019\u0001 )\u0007ac%\u000bK\u0002\u0004\u0019J#\u0012a\f\u0015\u0004\t1\u0013\u0016aC:fiJ+w\rU1sC6$\"a\u00181\u000e\u0003\u0001AQ!Y\u0003A\u0002\t\fQA^1mk\u0016\u0004\"a\u00193\u000e\u0003\u0011K!!\u001a#\u0003\r\u0011{WO\u00197fQ\r)AJU\u0001\u000bg\u0016$X*\u0019=Ji\u0016\u0014HCA0j\u0011\u0015\tg\u00011\u0001k!\t\u00197.\u0003\u0002m\t\n\u0019\u0011J\u001c;)\u0007\u0019a%+A\btKR4\u0015\u000e^%oi\u0016\u00148-\u001a9u)\ty\u0006\u000fC\u0003b\u000f\u0001\u0007\u0011\u000f\u0005\u0002de&\u00111\u000f\u0012\u0002\b\u0005>|G.Z1oQ\r9AJU\u0001\u0007g\u0016$Hk\u001c7\u0015\u0005};\b\"B1\t\u0001\u0004\u0011\u0007f\u0001\u0005M%\u0006\u00112/\u001a;Ti\u0006tG-\u0019:eSj\fG/[8o)\ty6\u0010C\u0003b\u0013\u0001\u0007\u0011\u000fK\u0002\n\u0019J\u000bAb]3u/\u0016Lw\r\u001b;D_2$\"aX@\t\u000b\u0005T\u0001\u0019\u0001 )\u0007)a%+\u0001\u0007tKR$\u0006N]3tQ>dG\rF\u0002`\u0003\u000fAQ!Y\u0006A\u0002\tD3a\u0003'S\u0003M\u0019X\r^!hOJ,w-\u0019;j_:$U\r\u001d;i)\ry\u0016q\u0002\u0005\u0006C2\u0001\rA\u001b\u0015\u0004\u00191\u0013\u0016aE:fi6\u000b\u0007P\u00117pG.\u001c\u0016N_3J]6\u0013EcA0\u0002\u0018!)\u0011-\u0004a\u0001E\"\"Q\u0002TA\u000eC\t\ti\"A\u00034]Er\u0003'A\tfgRLW.\u0019;f\u001b>$W\r\\*ju\u0016$B!a\t\u0002*A\u00191-!\n\n\u0007\u0005\u001dBI\u0001\u0003M_:<\u0007bBA\u0016\u001d\u0001\u0007\u0011QF\u0001\bI\u0006$\u0018m]3ua\u0011\ty#a\u0010\u0011\r\u0005E\u0012qGA\u001e\u001b\t\t\u0019DC\u0002\u00026u\t1a]9m\u0013\u0011\tI$a\r\u0003\u000f\u0011\u000bG/Y:fiB!\u0011QHA \u0019\u0001!A\"!\u0011\u0002*\u0005\u0005\t\u0011!B\u0001\u0003\u0007\u00121a\u0018\u00132#\u0011\t)%a\u0013\u0011\u0007\r\f9%C\u0002\u0002J\u0011\u0013qAT8uQ&tw\rE\u0002d\u0003\u001bJ1!a\u0014E\u0005\r\te._\u0001\u0005G>\u0004\u0018\u0010F\u00020\u0003+Bq!a\u0016\u0010\u0001\u0004\tI&A\u0003fqR\u0014\u0018\r\u0005\u0003\u0002\\\u0005\u0005TBAA/\u0015\r\tyfG\u0001\u0006a\u0006\u0014\u0018-\\\u0005\u0005\u0003G\niF\u0001\u0005QCJ\fW.T1qQ\ryAJU\u0001\u0006iJ\f\u0017N\u001c\u000b\u0004a\u0005-\u0004bBA\u0016!\u0001\u0007\u0011Q\u000e\u0019\u0005\u0003_\n\u0019\b\u0005\u0004\u00022\u0005]\u0012\u0011\u000f\t\u0005\u0003{\t\u0019\b\u0002\u0007\u0002v\u0005-\u0014\u0011!A\u0001\u0006\u0003\t\u0019EA\u0002`II\n1b\u0019:fCR,Wj\u001c3fYRI\u0001'a\u001f\u0002\b\u0006-\u0015q\u0012\u0005\b\u0003W\t\u0002\u0019AA?a\u0011\ty(a!\u0011\r\u0005E\u0012qGAA!\u0011\ti$a!\u0005\u0019\u0005\u0015\u00151PA\u0001\u0002\u0003\u0015\t!a\u0011\u0003\u0007}#3\u0007\u0003\u0004\u0002\nF\u0001\r!K\u0001\rG>,gMZ5dS\u0016tGo\u001d\u0005\u0007\u0003\u001b\u000b\u0002\u0019\u00012\u0002\u0013%tG/\u001a:dKB$\bbBAI#\u0001\u0007\u00111S\u0001\u0011_\nTWm\u0019;jm\u0016D\u0015n\u001d;pef\u0004BaYAKE&\u0019\u0011q\u0013#\u0003\u000b\u0005\u0013(/Y=\u0002\u0013Q\u0014\u0018-\u001b8J[BdGCDAO\u0003G\u000by,a1\u0002H\u0006-\u0017Q\u001d\t\bG\u0006}\u00151SAJ\u0013\r\t\t\u000b\u0012\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\u0005\u0015&\u00031\u0001\u0002(\u0006I\u0011N\\:uC:\u001cWm\u001d\t\u0007\u0003S\u000by+a-\u000e\u0005\u0005-&bAAW;\u0005\u0019!\u000f\u001a3\n\t\u0005E\u00161\u0016\u0002\u0004%\u0012#\u0005\u0003BA[\u0003wk!!a.\u000b\u0007\u0005e6$A\u0004gK\u0006$XO]3\n\t\u0005u\u0016q\u0017\u0002\t\u0013:\u001cH/\u00198dK\"1\u0011\u0011\u0019\nA\u0002\t\f1#Y2uk\u0006d'\t\\8dWNK'0Z%o\u001b\nCq!!2\u0013\u0001\u0004\t\u0019*A\u0006gK\u0006$XO]3t'R$\u0007bBAe%\u0001\u0007\u00111S\u0001\rM\u0016\fG/\u001e:fg6+\u0017M\u001c\u0005\b\u0003\u001b\u0014\u0002\u0019AAh\u00039\u0011XmZ;mCJL'0\u0019;j_:\u0004RaYAi\u0003+L1!a5E\u0005\u0019y\u0005\u000f^5p]B!\u0011q[Aq\u001b\t\tIN\u0003\u0003\u0002\\\u0006u\u0017\u0001\u00027pgNT1!a8\u001c\u0003\u0015y\u0007\u000f^5n\u0013\u0011\t\u0019/!7\u0003!1\u0013$+Z4vY\u0006\u0014\u0018N_1uS>t\u0007bBAt%\u0001\u0007\u0011\u0011^\u0001\n_B$\u0018.\\5{KJ\u0004r!a;\u0002v*\fI0\u0004\u0002\u0002n*!\u0011q^Ay\u0003!y\u0007\u000f^5nSj,'BAAz\u0003\u0019\u0011'/Z3{K&!\u0011q_Aw\u0005\u0015yu\u000bT)O!\u0015\tY0a@c\u001b\t\tiPC\u0002-\u0003cLAA!\u0001\u0002~\nYA)\u001a8tKZ+7\r^8sQ\r\u0001AJU\u0001\n\u0019&tW-\u0019:T-\u000e\u0003\"A\n\u000b\u0014\u000fQ\u0011YA!\u0005\u0003\u0018A\u00191M!\u0004\n\u0007\t=AI\u0001\u0004B]f\u0014VM\u001a\t\u0005o\tMq&C\u0002\u0003\u0016a\u0012Q\u0003R3gCVdG\u000fU1sC6\u001c(+Z1eC\ndW\r\u0005\u0003\u0003\u001a\t\rRB\u0001B\u000e\u0015\u0011\u0011iBa\b\u0002\u0005%|'B\u0001B\u0011\u0003\u0011Q\u0017M^1\n\t\t\u0015\"1\u0004\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u000b\u0003\u0005\u000f\tA\u0001\\8bIR\u0019qF!\f\t\r\t=b\u00031\u0001?\u0003\u0011\u0001\u0018\r\u001e5)\u0007Ya%+\u0001\u0007xe&$XMU3qY\u0006\u001cW\r\u0006\u0002\u00038A!!\u0011\bB \u001b\t\u0011YD\u0003\u0003\u0003>\t}\u0011\u0001\u00027b]\u001eLAA!\u0011\u0003<\t1qJ\u00196fGRD3\u0001\u0006'SQ\r\u0019BJ\u0015")
public class LinearSVC
extends Classifier<Vector, LinearSVC, LinearSVCModel>
implements LinearSVCParams,
DefaultParamsWritable {
    private final String uid;
    private DoubleParam threshold;
    private DoubleParam maxBlockSizeInMB;
    private IntParam aggregationDepth;
    private Param<String> weightCol;
    private BooleanParam standardization;
    private DoubleParam tol;
    private BooleanParam fitIntercept;
    private IntParam maxIter;
    private DoubleParam regParam;

    public static LinearSVC load(String path) {
        return LinearSVC$.MODULE$.load(path);
    }

    public static MLReader<LinearSVC> read() {
        return LinearSVC$.MODULE$.read();
    }

    @Override
    public MLWriter write() {
        return DefaultParamsWritable.write$(this);
    }

    @Override
    public void save(String path) throws IOException {
        MLWritable.save$(this, path);
    }

    @Override
    public final double getMaxBlockSizeInMB() {
        return HasMaxBlockSizeInMB.getMaxBlockSizeInMB$(this);
    }

    @Override
    public double getThreshold() {
        return HasThreshold.getThreshold$(this);
    }

    @Override
    public final int getAggregationDepth() {
        return HasAggregationDepth.getAggregationDepth$(this);
    }

    @Override
    public final String getWeightCol() {
        return HasWeightCol.getWeightCol$(this);
    }

    @Override
    public final boolean getStandardization() {
        return HasStandardization.getStandardization$(this);
    }

    @Override
    public final double getTol() {
        return HasTol.getTol$(this);
    }

    @Override
    public final boolean getFitIntercept() {
        return HasFitIntercept.getFitIntercept$(this);
    }

    @Override
    public final int getMaxIter() {
        return HasMaxIter.getMaxIter$(this);
    }

    @Override
    public final double getRegParam() {
        return HasRegParam.getRegParam$(this);
    }

    @Override
    public final DoubleParam threshold() {
        return this.threshold;
    }

    @Override
    public final void org$apache$spark$ml$classification$LinearSVCParams$_setter_$threshold_$eq(DoubleParam x$1) {
        this.threshold = x$1;
    }

    @Override
    public final DoubleParam maxBlockSizeInMB() {
        return this.maxBlockSizeInMB;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxBlockSizeInMB$_setter_$maxBlockSizeInMB_$eq(DoubleParam x$1) {
        this.maxBlockSizeInMB = x$1;
    }

    @Override
    public void org$apache$spark$ml$param$shared$HasThreshold$_setter_$threshold_$eq(DoubleParam x$1) {
    }

    @Override
    public final IntParam aggregationDepth() {
        return this.aggregationDepth;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasAggregationDepth$_setter_$aggregationDepth_$eq(IntParam x$1) {
        this.aggregationDepth = x$1;
    }

    @Override
    public final Param<String> weightCol() {
        return this.weightCol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasWeightCol$_setter_$weightCol_$eq(Param<String> x$1) {
        this.weightCol = x$1;
    }

    @Override
    public final BooleanParam standardization() {
        return this.standardization;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasStandardization$_setter_$standardization_$eq(BooleanParam x$1) {
        this.standardization = x$1;
    }

    @Override
    public final DoubleParam tol() {
        return this.tol;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasTol$_setter_$tol_$eq(DoubleParam x$1) {
        this.tol = x$1;
    }

    @Override
    public final BooleanParam fitIntercept() {
        return this.fitIntercept;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasFitIntercept$_setter_$fitIntercept_$eq(BooleanParam x$1) {
        this.fitIntercept = x$1;
    }

    @Override
    public final IntParam maxIter() {
        return this.maxIter;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasMaxIter$_setter_$maxIter_$eq(IntParam x$1) {
        this.maxIter = x$1;
    }

    @Override
    public final DoubleParam regParam() {
        return this.regParam;
    }

    @Override
    public final void org$apache$spark$ml$param$shared$HasRegParam$_setter_$regParam_$eq(DoubleParam x$1) {
        this.regParam = x$1;
    }

    @Override
    public String uid() {
        return this.uid;
    }

    public LinearSVC setRegParam(double value) {
        return (LinearSVC)this.set(this.regParam(), BoxesRunTime.boxToDouble((double)value));
    }

    public LinearSVC setMaxIter(int value) {
        return (LinearSVC)this.set(this.maxIter(), BoxesRunTime.boxToInteger((int)value));
    }

    public LinearSVC setFitIntercept(boolean value) {
        return (LinearSVC)this.set(this.fitIntercept(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public LinearSVC setTol(double value) {
        return (LinearSVC)this.set(this.tol(), BoxesRunTime.boxToDouble((double)value));
    }

    public LinearSVC setStandardization(boolean value) {
        return (LinearSVC)this.set(this.standardization(), BoxesRunTime.boxToBoolean((boolean)value));
    }

    public LinearSVC setWeightCol(String value) {
        return (LinearSVC)this.set(this.weightCol(), value);
    }

    public LinearSVC setThreshold(double value) {
        return (LinearSVC)this.set(this.threshold(), BoxesRunTime.boxToDouble((double)value));
    }

    public LinearSVC setAggregationDepth(int value) {
        return (LinearSVC)this.set(this.aggregationDepth(), BoxesRunTime.boxToInteger((int)value));
    }

    public LinearSVC setMaxBlockSizeInMB(double value) {
        return (LinearSVC)this.set(this.maxBlockSizeInMB(), BoxesRunTime.boxToDouble((double)value));
    }

    @Override
    public long estimateModelSize(Dataset<?> dataset) {
        int numFeatures = DatasetUtils$.MODULE$.getNumFeatures(dataset, this.$(this.featuresCol()));
        long size = this.estimateMatadataSize();
        return size += Vectors$.MODULE$.getDenseSize((long)numFeatures);
    }

    @Override
    public LinearSVC copy(ParamMap extra) {
        return (LinearSVC)this.defaultCopy(extra);
    }

    @Override
    public LinearSVCModel train(Dataset<?> dataset) {
        return (LinearSVCModel)Instrumentation$.MODULE$.instrumented((Function1 & Serializable)instr -> {
            None$ none$;
            int n;
            Option<Object> option;
            RDD instances;
            Tuple2<SummarizerBuffer, MultiClassSummarizer> tuple2;
            instr.logPipelineStage(this);
            instr.logDataset(dataset);
            instr.logParams(this, (Seq<Param<?>>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Param[]{this.labelCol(), this.weightCol(), this.featuresCol(), this.predictionCol(), this.rawPredictionCol(), this.regParam(), this.maxIter(), this.fitIntercept(), this.tol(), this.standardization(), this.threshold(), this.aggregationDepth(), this.maxBlockSizeInMB()}));
            StorageLevel storageLevel = dataset.storageLevel();
            StorageLevel storageLevel2 = StorageLevel$.MODULE$.NONE();
            if (storageLevel == null ? storageLevel2 != null : !storageLevel.equals(storageLevel2)) {
                instr.logWarning((Function0<String>)(Function0 & Serializable)() -> "Input instances will be standardized, blockified to blocks, and then cached during training. Be careful of double caching!");
            }
            if ((tuple2 = Summarizer$.MODULE$.getClassificationSummarizers((RDD<Instance>)(instances = dataset.select((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Column[]{DatasetUtils$.MODULE$.checkClassificationLabels(this.$(this.labelCol()), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)2))), DatasetUtils$.MODULE$.checkNonNegativeWeights(this.get(this.weightCol())), DatasetUtils$.MODULE$.checkNonNanVectors(this.$(this.featuresCol()))})).rdd().map((Function1 & Serializable)x0$1 -> {
                Some some;
                Row row = x0$1;
                if (row != null && !(some = Row$.MODULE$.unapplySeq(row)).isEmpty() && some.get() != null && ((SeqOps)some.get()).lengthCompare(3) == 0) {
                    Object l = ((SeqOps)some.get()).apply(0);
                    Object w = ((SeqOps)some.get()).apply(1);
                    Object v = ((SeqOps)some.get()).apply(2);
                    if (l instanceof Double) {
                        double d = BoxesRunTime.unboxToDouble((Object)l);
                        if (w instanceof Double) {
                            double d2 = BoxesRunTime.unboxToDouble((Object)w);
                            if (v instanceof Vector) {
                                Vector vector = (Vector)v;
                                return new Instance(d, d2, vector);
                            }
                        }
                    }
                }
                throw new MatchError((Object)row);
            }, ClassTag$.MODULE$.apply(Instance.class)).setName("training instances")), BoxesRunTime.unboxToInt((Object)this.$(this.aggregationDepth())), (Seq<String>)new .colon.colon((Object)"mean", (List)new .colon.colon((Object)"std", (List)new .colon.colon((Object)"count", (List)Nil$.MODULE$))))) == null) {
                throw new MatchError(tuple2);
            }
            SummarizerBuffer summarizer = (SummarizerBuffer)tuple2._1();
            MultiClassSummarizer labelSummarizer = (MultiClassSummarizer)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)summarizer, (Object)labelSummarizer);
            SummarizerBuffer summarizer2 = (SummarizerBuffer)tuple22._1();
            MultiClassSummarizer labelSummarizer2 = (MultiClassSummarizer)tuple22._2();
            double[] histogram = labelSummarizer2.histogram();
            long numInvalid = labelSummarizer2.countInvalid();
            int numFeatures = summarizer2.mean().size();
            instr.logNumExamples(summarizer2.count());
            instr.logNamedValue("lowestLabelWeight", Predef$.MODULE$.wrapDoubleArray(labelSummarizer2.histogram()).min((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$).toString());
            instr.logNamedValue("highestLabelWeight", Predef$.MODULE$.wrapDoubleArray(labelSummarizer2.histogram()).max((Ordering)Ordering.DeprecatedDoubleOrdering$.MODULE$).toString());
            instr.logSumOfWeights(summarizer2.weightSum());
            double actualBlockSizeInMB = BoxesRunTime.unboxToDouble((Object)this.$(this.maxBlockSizeInMB()));
            if (actualBlockSizeInMB == 0.0) {
                actualBlockSizeInMB = InstanceBlock$.MODULE$.DefaultBlockSizeInMB();
                Predef$.MODULE$.require(actualBlockSizeInMB > 0.0, (Function0 & Serializable)() -> "inferred actual BlockSizeInMB must > 0");
                instr.logNamedValue("actualBlockSizeInMB", Double.toString(actualBlockSizeInMB));
            }
            if ((option = MetadataUtils$.MODULE$.getNumClasses(dataset.schema().apply(this.$(this.labelCol())))) instanceof Some) {
                Some some = (Some)option;
                int n2 = BoxesRunTime.unboxToInt((Object)some.value());
                int n3 = n2;
                Predef$.MODULE$.require(n3 >= histogram.length, (Function0 & Serializable)() -> "Specified number of classes " + n3 + " was less than the number of unique labels " + histogram.length + ".");
                n = n3;
            } else {
                if (!None$.MODULE$.equals(option)) {
                    throw new MatchError(option);
                }
                n = histogram.length;
            }
            int numClasses = n;
            Predef$.MODULE$.require(numClasses == 2, (Function0 & Serializable)() -> "LinearSVC only supports binary classification. " + numClasses + " classes detected in " + this.labelCol());
            instr.logNumClasses(numClasses);
            instr.logNumFeatures(numFeatures);
            if (numInvalid != 0L) {
                MessageWithContext msg = this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Classification labels should be in "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", ". "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.RANGE, "[0 to " + (numClasses - 1) + "]")}))).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Found ", " invalid labels."}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.COUNT, BoxesRunTime.boxToLong((long)numInvalid))})));
                instr.logError(LogEntry$.MODULE$.from((Function0 & Serializable)() -> msg));
                throw new SparkException(msg.message());
            }
            double[] featuresStd = summarizer2.std().toArray();
            double[] featuresMean = summarizer2.mean().toArray();
            JFunction1.mcDI.sp & Serializable getFeaturesStd = (JFunction1.mcDI.sp & Serializable)j -> featuresStd[j];
            if (BoxesRunTime.unboxToDouble((Object)this.$(this.regParam())) != 0.0) {
                JFunction1.mcZI.sp & Serializable shouldApply = (JFunction1.mcZI.sp & Serializable)idx -> idx >= 0 && idx < numFeatures;
                none$ = new Some((Object)new L2Regularization(BoxesRunTime.unboxToDouble((Object)this.$(this.regParam())), (Function1<Object, Object>)shouldApply, (Option<Function1<Object, Object>>)(BoxesRunTime.unboxToBoolean((Object)this.$(this.standardization())) ? None$.MODULE$ : new Some((Object)getFeaturesStd))));
            } else {
                none$ = None$.MODULE$;
            }
            None$ regularization = none$;
            OWLQN optimizer = new OWLQN(BoxesRunTime.unboxToInt((Object)this.$(this.maxIter())), 10, LinearSVC.regParamL1Fun$1(), BoxesRunTime.unboxToDouble((Object)this.$(this.tol())), (MutableEnumeratedCoordinateField)DenseVector$.MODULE$.space_Double());
            Tuple2<double[], double[]> tuple23 = this.trainImpl((RDD<Instance>)instances, actualBlockSizeInMB, featuresStd, featuresMean, (Option<L2Regularization>)regularization, (OWLQN<Object, DenseVector<Object>>)optimizer);
            if (tuple23 == null) {
                throw new MatchError(tuple23);
            }
            double[] rawCoefficients = (double[])tuple23._1();
            double[] objectiveHistory = (double[])tuple23._2();
            Tuple2 tuple24 = new Tuple2((Object)rawCoefficients, (Object)objectiveHistory);
            double[] rawCoefficients2 = (double[])tuple24._1();
            double[] objectiveHistory2 = (double[])tuple24._2();
            if (rawCoefficients2 == null) {
                MLUtils$.MODULE$.optimizerFailed((Instrumentation)instr, optimizer.getClass());
            }
            double[] coefficientArray = (double[])Array$.MODULE$.tabulate(numFeatures, (Function1)(JFunction1.mcDI.sp & Serializable)i -> {
                if (featuresStd[i] != 0.0) {
                    return rawCoefficients2[i] / featuresStd[i];
                }
                return 0.0;
            }, (ClassTag)ClassTag$.MODULE$.Double());
            double intercept = BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) ? BoxesRunTime.unboxToDouble((Object)ArrayOps$.MODULE$.last$extension(Predef$.MODULE$.doubleArrayOps(rawCoefficients2))) : 0.0;
            return this.createModel(dataset, Vectors$.MODULE$.dense(coefficientArray).compressed(), intercept, objectiveHistory2);
        });
    }

    private LinearSVCModel createModel(Dataset<?> dataset, Vector coefficients, double intercept, double[] objectiveHistory) {
        LinearSVCModel model = this.copyValues(new LinearSVCModel(this.uid(), coefficients, intercept), this.copyValues$default$2());
        model.createSummary(dataset, objectiveHistory);
        return model;
    }

    private Tuple2<double[], double[]> trainImpl(RDD<Instance> instances, double actualBlockSizeInMB, double[] featuresStd, double[] featuresMean, Option<L2Regularization> regularization, OWLQN<Object, DenseVector<Object>> optimizer) {
        double[] solution;
        int numFeatures = featuresStd.length;
        int numFeaturesPlusIntercept = BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) ? numFeatures + 1 : numFeatures;
        double[] inverseStd = (double[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.doubleArrayOps(featuresStd), (Function1)(JFunction1.mcDD.sp & Serializable)std -> {
            if (std != 0.0) {
                return 1.0 / std;
            }
            return 0.0;
        }, (ClassTag)ClassTag$.MODULE$.Double());
        double[] scaledMean = (double[])Array$.MODULE$.tabulate(numFeatures, (Function1)(JFunction1.mcDI.sp & Serializable)i -> inverseStd[i] * featuresMean[i], (ClassTag)ClassTag$.MODULE$.Double());
        Broadcast bcInverseStd = instances.context().broadcast((Object)inverseStd, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        Broadcast bcScaledMean = instances.context().broadcast((Object)scaledMean, ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Double.TYPE)));
        RDD standardized = instances.mapPartitions((Function1 & Serializable)iter -> {
            Function1<Vector, Vector> func = StandardScalerModel$.MODULE$.getTransformFunc((double[])Array$.MODULE$.empty((ClassTag)ClassTag$.MODULE$.Double()), (double[])bcInverseStd.value(), false, true);
            return iter.map((Function1 & Serializable)x0$1 -> {
                Instance instance = x0$1;
                if (instance != null) {
                    double label = instance.label();
                    double weight = instance.weight();
                    Vector vec = instance.features();
                    return new Instance(label, weight, (Vector)func.apply((Object)vec));
                }
                throw new MatchError((Object)instance);
            });
        }, instances.mapPartitions$default$2(), ClassTag$.MODULE$.apply(Instance.class));
        long maxMemUsage = (long)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper(actualBlockSizeInMB * (double)1024L * (double)1024L));
        RDD blocks = InstanceBlock$.MODULE$.blokifyWithMaxMemUsage((RDD<Instance>)standardized, maxMemUsage).persist(StorageLevel$.MODULE$.MEMORY_AND_DISK()).setName("training blocks (blockSizeInMB=" + actualBlockSizeInMB + ")");
        Function1 & Serializable getAggregatorFunc = (Function1 & Serializable)x$3 -> new HingeBlockAggregator((Broadcast<double[]>)bcInverseStd, (Broadcast<double[]>)bcScaledMean, BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())), (Broadcast<Vector>)x$3);
        RDDLossFunction costFun = new RDDLossFunction(blocks, getAggregatorFunc, regularization, BoxesRunTime.unboxToInt((Object)this.$(this.aggregationDepth())), ClassTag$.MODULE$.apply(InstanceBlock.class), ClassTag$.MODULE$.apply(HingeBlockAggregator.class));
        double[] initialSolution = (double[])Array$.MODULE$.ofDim(numFeaturesPlusIntercept, (ClassTag)ClassTag$.MODULE$.Double());
        if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept()))) {
            double adapt = BLAS$.MODULE$.javaBLAS().ddot(numFeatures, initialSolution, 1, scaledMean, 1);
            initialSolution[numFeatures] = initialSolution[numFeatures] + adapt;
        }
        Iterator states = optimizer.iterations((StochasticDiffFunction)new CachedDiffFunction(costFun, DenseVector$.MODULE$.canCopyDenseVector((ClassTag)ClassTag$.MODULE$.Double())), (Object)new DenseVector.mcD.sp(initialSolution));
        ArrayBuilder arrayBuilder = ArrayBuilder$.MODULE$.make((ClassTag)ClassTag$.MODULE$.Double());
        FirstOrderMinimizer.State state = null;
        while (states.hasNext()) {
            state = (FirstOrderMinimizer.State)states.next();
            arrayBuilder.$plus$eq((Object)BoxesRunTime.boxToDouble((double)state.adjustedValue()));
        }
        blocks.unpersist(blocks.unpersist$default$1());
        bcInverseStd.destroy();
        bcScaledMean.destroy();
        double[] dArray = solution = state == null ? null : ((DenseVector)state.x()).toArray$mcD$sp((ClassTag)ClassTag$.MODULE$.Double());
        if (BoxesRunTime.unboxToBoolean((Object)this.$(this.fitIntercept())) && solution != null) {
            double adapt = BLAS$.MODULE$.javaBLAS().ddot(numFeatures, solution, 1, scaledMean, 1);
            solution[numFeatures] = solution[numFeatures] - adapt;
        }
        return new Tuple2((Object)solution, arrayBuilder.result());
    }

    private static final Function1 regParamL1Fun$1() {
        return (JFunction1.mcDI.sp & Serializable)index -> 0.0;
    }

    public LinearSVC(String uid) {
        this.uid = uid;
        HasRegParam.$init$(this);
        HasMaxIter.$init$(this);
        HasFitIntercept.$init$(this);
        HasTol.$init$(this);
        HasStandardization.$init$(this);
        HasWeightCol.$init$(this);
        HasAggregationDepth.$init$(this);
        HasThreshold.$init$(this);
        HasMaxBlockSizeInMB.$init$(this);
        LinearSVCParams.$init$(this);
        MLWritable.$init$(this);
        DefaultParamsWritable.$init$(this);
        Statics.releaseFence();
    }

    public LinearSVC() {
        this(Identifiable$.MODULE$.randomUID("linearsvc"));
    }
}

