/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.mllib.clustering;

import breeze.linalg.DenseVector;
import java.io.Serializable;
import org.apache.spark.SparkContext;
import org.apache.spark.graphx.Edge;
import org.apache.spark.graphx.Graph;
import org.apache.spark.graphx.Graph$;
import org.apache.spark.mllib.clustering.DistributedLDAModel;
import org.apache.spark.mllib.clustering.DistributedLDAModel$SaveLoadV1_0$;
import org.apache.spark.mllib.linalg.Vector;
import org.apache.spark.mllib.linalg.Vectors$;
import org.apache.spark.mllib.util.Loader;
import org.apache.spark.mllib.util.Loader$;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.json4s.AsJsonInput$;
import org.json4s.DefaultFormats$;
import org.json4s.ExtractableJsonAstNode$;
import org.json4s.Formats;
import org.json4s.JValue;
import org.json4s.MonadicJValue$;
import org.json4s.jackson.JsonMethods$;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.Tuple4;
import scala.collection.IterableOnceOps;
import scala.collection.SeqFactory;
import scala.collection.SeqOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.reflect.Manifest;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;

public final class DistributedLDAModel$
implements Loader<DistributedLDAModel> {
    public static final DistributedLDAModel$ MODULE$ = new DistributedLDAModel$();
    private static final double defaultGammaShape = 100.0;

    public double $lessinit$greater$default$8() {
        return this.defaultGammaShape();
    }

    public String[] $lessinit$greater$default$9() {
        return (String[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(String.class));
    }

    public double defaultGammaShape() {
        return defaultGammaShape;
    }

    public DistributedLDAModel fromInternals(Seq<Dataset<Row>> internals) {
        SeqOps seqOps;
        Seq<Dataset<Row>> seq = internals;
        if (seq == null || SeqFactory.UnapplySeqWrapper$.MODULE$.isEmpty$extension(seqOps = package$.MODULE$.Seq().unapplySeq(seq)) || new SeqFactory.UnapplySeqWrapper(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps)) == null || SeqFactory.UnapplySeqWrapper$.MODULE$.lengthCompare$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 4) != 0) {
            throw new MatchError(seq);
        }
        Dataset metadataDF = (Dataset)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 0);
        Dataset globalTopicTotalsDF = (Dataset)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 1);
        Dataset verticesDF = (Dataset)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 2);
        Dataset edgesDF = (Dataset)SeqFactory.UnapplySeqWrapper$.MODULE$.apply$extension(SeqFactory.UnapplySeqWrapper$.MODULE$.get$extension(seqOps), 3);
        Tuple4 tuple4 = new Tuple4((Object)metadataDF, (Object)globalTopicTotalsDF, (Object)verticesDF, (Object)edgesDF);
        Dataset metadataDF2 = (Dataset)tuple4._1();
        Dataset globalTopicTotalsDF2 = (Dataset)tuple4._2();
        Dataset verticesDF2 = (Dataset)tuple4._3();
        Dataset edgesDF2 = (Dataset)tuple4._4();
        SparkSession spark = metadataDF2.sparkSession();
        DefaultFormats$ formats = DefaultFormats$.MODULE$;
        JValue metadata = JsonMethods$.MODULE$.parse(metadataDF2.as(spark.implicits().newStringEncoder()).first(), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3(), AsJsonInput$.MODULE$.stringAsJsonInput());
        int expectedK = BoxesRunTime.unboxToInt((Object)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(metadata), "k")), (Formats)formats, (Manifest)ManifestFactory$.MODULE$.Int()));
        int vocabSize = BoxesRunTime.unboxToInt((Object)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(metadata), "vocabSize")), (Formats)formats, (Manifest)ManifestFactory$.MODULE$.Int()));
        Vector docConcentration = Vectors$.MODULE$.dense((double[])((IterableOnceOps)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(metadata), "docConcentration")), (Formats)formats, ManifestFactory$.MODULE$.classType(Seq.class, (Manifest)ManifestFactory$.MODULE$.Double(), (Seq)Nil$.MODULE$))).toArray((ClassTag)ClassTag$.MODULE$.Double()));
        double topicConcentration = BoxesRunTime.unboxToDouble((Object)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(metadata), "topicConcentration")), (Formats)formats, (Manifest)ManifestFactory$.MODULE$.Double()));
        double[] iterationTimes = (double[])((IterableOnceOps)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(metadata), "iterationTimes")), (Formats)formats, ManifestFactory$.MODULE$.classType(Seq.class, (Manifest)ManifestFactory$.MODULE$.Double(), (Seq)Nil$.MODULE$))).toArray((ClassTag)ClassTag$.MODULE$.Double());
        double gammaShape = BoxesRunTime.unboxToDouble((Object)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(metadata), "gammaShape")), (Formats)formats, (Manifest)ManifestFactory$.MODULE$.Double()));
        DenseVector.mcD.sp globalTopicTotals = new DenseVector.mcD.sp((double[])((Row)globalTopicTotalsDF2.first()).getSeq(0).toArray((ClassTag)ClassTag$.MODULE$.Double()));
        RDD vertices = verticesDF2.rdd().map((Function1 & Serializable)x0$1 -> {
            Row row = x0$1;
            if (row != null) {
                Row row2 = row;
                return new Tuple2((Object)BoxesRunTime.boxToLong((long)row2.getLong(0)), (Object)new DenseVector.mcD.sp((double[])row2.getSeq(1).toArray((ClassTag)ClassTag$.MODULE$.Double())));
            }
            throw new MatchError((Object)row);
        }, ClassTag$.MODULE$.apply(Tuple2.class));
        RDD edges = edgesDF2.rdd().map((Function1 & Serializable)x0$2 -> {
            Row row = x0$2;
            if (row != null) {
                Row row2 = row;
                return new Edge.mcD.sp(row2.getLong(0), row2.getLong(1), row2.getDouble(2));
            }
            throw new MatchError((Object)row);
        }, ClassTag$.MODULE$.apply(Edge.class));
        Graph graph = Graph$.MODULE$.apply(vertices, edges, Graph$.MODULE$.apply$default$3(), Graph$.MODULE$.apply$default$4(), Graph$.MODULE$.apply$default$5(), ClassTag$.MODULE$.apply(DenseVector.class), ClassTag$.MODULE$.apply(Double.TYPE));
        return new DistributedLDAModel((Graph<DenseVector<Object>, Object>)graph, (DenseVector<Object>)globalTopicTotals, globalTopicTotals.length(), vocabSize, docConcentration, topicConcentration, iterationTimes, gammaShape, this.$lessinit$greater$default$9());
    }

    @Override
    public DistributedLDAModel load(SparkContext sc, String path) {
        double gammaShape;
        Seq iterationTimes;
        double topicConcentration;
        Vector docConcentration;
        int vocabSize;
        int expectedK;
        block6: {
            String classNameV1_0;
            String loadedVersion;
            String loadedClassName;
            block4: {
                String string;
                String string2;
                block5: {
                    Tuple3<String, String, JValue> tuple3 = Loader$.MODULE$.loadMetadata(sc, path);
                    if (tuple3 == null) {
                        throw new MatchError(tuple3);
                    }
                    String loadedClassName2 = (String)tuple3._1();
                    String loadedVersion2 = (String)tuple3._2();
                    JValue metadata = (JValue)tuple3._3();
                    Tuple3 tuple32 = new Tuple3((Object)loadedClassName2, (Object)loadedVersion2, (Object)metadata);
                    loadedClassName = (String)tuple32._1();
                    loadedVersion = (String)tuple32._2();
                    JValue metadata2 = (JValue)tuple32._3();
                    DefaultFormats$ formats = DefaultFormats$.MODULE$;
                    expectedK = BoxesRunTime.unboxToInt((Object)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(metadata2), "k")), (Formats)formats, (Manifest)ManifestFactory$.MODULE$.Int()));
                    vocabSize = BoxesRunTime.unboxToInt((Object)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(metadata2), "vocabSize")), (Formats)formats, (Manifest)ManifestFactory$.MODULE$.Int()));
                    docConcentration = Vectors$.MODULE$.dense((double[])((IterableOnceOps)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(metadata2), "docConcentration")), (Formats)formats, ManifestFactory$.MODULE$.classType(Seq.class, (Manifest)ManifestFactory$.MODULE$.Double(), (Seq)Nil$.MODULE$))).toArray((ClassTag)ClassTag$.MODULE$.Double()));
                    topicConcentration = BoxesRunTime.unboxToDouble((Object)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(metadata2), "topicConcentration")), (Formats)formats, (Manifest)ManifestFactory$.MODULE$.Double()));
                    iterationTimes = (Seq)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(metadata2), "iterationTimes")), (Formats)formats, ManifestFactory$.MODULE$.classType(Seq.class, (Manifest)ManifestFactory$.MODULE$.Double(), (Seq)Nil$.MODULE$));
                    gammaShape = BoxesRunTime.unboxToDouble((Object)ExtractableJsonAstNode$.MODULE$.extract$extension(org.json4s.package$.MODULE$.jvalue2extractable(MonadicJValue$.MODULE$.$bslash$extension(org.json4s.package$.MODULE$.jvalue2monadic(metadata2), "gammaShape")), (Formats)formats, (Manifest)ManifestFactory$.MODULE$.Double()));
                    classNameV1_0 = DistributedLDAModel$SaveLoadV1_0$.MODULE$.thisClassName();
                    Tuple2 tuple2 = new Tuple2((Object)loadedClassName, (Object)loadedVersion);
                    if (tuple2 == null) break block4;
                    String className = (String)tuple2._1();
                    String string3 = (String)tuple2._2();
                    if (!"1.0".equals(string3)) break block4;
                    string2 = className;
                    string = classNameV1_0;
                    if (string2 != null) break block5;
                    if (string == null) break block6;
                    break block4;
                }
                if (string2.equals(string)) break block6;
            }
            throw new Exception("DistributedLDAModel.load did not recognize model with (className, format version):(" + loadedClassName + ", " + loadedVersion + ").  Supported: (" + classNameV1_0 + ", 1.0)");
        }
        DistributedLDAModel model = DistributedLDAModel$SaveLoadV1_0$.MODULE$.load(sc, path, vocabSize, docConcentration, topicConcentration, (double[])iterationTimes.toArray((ClassTag)ClassTag$.MODULE$.Double()), gammaShape);
        Predef$.MODULE$.require(model.vocabSize() == vocabSize, (Function0 & Serializable)() -> "DistributedLDAModel requires " + vocabSize + " vocabSize, got " + model.vocabSize() + " vocabSize");
        Vector vector = model.docConcentration();
        Vector vector2 = docConcentration;
        Predef$.MODULE$.require(!(vector != null ? !((Object)vector).equals(vector2) : vector2 != null), (Function0 & Serializable)() -> "DistributedLDAModel requires " + docConcentration + " docConcentration, got " + model.docConcentration() + " docConcentration");
        Predef$.MODULE$.require(model.topicConcentration() == topicConcentration, (Function0 & Serializable)() -> "DistributedLDAModel requires " + topicConcentration + " docConcentration, got " + model.topicConcentration() + " docConcentration");
        Predef$.MODULE$.require(expectedK == model.k(), (Function0 & Serializable)() -> "DistributedLDAModel requires " + expectedK + " topics, got " + model.k() + " topics");
        return model;
    }

    private DistributedLDAModel$() {
    }
}

