/*
 * Decompiled with CFR 0.152.
 */
package org.sparkproject.jpmml.model.temporals;

import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import java.util.Objects;
import org.sparkproject.dmg.pmml.DataType;
import org.sparkproject.jpmml.model.temporals.Date;
import org.sparkproject.jpmml.model.temporals.Instant;
import org.sparkproject.jpmml.model.temporals.SecondsSinceDate;
import org.sparkproject.jpmml.model.temporals.Time;

public class DateTime
extends Instant<DateTime> {
    private LocalDateTime dateTime = null;

    private DateTime() {
    }

    public DateTime(int year, int month, int dayOfMonth, int hour, int minute, int second) {
        this(LocalDateTime.of(year, month, dayOfMonth, hour, minute, second));
    }

    public DateTime(LocalDateTime dateTime) {
        this.setDateTime(dateTime);
    }

    @Override
    public DataType getDataType() {
        return DataType.DATE_TIME;
    }

    @Override
    public String toSimpleValue() {
        LocalDateTime dateTime = this.getDateTime();
        return dateTime.toString();
    }

    @Override
    public String format(String pattern) {
        LocalDateTime dateTime = this.getDateTime();
        return String.format(pattern, dateTime);
    }

    public Date toDate() {
        LocalDateTime dateTime = this.getDateTime();
        return new Date(dateTime.toLocalDate());
    }

    public Time toTime() {
        LocalDateTime dateTime = this.getDateTime();
        return new Time(dateTime.toLocalTime());
    }

    public SecondsSinceDate toSecondsSinceYear(int year) {
        LocalDateTime dateTime = this.getDateTime();
        return new SecondsSinceDate(new Date(year, 1, 1), dateTime);
    }

    @Override
    public int compareTo(DateTime that) {
        return this.getDateTime().compareTo(that.getDateTime());
    }

    public int hashCode() {
        return this.getDateTime().hashCode();
    }

    public boolean equals(Object object) {
        if (object instanceof DateTime) {
            DateTime that = (DateTime)object;
            return Objects.equals(this.getDateTime(), that.getDateTime());
        }
        return false;
    }

    public LocalDateTime getDateTime() {
        return this.dateTime;
    }

    private void setDateTime(LocalDateTime dateTime) {
        this.dateTime = Objects.requireNonNull(dateTime);
    }

    public static DateTime parse(String value) throws DateTimeParseException {
        return new DateTime(LocalDateTime.parse(value));
    }

    public static DateTime valueOf(Object value) {
        if (value instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)value;
            return new DateTime(localDateTime);
        }
        throw new IllegalArgumentException();
    }
}

