/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.adouble.DoubleSummary;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.TupleSketchEstimateDouble$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.TupleSketchUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(child) - Returns the estimated number of unique values\n    given the binary representation of a Datasketches TupleSketch. The sketch's\n    summary type must be a double. ", examples="\n    Examples:\n      > SELECT _FUNC_(tuple_sketch_agg_double(key, summary)) FROM VALUES (1, 1.0D), (1, 2.0D), (2, 3.0D) tab(key, summary);\n       2.0\n  ", group="sketch_funcs", since="4.2.0")
@ScalaSignature(bytes="\u0006\u0005\u0005uf\u0001\u0002\u000e\u001c\u0001\"B\u0001\u0002\u0013\u0001\u0003\u0016\u0004%\t!\u0013\u0005\t\u001b\u0002\u0011\t\u0012)A\u0005\u0015\")a\n\u0001C\u0001\u001f\")!\u000b\u0001C!'\")q\u000b\u0001C!1\")!\r\u0001C!G\")q\r\u0001C!Q\")\u0011\u000f\u0001C)e\")Q\u000f\u0001C!m\"9A\u0010AA\u0001\n\u0003i\b\u0002C@\u0001#\u0003%\t!!\u0001\t\u0013\u0005]\u0001!!A\u0005B\u0005e\u0001\"CA\u0015\u0001\u0005\u0005I\u0011AA\u0016\u0011%\t\u0019\u0004AA\u0001\n\u0003\t)\u0004C\u0005\u0002<\u0001\t\t\u0011\"\u0011\u0002>!I\u00111\n\u0001\u0002\u0002\u0013\u0005\u0011Q\n\u0005\n\u0003#\u0002\u0011\u0011!C!\u0003'B\u0011\"a\u0016\u0001\u0003\u0003%\t%!\u0017\b\u0013\u0005u4$!A\t\u0002\u0005}d\u0001\u0003\u000e\u001c\u0003\u0003E\t!!!\t\r9#B\u0011AAM\u0011%\tY\nFA\u0001\n\u000b\ni\nC\u0005\u0002 R\t\t\u0011\"!\u0002\"\"I\u0011Q\u0015\u000b\u0002\u0002\u0013\u0005\u0015q\u0015\u0005\n\u0003g#\u0012\u0011!C\u0005\u0003k\u0013\u0011\u0004V;qY\u0016\u001c6.\u001a;dQ\u0016\u001bH/[7bi\u0016$u.\u001e2mK*\u0011A$H\u0001\fKb\u0004(/Z:tS>t7O\u0003\u0002\u001f?\u0005A1-\u0019;bYf\u001cHO\u0003\u0002!C\u0005\u00191/\u001d7\u000b\u0005\t\u001a\u0013!B:qCJ\\'B\u0001\u0013&\u0003\u0019\t\u0007/Y2iK*\ta%A\u0002pe\u001e\u001c\u0001a\u0005\u0004\u0001S5\u001ad\u0007\u0010\t\u0003U-j\u0011aG\u0005\u0003Ym\u0011q\"\u00168bef,\u0005\u0010\u001d:fgNLwN\u001c\t\u0003]Ej\u0011a\f\u0006\u0003am\tqaY8eK\u001e,g.\u0003\u00023_\ty1i\u001c3fO\u0016tg)\u00197mE\u0006\u001c7\u000e\u0005\u0002+i%\u0011Qg\u0007\u0002\u0012\u000bb\u0004Xm\u0019;t\u0013:\u0004X\u000f\u001e+za\u0016\u001c\bCA\u001c;\u001b\u0005A$\"A\u001d\u0002\u000bM\u001c\u0017\r\\1\n\u0005mB$a\u0002)s_\u0012,8\r\u001e\t\u0003{\u0015s!AP\"\u000f\u0005}\u0012U\"\u0001!\u000b\u0005\u0005;\u0013A\u0002\u001fs_>$h(C\u0001:\u0013\t!\u0005(A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0019;%\u0001D*fe&\fG.\u001b>bE2,'B\u0001#9\u0003\u0015\u0019\u0007.\u001b7e+\u0005Q\u0005C\u0001\u0016L\u0013\ta5D\u0001\u0006FqB\u0014Xm]:j_:\faa\u00195jY\u0012\u0004\u0013A\u0002\u001fj]&$h\b\u0006\u0002Q#B\u0011!\u0006\u0001\u0005\u0006\u0011\u000e\u0001\rAS\u0001\u000f]VdG.\u00138u_2,'/\u00198u+\u0005!\u0006CA\u001cV\u0013\t1\u0006HA\u0004C_>dW-\u00198\u0002\u0015%t\u0007/\u001e;UsB,7/F\u0001Z!\ri$\fX\u0005\u00037\u001e\u00131aU3r!\ti\u0006-D\u0001_\u0015\tyv$A\u0003usB,7/\u0003\u0002b=\n\u0001\u0012IY:ue\u0006\u001cG\u000fR1uCRK\b/Z\u0001\tI\u0006$\u0018\rV=qKV\tA\r\u0005\u0002^K&\u0011aM\u0018\u0002\t\t\u0006$\u0018\rV=qK\u0006Q\u0001O]3uift\u0015-\\3\u0016\u0003%\u0004\"A\u001b8\u000f\u0005-d\u0007CA 9\u0013\ti\u0007(\u0001\u0004Qe\u0016$WMZ\u0005\u0003_B\u0014aa\u0015;sS:<'BA79\u0003Q9\u0018\u000e\u001e5OK^\u001c\u0005.\u001b7e\u0013:$XM\u001d8bYR\u0011\u0001k\u001d\u0005\u0006i\"\u0001\rAS\u0001\t]\u0016<8\t[5mI\u0006aa.\u001e7m'\u00064W-\u0012<bYR\u0011qO\u001f\t\u0003oaL!!\u001f\u001d\u0003\u0007\u0005s\u0017\u0010C\u0003|\u0013\u0001\u0007q/A\u0003j]B,H/\u0001\u0003d_BLHC\u0001)\u007f\u0011\u001dA%\u0002%AA\u0002)\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002\u0004)\u001a!*!\u0002,\u0005\u0005\u001d\u0001\u0003BA\u0005\u0003'i!!a\u0003\u000b\t\u00055\u0011qB\u0001\nk:\u001c\u0007.Z2lK\u0012T1!!\u00059\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003+\tYAA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\u000e!\u0011\ti\"a\n\u000e\u0005\u0005}!\u0002BA\u0011\u0003G\tA\u0001\\1oO*\u0011\u0011QE\u0001\u0005U\u00064\u0018-C\u0002p\u0003?\tA\u0002\u001d:pIV\u001cG/\u0011:jif,\"!!\f\u0011\u0007]\ny#C\u0002\u00022a\u00121!\u00138u\u00039\u0001(o\u001c3vGR,E.Z7f]R$2a^A\u001c\u0011%\tIDDA\u0001\u0002\u0004\ti#A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0003\u007f\u0001R!!\u0011\u0002H]l!!a\u0011\u000b\u0007\u0005\u0015\u0003(\u0001\u0006d_2dWm\u0019;j_:LA!!\u0013\u0002D\tA\u0011\n^3sCR|'/\u0001\u0005dC:,\u0015/^1m)\r!\u0016q\n\u0005\t\u0003s\u0001\u0012\u0011!a\u0001o\u0006\u0011\u0002O]8ek\u000e$X\t\\3nK:$h*Y7f)\u0011\tY\"!\u0016\t\u0013\u0005e\u0012#!AA\u0002\u00055\u0012AB3rk\u0006d7\u000fF\u0002U\u00037B\u0001\"!\u000f\u0013\u0003\u0003\u0005\ra\u001e\u0015\u0014\u0001\u0005}\u0013QMA4\u0003W\ni'!\u001d\u0002t\u0005]\u0014\u0011\u0010\t\u0004U\u0005\u0005\u0014bAA27\t)R\t\u001f9sKN\u001c\u0018n\u001c8EKN\u001c'/\u001b9uS>t\u0017!B;tC\u001e,\u0017EAA5\u0003\u00055$\u0002\t\u0011!A}3UKT\"`Q\rD\u0017\u000e\u001c3*A5\u0002#+\u001a;ve:\u001c\b\u0005\u001e5fA\u0015\u001cH/[7bi\u0016$\u0007E\\;nE\u0016\u0014\be\u001c4!k:L\u0017/^3!m\u0006dW/Z:\u000bA\u0001\u0002\u0003eZ5wK:\u0004C\u000f[3!E&t\u0017M]=!e\u0016\u0004(/Z:f]R\fG/[8oA=4\u0007%\u0019\u0011ECR\f7o[3uG\",7\u000f\t+va2,7k[3uG\"t\u0003\u0005\u00165fAM\\W\r^2iOMT\u0001\u0005\t\u0011!gVlW.\u0019:zAQL\b/\u001a\u0011nkN$\bEY3!C\u0002\"w.\u001e2mK:\u0002\u0013\u0001C3yC6\u0004H.Z:\"\u0005\u0005=\u0014!!\r\u000bA\u0001\u0002\u0003%\u0012=b[BdWm\u001d\u001e\u000bA\u0001\u0002\u0003\u0005\t\u0011?AM+E*R\"UA}3UKT\"`QQ,\b\u000f\\3`g.,Go\u00195`C\u001e<w\fZ8vE2,\u0007f[3zY\u0001\u001aX/\\7befL\u0013\u0006\t$S\u001f6\u0003c+\u0011'V\u000bN\u0003\u0003&\r\u0017!c9\u0002D)\u000b\u0017!QEb\u0003E\r\u00181\t&b\u0003\u0005\u000b\u001a-AMr\u0003\u0007R\u0015!i\u0006\u0014\u0007f[3zY\u0001\u001aX/\\7befL3H\u0003\u0011!A\u0001\u0002\u0003\u0005\t\u001a/a)\u0001\u0003%A\u0003he>,\b/\t\u0002\u0002v\u0005a1o[3uG\"|f-\u001e8dg\u0006)1/\u001b8dK\u0006\u0012\u00111P\u0001\u0006i9\u0012d\u0006M\u0001\u001a)V\u0004H.Z*lKR\u001c\u0007.R:uS6\fG/\u001a#pk\ndW\r\u0005\u0002+)M)A#a!\u0002\u0010B1\u0011QQAF\u0015Bk!!a\"\u000b\u0007\u0005%\u0005(A\u0004sk:$\u0018.\\3\n\t\u00055\u0015q\u0011\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\f\u0004\u0003BAI\u0003/k!!a%\u000b\t\u0005U\u00151E\u0001\u0003S>L1ARAJ)\t\ty(\u0001\u0005u_N#(/\u001b8h)\t\tY\"A\u0003baBd\u0017\u0010F\u0002Q\u0003GCQ\u0001S\fA\u0002)\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002*\u0006=\u0006\u0003B\u001c\u0002,*K1!!,9\u0005\u0019y\u0005\u000f^5p]\"A\u0011\u0011\u0017\r\u0002\u0002\u0003\u0007\u0001+A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!a.\u0011\t\u0005u\u0011\u0011X\u0005\u0005\u0003w\u000byB\u0001\u0004PE*,7\r\u001e")
public class TupleSketchEstimateDouble
extends UnaryExpression
implements CodegenFallback,
ExpectsInputTypes,
Serializable {
    private final Expression child;

    public static Option<Expression> unapply(TupleSketchEstimateDouble x$0) {
        return TupleSketchEstimateDouble$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Expression, A> andThen(Function1<TupleSketchEstimateDouble, A> g) {
        return TupleSketchEstimateDouble$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, TupleSketchEstimateDouble> compose(Function1<A$, Expression> g) {
        return TupleSketchEstimateDouble$.MODULE$.compose(g);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)BinaryType$.MODULE$, (List)Nil$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return DoubleType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "tuple_sketch_estimate_double";
    }

    @Override
    public TupleSketchEstimateDouble withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    @Override
    public Object nullSafeEval(Object input) {
        byte[] buffer = (byte[])input;
        Sketch<DoubleSummary> sketch = TupleSketchUtils$.MODULE$.heapifyDoubleSketch(buffer, this.prettyName());
        return BoxesRunTime.boxToDouble((double)sketch.getEstimate());
    }

    public TupleSketchEstimateDouble copy(Expression child) {
        return new TupleSketchEstimateDouble(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "TupleSketchEstimateDouble";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TupleSketchEstimateDouble;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TupleSketchEstimateDouble)) return false;
        boolean bl = true;
        if (!bl) return false;
        TupleSketchEstimateDouble tupleSketchEstimateDouble = (TupleSketchEstimateDouble)x$1;
        Expression expression = this.child();
        Expression expression2 = tupleSketchEstimateDouble.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!tupleSketchEstimateDouble.canEqual(this)) return false;
        return true;
    }

    public TupleSketchEstimateDouble(Expression child) {
        this.child = child;
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
    }
}

