/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.catalyst.expressions;

import java.io.Serializable;
import org.apache.datasketches.tuple.Sketch;
import org.apache.datasketches.tuple.adouble.DoubleSummary;
import org.apache.spark.sql.catalyst.analysis.TypeCheckResult;
import org.apache.spark.sql.catalyst.expressions.ExpectsInputTypes;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.ExpressionDescription;
import org.apache.spark.sql.catalyst.expressions.TupleSketchThetaDouble$;
import org.apache.spark.sql.catalyst.expressions.UnaryExpression;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenContext;
import org.apache.spark.sql.catalyst.expressions.codegen.CodegenFallback;
import org.apache.spark.sql.catalyst.expressions.codegen.ExprCode;
import org.apache.spark.sql.catalyst.util.TupleSketchUtils$;
import org.apache.spark.sql.types.AbstractDataType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DoubleType$;
import scala.Function1;
import scala.Option;
import scala.Product;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ExpressionDescription(usage="\n    _FUNC_(child) - Returns the theta value (sampling rate) from a Datasketches TupleSketch.\n    The theta value represents the effective sampling rate of the sketch, between 0.0 and 1.0.\n    The sketch's summary type must be a double. ", examples="\n    Examples:\n      > SELECT _FUNC_(tuple_sketch_agg_double(key, summary)) FROM VALUES (1, 1.0D), (2, 2.0D), (3, 3.0D) tab(key, summary);\n       1.0\n  ", group="sketch_funcs", since="4.2.0")
@ScalaSignature(bytes="\u0006\u0005\u0005uf\u0001\u0002\u000e\u001c\u0001\"B\u0001\u0002\u0013\u0001\u0003\u0016\u0004%\t!\u0013\u0005\t\u001b\u0002\u0011\t\u0012)A\u0005\u0015\")a\n\u0001C\u0001\u001f\")!\u000b\u0001C!'\")q\u000b\u0001C!1\")!\r\u0001C!G\")q\r\u0001C!Q\")\u0011\u000f\u0001C)e\")Q\u000f\u0001C!m\"9A\u0010AA\u0001\n\u0003i\b\u0002C@\u0001#\u0003%\t!!\u0001\t\u0013\u0005]\u0001!!A\u0005B\u0005e\u0001\"CA\u0015\u0001\u0005\u0005I\u0011AA\u0016\u0011%\t\u0019\u0004AA\u0001\n\u0003\t)\u0004C\u0005\u0002<\u0001\t\t\u0011\"\u0011\u0002>!I\u00111\n\u0001\u0002\u0002\u0013\u0005\u0011Q\n\u0005\n\u0003#\u0002\u0011\u0011!C!\u0003'B\u0011\"a\u0016\u0001\u0003\u0003%\t%!\u0017\b\u0013\u0005u4$!A\t\u0002\u0005}d\u0001\u0003\u000e\u001c\u0003\u0003E\t!!!\t\r9#B\u0011AAM\u0011%\tY\nFA\u0001\n\u000b\ni\nC\u0005\u0002 R\t\t\u0011\"!\u0002\"\"I\u0011Q\u0015\u000b\u0002\u0002\u0013\u0005\u0015q\u0015\u0005\n\u0003g#\u0012\u0011!C\u0005\u0003k\u0013a\u0003V;qY\u0016\u001c6.\u001a;dQRCW\r^1E_V\u0014G.\u001a\u0006\u00039u\t1\"\u001a=qe\u0016\u001c8/[8og*\u0011adH\u0001\tG\u0006$\u0018\r\\=ti*\u0011\u0001%I\u0001\u0004gFd'B\u0001\u0012$\u0003\u0015\u0019\b/\u0019:l\u0015\t!S%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002M\u0005\u0019qN]4\u0004\u0001M1\u0001!K\u00174mq\u0002\"AK\u0016\u000e\u0003mI!\u0001L\u000e\u0003\u001fUs\u0017M]=FqB\u0014Xm]:j_:\u0004\"AL\u0019\u000e\u0003=R!\u0001M\u000e\u0002\u000f\r|G-Z4f]&\u0011!g\f\u0002\u0010\u0007>$WmZ3o\r\u0006dGNY1dWB\u0011!\u0006N\u0005\u0003km\u0011\u0011#\u0012=qK\u000e$8/\u00138qkR$\u0016\u0010]3t!\t9$(D\u00019\u0015\u0005I\u0014!B:dC2\f\u0017BA\u001e9\u0005\u001d\u0001&o\u001c3vGR\u0004\"!P#\u000f\u0005y\u001aeBA C\u001b\u0005\u0001%BA!(\u0003\u0019a$o\\8u}%\t\u0011(\u0003\u0002Eq\u00059\u0001/Y2lC\u001e,\u0017B\u0001$H\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t!\u0005(A\u0003dQ&dG-F\u0001K!\tQ3*\u0003\u0002M7\tQQ\t\u001f9sKN\u001c\u0018n\u001c8\u0002\r\rD\u0017\u000e\u001c3!\u0003\u0019a\u0014N\\5u}Q\u0011\u0001+\u0015\t\u0003U\u0001AQ\u0001S\u0002A\u0002)\u000baB\\;mY&sGo\u001c7fe\u0006tG/F\u0001U!\t9T+\u0003\u0002Wq\t9!i\\8mK\u0006t\u0017AC5oaV$H+\u001f9fgV\t\u0011\fE\u0002>5rK!aW$\u0003\u0007M+\u0017\u000f\u0005\u0002^A6\taL\u0003\u0002`?\u0005)A/\u001f9fg&\u0011\u0011M\u0018\u0002\u0011\u0003\n\u001cHO]1di\u0012\u000bG/\u0019+za\u0016\f\u0001\u0002Z1uCRK\b/Z\u000b\u0002IB\u0011Q,Z\u0005\u0003Mz\u0013\u0001\u0002R1uCRK\b/Z\u0001\u000baJ,G\u000f^=OC6,W#A5\u0011\u0005)tgBA6m!\ty\u0004(\u0003\u0002nq\u00051\u0001K]3eK\u001aL!a\u001c9\u0003\rM#(/\u001b8h\u0015\ti\u0007(\u0001\u000bxSRDg*Z<DQ&dG-\u00138uKJt\u0017\r\u001c\u000b\u0003!NDQ\u0001\u001e\u0005A\u0002)\u000b\u0001B\\3x\u0007\"LG\u000eZ\u0001\r]VdGnU1gK\u00163\u0018\r\u001c\u000b\u0003oj\u0004\"a\u000e=\n\u0005eD$aA!os\")10\u0003a\u0001o\u0006)\u0011N\u001c9vi\u0006!1m\u001c9z)\t\u0001f\u0010C\u0004I\u0015A\u0005\t\u0019\u0001&\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u00111\u0001\u0016\u0004\u0015\u0006\u00151FAA\u0004!\u0011\tI!a\u0005\u000e\u0005\u0005-!\u0002BA\u0007\u0003\u001f\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005E\u0001(\u0001\u0006b]:|G/\u0019;j_:LA!!\u0006\u0002\f\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tY\u0002\u0005\u0003\u0002\u001e\u0005\u001dRBAA\u0010\u0015\u0011\t\t#a\t\u0002\t1\fgn\u001a\u0006\u0003\u0003K\tAA[1wC&\u0019q.a\b\u0002\u0019A\u0014x\u000eZ;di\u0006\u0013\u0018\u000e^=\u0016\u0005\u00055\u0002cA\u001c\u00020%\u0019\u0011\u0011\u0007\u001d\u0003\u0007%sG/\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\u0007]\f9\u0004C\u0005\u0002:9\t\t\u00111\u0001\u0002.\u0005\u0019\u0001\u0010J\u0019\u0002\u001fA\u0014x\u000eZ;di&#XM]1u_J,\"!a\u0010\u0011\u000b\u0005\u0005\u0013qI<\u000e\u0005\u0005\r#bAA#q\u0005Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005%\u00131\t\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000eF\u0002U\u0003\u001fB\u0001\"!\u000f\u0011\u0003\u0003\u0005\ra^\u0001\u0013aJ|G-^2u\u000b2,W.\u001a8u\u001d\u0006lW\r\u0006\u0003\u0002\u001c\u0005U\u0003\"CA\u001d#\u0005\u0005\t\u0019AA\u0017\u0003\u0019)\u0017/^1mgR\u0019A+a\u0017\t\u0011\u0005e\"#!AA\u0002]D3\u0003AA0\u0003K\n9'a\u001b\u0002n\u0005E\u00141OA<\u0003s\u00022AKA1\u0013\r\t\u0019g\u0007\u0002\u0016\u000bb\u0004(/Z:tS>tG)Z:de&\u0004H/[8o\u0003\u0015)8/Y4fC\t\tI'AAn\u0015\u0001\u0002\u0003\u0005I0G+:\u001bu\fK2iS2$\u0017\u0006I\u0017!%\u0016$XO\u001d8tAQDW\r\t;iKR\f\u0007E^1mk\u0016\u0004\u0003f]1na2Lgn\u001a\u0011sCR,\u0017\u0006\t4s_6\u0004\u0013\r\t#bi\u0006\u001c8.\u001a;dQ\u0016\u001c\b\u0005V;qY\u0016\u001c6.\u001a;dQ:R\u0001\u0005\t\u0011!)\",\u0007\u0005\u001e5fi\u0006\u0004c/\u00197vK\u0002\u0012X\r\u001d:fg\u0016tGo\u001d\u0011uQ\u0016\u0004SM\u001a4fGRLg/\u001a\u0011tC6\u0004H.\u001b8hAI\fG/\u001a\u0011pM\u0002\"\b.\u001a\u0011tW\u0016$8\r\u001b\u0017!E\u0016$x/Z3oAAr\u0003\u0007I1oI\u0002\nd\u0006\r\u0018\u000bA\u0001\u0002\u0003\u0005\u00165fAM\\W\r^2iOM\u00043/^7nCJL\b\u0005^=qK\u0002jWo\u001d;!E\u0016\u0004\u0013\r\t3pk\ndWM\f\u0011\u0002\u0011\u0015D\u0018-\u001c9mKN\f#!a\u001c\u0002\u0003cQ\u0001\u0005\t\u0011!\u000bb\fW\u000e\u001d7fgjR\u0001\u0005\t\u0011!A\u0001r\u0004eU#M\u000b\u000e#\u0006e\u0018$V\u001d\u000e{\u0006\u0006^;qY\u0016|6o[3uG\"|\u0016mZ4`I>,(\r\\3)W\u0016LH\u0006I:v[6\f'/_\u0015*A\u0019\u0013v*\u0014\u0011W\u00032+Vi\u0015\u0011)c1\u0002\u0013G\f\u0019ES1\u0002\u0003F\r\u0017!e9\u0002D)\u000b\u0017!QMb\u0003e\r\u00181\t&\u0002C/\u00192)W\u0016LH\u0006I:v[6\f'/_\u0015<\u0015\u0001\u0002\u0003\u0005\t\u0011!AEr\u0003G\u0003\u0011!\u0003\u00159'o\\;qC\t\t)(\u0001\u0007tW\u0016$8\r[0gk:\u001c7/A\u0003tS:\u001cW-\t\u0002\u0002|\u0005)AG\f\u001a/a\u00051B+\u001e9mKN[W\r^2i)\",G/\u0019#pk\ndW\r\u0005\u0002+)M)A#a!\u0002\u0010B1\u0011QQAF\u0015Bk!!a\"\u000b\u0007\u0005%\u0005(A\u0004sk:$\u0018.\\3\n\t\u00055\u0015q\u0011\u0002\u0012\u0003\n\u001cHO]1di\u001a+hn\u0019;j_:\f\u0004\u0003BAI\u0003/k!!a%\u000b\t\u0005U\u00151E\u0001\u0003S>L1ARAJ)\t\ty(\u0001\u0005u_N#(/\u001b8h)\t\tY\"A\u0003baBd\u0017\u0010F\u0002Q\u0003GCQ\u0001S\fA\u0002)\u000bq!\u001e8baBd\u0017\u0010\u0006\u0003\u0002*\u0006=\u0006\u0003B\u001c\u0002,*K1!!,9\u0005\u0019y\u0005\u000f^5p]\"A\u0011\u0011\u0017\r\u0002\u0002\u0003\u0007\u0001+A\u0002yIA\nAb\u001e:ji\u0016\u0014V\r\u001d7bG\u0016$\"!a.\u0011\t\u0005u\u0011\u0011X\u0005\u0005\u0003w\u000byB\u0001\u0004PE*,7\r\u001e")
public class TupleSketchThetaDouble
extends UnaryExpression
implements CodegenFallback,
ExpectsInputTypes,
Serializable {
    private final Expression child;

    public static Option<Expression> unapply(TupleSketchThetaDouble x$0) {
        return TupleSketchThetaDouble$.MODULE$.unapply(x$0);
    }

    public static <A> Function1<Expression, A> andThen(Function1<TupleSketchThetaDouble, A> g) {
        return TupleSketchThetaDouble$.MODULE$.andThen(g);
    }

    public static <A$> Function1<A$, TupleSketchThetaDouble> compose(Function1<A$, Expression> g) {
        return TupleSketchThetaDouble$.MODULE$.compose(g);
    }

    @Override
    public TypeCheckResult checkInputDataTypes() {
        return ExpectsInputTypes.checkInputDataTypes$(this);
    }

    @Override
    public ExprCode doGenCode(CodegenContext ctx, ExprCode ev) {
        return CodegenFallback.doGenCode$(this, ctx, ev);
    }

    @Override
    public Expression child() {
        return this.child;
    }

    @Override
    public boolean nullIntolerant() {
        return true;
    }

    @Override
    public Seq<AbstractDataType> inputTypes() {
        return new .colon.colon((Object)BinaryType$.MODULE$, (List)Nil$.MODULE$);
    }

    @Override
    public DataType dataType() {
        return DoubleType$.MODULE$;
    }

    @Override
    public String prettyName() {
        return "tuple_sketch_theta_double";
    }

    @Override
    public TupleSketchThetaDouble withNewChildInternal(Expression newChild) {
        return this.copy(newChild);
    }

    @Override
    public Object nullSafeEval(Object input) {
        byte[] buffer = (byte[])input;
        Sketch<DoubleSummary> sketch = TupleSketchUtils$.MODULE$.heapifyDoubleSketch(buffer, this.prettyName());
        return BoxesRunTime.boxToDouble((double)sketch.getTheta());
    }

    public TupleSketchThetaDouble copy(Expression child) {
        return new TupleSketchThetaDouble(child);
    }

    public Expression copy$default$1() {
        return this.child();
    }

    @Override
    public String productPrefix() {
        return "TupleSketchThetaDouble";
    }

    public int productArity() {
        return 1;
    }

    public Object productElement(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return this.child();
            }
        }
        return Statics.ioobe((int)x$1);
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof TupleSketchThetaDouble;
    }

    @Override
    public String productElementName(int x$1) {
        int n = x$1;
        switch (n) {
            case 0: {
                return "child";
            }
        }
        return (String)Statics.ioobe((int)x$1);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof TupleSketchThetaDouble)) return false;
        boolean bl = true;
        if (!bl) return false;
        TupleSketchThetaDouble tupleSketchThetaDouble = (TupleSketchThetaDouble)x$1;
        Expression expression = this.child();
        Expression expression2 = tupleSketchThetaDouble.child();
        if (expression == null) {
            if (expression2 != null) {
                return false;
            }
        } else if (!expression.equals(expression2)) return false;
        if (!tupleSketchThetaDouble.canEqual(this)) return false;
        return true;
    }

    public TupleSketchThetaDouble(Expression child) {
        this.child = child;
        CodegenFallback.$init$(this);
        ExpectsInputTypes.$init$(this);
    }
}

