/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.connect.service;

import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.spark.SparkEnv$;
import org.apache.spark.SparkSQLException;
import org.apache.spark.SparkSQLException$;
import org.apache.spark.internal.LogEntry;
import org.apache.spark.internal.LogEntry$;
import org.apache.spark.internal.LogKey;
import org.apache.spark.internal.LogKeys;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.MDC;
import org.apache.spark.internal.MessageWithContext;
import org.apache.spark.sql.classic.SparkSession;
import org.apache.spark.sql.classic.SparkSession$;
import org.apache.spark.sql.connect.config.Connect$;
import org.apache.spark.sql.connect.service.SessionHolder;
import org.apache.spark.sql.connect.service.SessionHolderInfo;
import org.apache.spark.sql.connect.service.SessionKey;
import org.apache.spark.util.ThreadUtils$;
import org.slf4j.Logger;
import org.slf4j.event.Level;
import org.sparkproject.guava.cache.Cache;
import org.sparkproject.guava.cache.CacheBuilder;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005\t\u001db\u0001B\u0014)\u0001UBQA\u0011\u0001\u0005\u0002\rCqA\u0012\u0001A\u0002\u0013%q\tC\u0004U\u0001\u0001\u0007I\u0011B+\t\rm\u0003\u0001\u0015)\u0003I\u0011\u001d\u0001\u0007\u00011A\u0005\n\u0005Dqa\u0019\u0001A\u0002\u0013%A\r\u0003\u0004g\u0001\u0001\u0006KA\u0019\u0005\bQ\u0002\u0011\r\u0011\"\u0003j\u0011\u0019Q\b\u0001)A\u0005U\"91\u0010\u0001b\u0001\n\u0013a\bbBA\r\u0001\u0001\u0006I! \u0005\u0007\u00037\u0001A\u0011B1\t\u000f\u0005u\u0001\u0001\"\u0001\u0002 !I\u0011Q\u0005\u0001C\u0002\u0013%\u0011q\u0005\u0005\t\u0003w\u0001\u0001\u0015!\u0003\u0002*!9\u0011Q\b\u0001\u0005\n\u0005}\u0002\u0002CA2\u0001\u0011\u0005!&!\u001a\t\u0011\u0005=\u0004\u0001\"\u0001+\u0003cB\u0001\"a\u001e\u0001\t\u0003Q\u0013\u0011\u0010\u0005\t\u0003\u007f\u0002A\u0011\u0001\u0016\u0002\u0002\"9\u0011Q\u0012\u0001\u0005\n\u0005=\u0005bBAK\u0001\u0011%\u0011q\u0013\u0005\b\u0003G\u0003A\u0011BAS\u0011%\t\u0019\fAI\u0001\n\u0013\t)\fC\u0004\u0002L\u0002!I!!4\t\u0013\u0005U\u0007!%A\u0005\n\u0005U\u0006bBAl\u0001\u0011\u0005\u0011\u0011\u001c\u0005\n\u0003?\u0004\u0011\u0013!C\u0001\u0003kC\u0001\"!9\u0001\t\u0003Q\u00131\u001d\u0005\b\u0003K\u0004A\u0011AAt\u0011\u001d\tY\u0010\u0001C\u0001\u0003ODq!!@\u0001\t\u0013\t\u0019\u000f\u0003\u0005\u0002\u0000\u0002!\tA\u000bB\u0001\u0011\u001d\ty\u0010\u0001C\u0005\u0005\u001bAqA!\u0006\u0001\t\u0013\u00119\u0002C\u0004\u0003\u001a\u0001!IAa\u0007\t\u0011\t}\u0001\u0001\"\u0001+\u0003GD\u0001B!\t\u0001\t\u0003Q#1\u0005\u0002\u001b'B\f'o[\"p]:,7\r^*fgNLwN\\'b]\u0006<WM\u001d\u0006\u0003S)\nqa]3sm&\u001cWM\u0003\u0002,Y\u000591m\u001c8oK\u000e$(BA\u0017/\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003_A\nQa\u001d9be.T!!\r\u001a\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005\u0019\u0014aA8sO\u000e\u00011c\u0001\u00017yA\u0011qGO\u0007\u0002q)\t\u0011(A\u0003tG\u0006d\u0017-\u0003\u0002<q\t1\u0011I\\=SK\u001a\u0004\"!\u0010!\u000e\u0003yR!a\u0010\u0018\u0002\u0011%tG/\u001a:oC2L!!\u0011 \u0003\u000f1{wmZ5oO\u00061A(\u001b8jiz\"\u0012\u0001\u0012\t\u0003\u000b\u0002i\u0011\u0001K\u0001\u0013E\u0006\u001cXmU3tg&|gn\u0011:fCR|'/F\u0001I!\r9\u0014jS\u0005\u0003\u0015b\u0012aa\u00149uS>t\u0007cA\u001cM\u001d&\u0011Q\n\u000f\u0002\n\rVt7\r^5p]B\u0002\"a\u0014*\u000e\u0003AS!!\u0015\u0017\u0002\u000f\rd\u0017m]:jG&\u00111\u000b\u0015\u0002\r'B\f'o[*fgNLwN\\\u0001\u0017E\u0006\u001cXmU3tg&|gn\u0011:fCR|'o\u0018\u0013fcR\u0011a+\u0017\t\u0003o]K!\u0001\u0017\u001d\u0003\tUs\u0017\u000e\u001e\u0005\b5\u000e\t\t\u00111\u0001I\u0003\rAH%M\u0001\u0014E\u0006\u001cXmU3tg&|gn\u0011:fCR|'\u000f\t\u0015\u0003\tu\u0003\"a\u000e0\n\u0005}C$\u0001\u0003<pY\u0006$\u0018\u000e\\3\u0002\u0019}\u0013\u0017m]3TKN\u001c\u0018n\u001c8\u0016\u0003\t\u00042aN%O\u0003Ay&-Y:f'\u0016\u001c8/[8o?\u0012*\u0017\u000f\u0006\u0002WK\"9!LBA\u0001\u0002\u0004\u0011\u0017!D0cCN,7+Z:tS>t\u0007\u0005\u000b\u0002\b;\u0006a1/Z:tS>t7\u000b^8sKV\t!\u000e\u0005\u0003leR<X\"\u00017\u000b\u00055t\u0017AC2p]\u000e,(O]3oi*\u0011q\u000e]\u0001\u0005kRLGNC\u0001r\u0003\u0011Q\u0017M^1\n\u0005Md'!D\"p]\u000e,(O]3oi6\u000b\u0007\u000f\u0005\u0002Fk&\u0011a\u000f\u000b\u0002\u000b'\u0016\u001c8/[8o\u0017\u0016L\bCA#y\u0013\tI\bFA\u0007TKN\u001c\u0018n\u001c8I_2$WM]\u0001\u000eg\u0016\u001c8/[8o'R|'/\u001a\u0011\u0002'\rdwn]3e'\u0016\u001c8/[8og\u000e\u000b7\r[3\u0016\u0003u\u0004bA`A\bi\u0006MQ\"A@\u000b\t\u0005\u0005\u00111A\u0001\u0006G\u0006\u001c\u0007.\u001a\u0006\u0005\u0003\u000b\t9!\u0001\u0004d_6lwN\u001c\u0006\u0005\u0003\u0013\tY!\u0001\u0004h_><G.\u001a\u0006\u0003\u0003\u001b\t1aY8n\u0013\r\t\tb \u0002\u0006\u0007\u0006\u001c\u0007.\u001a\t\u0004\u000b\u0006U\u0011bAA\fQ\t\t2+Z:tS>t\u0007j\u001c7eKJLeNZ8\u0002)\rdwn]3e'\u0016\u001c8/[8og\u000e\u000b7\r[3!\u0003-\u0011\u0017m]3TKN\u001c\u0018n\u001c8\u0002+%t\u0017\u000e^5bY&TXMQ1tKN+7o]5p]R\u0019a+!\t\t\r\u0005\rR\u00021\u0001L\u00035\u0019'/Z1uKN+7o]5p]\u0006\t2o\u00195fIVdW\rZ#yK\u000e,Ho\u001c:\u0016\u0005\u0005%\u0002CBA\u0016\u0003c\t)$\u0004\u0002\u0002.)\u0019\u0011q\u00067\u0002\r\u0005$x.\\5d\u0013\u0011\t\u0019$!\f\u0003\u001f\u0005#x.\\5d%\u00164WM]3oG\u0016\u00042a[A\u001c\u0013\r\tI\u0004\u001c\u0002\u0019'\u000eDW\rZ;mK\u0012,\u00050Z2vi>\u00148+\u001a:wS\u000e,\u0017AE:dQ\u0016$W\u000f\\3e\u000bb,7-\u001e;pe\u0002\n\u0011C^1mS\u0012\fG/Z*fgNLwN\\%e)\u001d1\u0016\u0011IA#\u0003?Ba!a\u0011\u0011\u0001\u0004!\u0018aA6fs\"9\u0011q\t\tA\u0002\u0005%\u0013aC:fgNLwN\\+V\u0013\u0012\u0003B!a\u0013\u0002Z9!\u0011QJA+!\r\ty\u0005O\u0007\u0003\u0003#R1!a\u00155\u0003\u0019a$o\\8u}%\u0019\u0011q\u000b\u001d\u0002\rA\u0013X\rZ3g\u0013\u0011\tY&!\u0018\u0003\rM#(/\u001b8h\u0015\r\t9\u0006\u000f\u0005\b\u0003C\u0002\u0002\u0019AA%\u0003m\u0001(/\u001a<j_V\u001cH._(cg\u0016\u0014h/\u001a3TKN\u001c\u0018n\u001c8JI\u0006Qr-\u001a;Pe\u000e\u0013X-\u0019;f\u0013N|G.\u0019;fIN+7o]5p]R)q/a\u001a\u0002j!1\u00111I\tA\u0002QDq!a\u001b\u0012\u0001\u0004\ti'\u0001\u000fqe\u00164\u0018n\\;tYf|%m]3sm\u0016$7+Z:tg&|g.\u00133\u0011\t]J\u0015\u0011J\u0001\u0013O\u0016$\u0018j]8mCR,GmU3tg&|g\u000eF\u0003x\u0003g\n)\b\u0003\u0004\u0002DI\u0001\r\u0001\u001e\u0005\b\u0003W\u0012\u0002\u0019AA7\u0003m9W\r^%t_2\fG/\u001a3TKN\u001c\u0018n\u001c8JMB\u0013Xm]3oiR!\u00111PA?!\r9\u0014j\u001e\u0005\u0007\u0003\u0007\u001a\u0002\u0019\u0001;\u0002\u0019\rdwN\\3TKN\u001c\u0018n\u001c8\u0015\u000f]\f\u0019)a\"\u0002\f\"1\u0011Q\u0011\u000bA\u0002Q\f\u0011b]8ve\u000e,7*Z=\t\u000f\u0005%E\u00031\u0001\u0002J\u0005aa.Z<TKN\u001c\u0018n\u001c8JI\"9\u0011\u0011\r\u000bA\u0002\u00055\u0014A\u0007<bY&$\u0017\r^3DY>tW\rV1sO\u0016$8+Z:tS>tGc\u0001,\u0002\u0012\"1\u00111S\u000bA\u0002Q\faA\\3x\u0017\u0016L\u0018AC4fiN+7o]5p]R)q/!'\u0002\u001c\"1\u00111\t\fA\u0002QDq!!(\u0017\u0001\u0004\ty*A\u0004eK\u001a\fW\u000f\u001c;\u0011\t]J\u0015\u0011\u0015\t\u0004o1;\u0018a\u0005:f[>4XmU3tg&|g\u000eS8mI\u0016\u0014HCBA>\u0003O\u000bI\u000b\u0003\u0004\u0002D]\u0001\r\u0001\u001e\u0005\n\u0003W;\u0002\u0013!a\u0001\u0003[\u000ba\"\u00197m_^\u0014VmY8o]\u0016\u001cG\u000fE\u00028\u0003_K1!!-9\u0005\u001d\u0011un\u001c7fC:\fQD]3n_Z,7+Z:tS>t\u0007j\u001c7eKJ$C-\u001a4bk2$HEM\u000b\u0003\u0003oSC!!,\u0002:.\u0012\u00111\u0018\t\u0005\u0003{\u000b9-\u0004\u0002\u0002@*!\u0011\u0011YAb\u0003%)hn\u00195fG.,GMC\u0002\u0002Fb\n!\"\u00198o_R\fG/[8o\u0013\u0011\tI-a0\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-A\u000btQV$Hm\\<o'\u0016\u001c8/[8o\u0011>dG-\u001a:\u0015\u000bY\u000by-a5\t\r\u0005E\u0017\u00041\u0001x\u00035\u0019Xm]:j_:Du\u000e\u001c3fe\"I\u00111V\r\u0011\u0002\u0003\u0007\u0011QV\u0001 g\",H\u000fZ8x]N+7o]5p]\"{G\u000eZ3sI\u0011,g-Y;mi\u0012\u0012\u0014\u0001D2m_N,7+Z:tS>tG#\u0002,\u0002\\\u0006u\u0007BBA\"7\u0001\u0007A\u000fC\u0005\u0002,n\u0001\n\u00111\u0001\u0002.\u000612\r\\8tKN+7o]5p]\u0012\"WMZ1vYR$#'\u0001\u0005tQV$Hm\\<o)\u00051\u0016A\u00057jgR\f5\r^5wKN+7o]5p]N,\"!!;\u0011\r\u0005-\u0018Q_A\n\u001d\u0011\ti/!=\u000f\t\u0005=\u0013q^\u0005\u0002s%\u0019\u00111\u001f\u001d\u0002\u000fA\f7m[1hK&!\u0011q_A}\u0005\r\u0019V-\u001d\u0006\u0004\u0003gD\u0014A\u00057jgR\u001cEn\\:fIN+7o]5p]N\fac]2iK\u0012,H.\u001a)fe&|G-[2DQ\u0016\u001c7n]\u0001\u0014a\u0016\u0014\u0018n\u001c3jG6\u000b\u0017N\u001c;f]\u0006t7-\u001a\u000b\u0004-\n\r\u0001b\u0002B\u0003C\u0001\u0007!qA\u0001\u0019I\u00164\u0017-\u001e7u\u0013:\f7\r^5wKRKW.Z8vi6\u001b\bcA\u001c\u0003\n%\u0019!1\u0002\u001d\u0003\t1{gn\u001a\u000b\u0006-\n=!\u0011\u0003\u0005\b\u0005\u000b\u0011\u0003\u0019\u0001B\u0004\u0011\u001d\u0011\u0019B\ta\u0001\u0003[\u000b1#[4o_J,7)^:u_6$\u0016.\\3pkR\f!C\\3x\u0013N|G.\u0019;fIN+7o]5p]R\ta*A\u000bwC2LG-\u0019;f'\u0016\u001c8/[8o\u0007J,\u0017\r^3\u0015\u0007Y\u0013i\u0002\u0003\u0004\u0002D\u0011\u0002\r\u0001^\u0001\u0016S:4\u0018\r\\5eCR,\u0017\t\u001c7TKN\u001c\u0018n\u001c8t\u0003Q\u0001X\u000f^*fgNLwN\u001c$peR+7\u000f^5oOR\u0019aK!\n\t\r\u0005Eg\u00051\u0001x\u0001")
public class SparkConnectSessionManager
implements Logging {
    private volatile Option<Function0<SparkSession>> baseSessionCreator;
    private volatile Option<SparkSession> _baseSession;
    private final ConcurrentMap<SessionKey, SessionHolder> sessionStore;
    private final Cache<SessionKey, SessionHolderInfo> closedSessionsCache;
    private final AtomicReference<ScheduledExecutorService> scheduledExecutor;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public Logging.LogStringContext LogStringContext(StringContext sc) {
        return Logging.LogStringContext$((Logging)this, (StringContext)sc);
    }

    public void withLogContext(Map<String, String> context, Function0<BoxedUnit> body) {
        Logging.withLogContext$((Logging)this, context, body);
    }

    public MDC MDC(LogKey key, Object value) {
        return Logging.MDC$((Logging)this, (LogKey)key, (Object)value);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logInfo(LogEntry entry) {
        Logging.logInfo$((Logging)this, (LogEntry)entry);
    }

    public void logInfo(LogEntry entry, Throwable throwable) {
        Logging.logInfo$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logDebug(LogEntry entry) {
        Logging.logDebug$((Logging)this, (LogEntry)entry);
    }

    public void logDebug(LogEntry entry, Throwable throwable) {
        Logging.logDebug$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logTrace(LogEntry entry) {
        Logging.logTrace$((Logging)this, (LogEntry)entry);
    }

    public void logTrace(LogEntry entry, Throwable throwable) {
        Logging.logTrace$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logWarning(LogEntry entry) {
        Logging.logWarning$((Logging)this, (LogEntry)entry);
    }

    public void logWarning(LogEntry entry, Throwable throwable) {
        Logging.logWarning$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logError(LogEntry entry) {
        Logging.logError$((Logging)this, (LogEntry)entry);
    }

    public void logError(LogEntry entry, Throwable throwable) {
        Logging.logError$((Logging)this, (LogEntry)entry, (Throwable)throwable);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void logBasedOnLevel(Level level, Function0<MessageWithContext> f) {
        Logging.logBasedOnLevel$((Logging)this, (Level)level, f);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private Option<Function0<SparkSession>> baseSessionCreator() {
        return this.baseSessionCreator;
    }

    private void baseSessionCreator_$eq(Option<Function0<SparkSession>> x$1) {
        this.baseSessionCreator = x$1;
    }

    private Option<SparkSession> _baseSession() {
        return this._baseSession;
    }

    private void _baseSession_$eq(Option<SparkSession> x$1) {
        this._baseSession = x$1;
    }

    private ConcurrentMap<SessionKey, SessionHolder> sessionStore() {
        return this.sessionStore;
    }

    private Cache<SessionKey, SessionHolderInfo> closedSessionsCache() {
        return this.closedSessionsCache;
    }

    private Option<SparkSession> baseSession() {
        block0: {
            if (!this._baseSession().isEmpty() || !this.baseSessionCreator().isDefined()) break block0;
            this._baseSession_$eq((Option<SparkSession>)new Some(((Function0)this.baseSessionCreator().get()).apply()));
        }
        return this._baseSession();
    }

    public void initializeBaseSession(Function0<SparkSession> createSession) {
        if (this.baseSessionCreator().isEmpty()) {
            this.baseSessionCreator_$eq((Option<Function0<SparkSession>>)new Some(createSession));
            return;
        }
    }

    private AtomicReference<ScheduledExecutorService> scheduledExecutor() {
        return this.scheduledExecutor;
    }

    private void validateSessionId(SessionKey key, String sessionUUID, String previouslyObservedSessionId) {
        String string = sessionUUID;
        String string2 = previouslyObservedSessionId;
        if (string == null ? string2 != null : !string.equals(string2)) {
            throw new SparkSQLException("INVALID_HANDLE.SESSION_CHANGED", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)key.sessionId())})), SparkSQLException$.MODULE$.$lessinit$greater$default$3());
        }
    }

    public SessionHolder getOrCreateIsolatedSession(SessionKey key, Option<String> previouslyObservedSesssionId) {
        SessionHolder holder = this.getSession(key, (Option<Function0<SessionHolder>>)new Some((Function0 & Serializable)() -> {
            this.validateSessionCreate(key);
            SessionHolder holder = new SessionHolder(key.userId(), key.sessionId(), this.newIsolatedSession());
            holder.initializeSession();
            return holder;
        }));
        previouslyObservedSesssionId.foreach((Function1 & Serializable)sessionId -> {
            this.validateSessionId(key, holder.session().sessionUUID(), sessionId);
            return BoxedUnit.UNIT;
        });
        return holder;
    }

    public SessionHolder getIsolatedSession(SessionKey key, Option<String> previouslyObservedSesssionId) {
        SessionHolder holder = this.getSession(key, (Option<Function0<SessionHolder>>)new Some((Function0 & Serializable)() -> {
            this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Session not found: " + key);
            if (this.closedSessionsCache().getIfPresent((Object)key) != null) {
                throw new SparkSQLException("INVALID_HANDLE.SESSION_CLOSED", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)key.sessionId())})), SparkSQLException$.MODULE$.$lessinit$greater$default$3());
            }
            throw new SparkSQLException("INVALID_HANDLE.SESSION_NOT_FOUND", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)key.sessionId())})), SparkSQLException$.MODULE$.$lessinit$greater$default$3());
        }));
        previouslyObservedSesssionId.foreach((Function1 & Serializable)sessionId -> {
            this.validateSessionId(key, holder.session().sessionUUID(), sessionId);
            return BoxedUnit.UNIT;
        });
        return holder;
    }

    public Option<SessionHolder> getIsolatedSessionIfPresent(SessionKey key) {
        return Option$.MODULE$.apply((Object)this.getSession(key, (Option<Function0<SessionHolder>>)None$.MODULE$));
    }

    public SessionHolder cloneSession(SessionKey sourceKey, String newSessionId, Option<String> previouslyObservedSessionId) {
        SessionHolder sourceSessionHolder = this.getIsolatedSession(sourceKey, (Option<String>)None$.MODULE$);
        previouslyObservedSessionId.foreach((Function1 & Serializable)sessionId -> {
            this.validateSessionId(sourceKey, sourceSessionHolder.session().sessionUUID(), sessionId);
            return BoxedUnit.UNIT;
        });
        SessionKey newKey = new SessionKey(sourceKey.userId(), newSessionId);
        this.validateCloneTargetSession(newKey);
        SessionHolder clonedSessionHolder = this.getSession(newKey, (Option<Function0<SessionHolder>>)new Some((Function0 & Serializable)() -> {
            SessionHolder session = (SessionHolder)this.sessionStore().get(newKey);
            if (session == null) {
                SparkSession clonedSparkSession = sourceSessionHolder.session().cloneSession();
                SessionHolder newHolder = new SessionHolder(newKey.userId(), newKey.sessionId(), clonedSparkSession);
                newHolder.initializeSession();
                return newHolder;
            }
            return session;
        }));
        return clonedSessionHolder;
    }

    private void validateCloneTargetSession(SessionKey newKey) {
        try {
            UUID.fromString(newKey.sessionId()).toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SparkSQLException("INVALID_CLONE_SESSION_REQUEST.TARGET_SESSION_ID_FORMAT", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetSessionId"), (Object)newKey.sessionId())})), SparkSQLException$.MODULE$.$lessinit$greater$default$3());
        }
        if (this.closedSessionsCache().getIfPresent((Object)newKey) != null) {
            throw new SparkSQLException("INVALID_CLONE_SESSION_REQUEST.TARGET_SESSION_ID_ALREADY_CLOSED", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetSessionId"), (Object)newKey.sessionId())})), SparkSQLException$.MODULE$.$lessinit$greater$default$3());
        }
        if (this.sessionStore().containsKey(newKey)) {
            throw new SparkSQLException("INVALID_CLONE_SESSION_REQUEST.TARGET_SESSION_ID_ALREADY_EXISTS", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"targetSessionId"), (Object)newKey.sessionId())})), SparkSQLException$.MODULE$.$lessinit$greater$default$3());
        }
    }

    private SessionHolder getSession(SessionKey key, Option<Function0<SessionHolder>> option) {
        SessionHolder session;
        block4: {
            SessionHolder sessionHolder;
            this.schedulePeriodicChecks();
            Option<Function0<SessionHolder>> option2 = option;
            if (option2 instanceof Some) {
                Some some = (Some)option2;
                Function0 callable = (Function0)some.value();
                sessionHolder = this.sessionStore().computeIfAbsent(key, x$1 -> (SessionHolder)callable.apply());
            } else if (None$.MODULE$.equals(option2)) {
                sessionHolder = (SessionHolder)this.sessionStore().get(key);
            } else {
                throw new MatchError(option2);
            }
            session = sessionHolder;
            if (session == null) break block4;
            session.updateAccessTime();
        }
        return session;
    }

    private Option<SessionHolder> removeSessionHolder(SessionKey key, boolean allowReconnect) {
        None$ sessionHolder = None$.MODULE$;
        sessionHolder = Option$.MODULE$.apply(this.sessionStore().get(key));
        sessionHolder.foreach((Function1 & Serializable)s -> {
            block0: {
                if (allowReconnect) break block0;
                this.closedSessionsCache().put((Object)s.key(), (Object)s.getSessionHolderInfo());
            }
            return (SessionHolder)this.sessionStore().remove(key);
        });
        return sessionHolder;
    }

    private boolean removeSessionHolder$default$2() {
        return false;
    }

    private void shutdownSessionHolder(SessionHolder sessionHolder, boolean allowReconnect) {
        sessionHolder.close();
        if (!allowReconnect) {
            this.closedSessionsCache().put((Object)sessionHolder.key(), (Object)sessionHolder.getSessionHolderInfo());
            return;
        }
    }

    public void closeSession(SessionKey key, boolean allowReconnect) {
        Option<SessionHolder> sessionHolder = this.removeSessionHolder(key, allowReconnect);
        sessionHolder.foreach((Function1 & Serializable)x$2 -> {
            this.shutdownSessionHolder(x$2, allowReconnect);
            return BoxedUnit.UNIT;
        });
    }

    public boolean closeSession$default$2() {
        return false;
    }

    public void shutdown() {
        ScheduledExecutorService executor = this.scheduledExecutor().getAndSet(null);
        if (executor != null) {
            ThreadUtils$.MODULE$.shutdown((ExecutorService)executor, (Duration)FiniteDuration$.MODULE$.apply(1L, TimeUnit.MINUTES));
        }
        this.sessionStore().clear();
        this.closedSessionsCache().invalidateAll();
    }

    private boolean shutdownSessionHolder$default$2() {
        return false;
    }

    public Seq<SessionHolderInfo> listActiveSessions() {
        return ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala(this.sessionStore().values()).asScala().map((Function1 & Serializable)x$3 -> x$3.getSessionHolderInfo())).toSeq();
    }

    public Seq<SessionHolderInfo> listClosedSessions() {
        return CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.closedSessionsCache().asMap()).asScala().values().toSeq();
    }

    private void schedulePeriodicChecks() {
        ScheduledExecutorService executor = this.scheduledExecutor().getAcquire();
        if (executor == null) {
            executor = Executors.newSingleThreadScheduledExecutor();
            if (this.scheduledExecutor().compareAndExchangeRelease(null, executor) == null) {
                long interval = BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_SESSION_MANAGER_MAINTENANCE_INTERVAL()));
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Starting thread for cleanup of expired sessions every "}))).log((Seq)Nil$.MODULE$).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"", " ms"}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.INTERVAL, BoxesRunTime.boxToLong((long)interval))})))));
                executor.scheduleAtFixedRate(() -> {
                    try {
                        long defaultInactiveTimeoutMs = BoxesRunTime.unboxToLong((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_SESSION_MANAGER_DEFAULT_SESSION_TIMEOUT()));
                        this.periodicMaintenance(defaultInactiveTimeoutMs);
                    }
                    catch (Throwable throwable) {
                        Throwable throwable2;
                        Throwable throwable3 = throwable;
                        if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                            this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Unexpected exception in periodic task", throwable2);
                        }
                        throw throwable;
                    }
                }, interval, interval, TimeUnit.MILLISECONDS);
                return;
            }
            return;
        }
    }

    public void periodicMaintenance(long defaultInactiveTimeoutMs) {
        this.periodicMaintenance(defaultInactiveTimeoutMs, false);
    }

    private void periodicMaintenance(long defaultInactiveTimeoutMs, boolean ignoreCustomTimeout) {
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Started periodic run of SparkConnectSessionManager maintenance.");
        long nowMs = System.currentTimeMillis();
        this.sessionStore().forEach((x$4, sessionHolder) -> {
            SessionHolderInfo info = sessionHolder.getSessionHolderInfo();
            if (SparkConnectSessionManager.shouldExpire$1(info, nowMs, ignoreCustomTimeout, defaultInactiveTimeoutMs)) {
                this.logInfo(LogEntry$.MODULE$.from((Function0 & Serializable)() -> this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Found session ", " that expired "}))).log((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new MDC[]{this.MDC((LogKey)LogKeys.SESSION_HOLD_INFO, info)})).$plus(this.LogStringContext(new StringContext((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"and will be closed."}))).log((Seq)Nil$.MODULE$))));
                this.removeSessionHolder(info.key(), this.removeSessionHolder$default$2());
                try {
                    this.shutdownSessionHolder((SessionHolder)sessionHolder, this.shutdownSessionHolder$default$2());
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    Throwable throwable3 = throwable;
                    if (throwable3 != null && NonFatal$.MODULE$.apply(throwable2 = throwable3)) {
                        this.logWarning((Function0<String>)(Function0 & Serializable)() -> "Unexpected exception closing session", throwable2);
                    }
                    throw throwable;
                }
                return;
            }
        });
        this.logDebug((Function0<String>)(Function0 & Serializable)() -> "Finished periodic run of SparkConnectSessionManager maintenance.");
    }

    private SparkSession newIsolatedSession() {
        SparkSession session = (SparkSession)this.baseSession().get();
        if (session.sparkContext().isStopped()) {
            Predef$.MODULE$.assert(SparkSession$.MODULE$.getDefaultSession().nonEmpty());
            return ((SparkSession)SparkSession$.MODULE$.getDefaultSession().get()).newSession();
        }
        return session.newSession();
    }

    private void validateSessionCreate(SessionKey key) {
        try {
            UUID.fromString(key.sessionId()).toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new SparkSQLException("INVALID_HANDLE.FORMAT", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)key.sessionId())})), SparkSQLException$.MODULE$.$lessinit$greater$default$3());
        }
        if (this.closedSessionsCache().getIfPresent((Object)key) != null) {
            throw new SparkSQLException("INVALID_HANDLE.SESSION_CLOSED", (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"handle"), (Object)key.sessionId())})), SparkSQLException$.MODULE$.$lessinit$greater$default$3());
        }
    }

    public void invalidateAllSessions() {
        this.sessionStore().forEach((key, sessionHolder) -> {
            this.removeSessionHolder((SessionKey)key, this.removeSessionHolder$default$2());
            this.shutdownSessionHolder((SessionHolder)sessionHolder, this.shutdownSessionHolder$default$2());
        });
        this.closedSessionsCache().invalidateAll();
    }

    public void putSessionForTesting(SessionHolder sessionHolder) {
        this.sessionStore().put(sessionHolder.key(), sessionHolder);
    }

    private static final boolean shouldExpire$1(SessionHolderInfo info, long nowMs, boolean ignoreCustomTimeout$1, long defaultInactiveTimeoutMs$1) {
        long timeoutMs = info.customInactiveTimeoutMs().isDefined() && !ignoreCustomTimeout$1 ? BoxesRunTime.unboxToLong((Object)info.customInactiveTimeoutMs().get()) : defaultInactiveTimeoutMs$1;
        return timeoutMs != -1L && info.lastAccessTimeMs() + timeoutMs <= nowMs;
    }

    public SparkConnectSessionManager() {
        Logging.$init$((Logging)this);
        this.baseSessionCreator = None$.MODULE$;
        this._baseSession = None$.MODULE$;
        this.sessionStore = new ConcurrentHashMap<SessionKey, SessionHolder>();
        this.closedSessionsCache = CacheBuilder.newBuilder().maximumSize((long)BoxesRunTime.unboxToInt((Object)SparkEnv$.MODULE$.get().conf().get(Connect$.MODULE$.CONNECT_SESSION_MANAGER_CLOSED_SESSIONS_TOMBSTONES_SIZE()))).build();
        this.scheduledExecutor = new AtomicReference();
    }
}

