/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shiro.subject.support;

import org.apache.shiro.subject.Subject;
import org.apache.shiro.subject.support.SubjectThreadState;
import org.apache.shiro.util.ThreadState;

public class SubjectRunnable
implements Runnable {
    protected final ThreadState threadState;
    private final Runnable runnable;

    public SubjectRunnable(Subject subject, Runnable delegate) {
        this(new SubjectThreadState(subject), delegate);
    }

    protected SubjectRunnable(ThreadState threadState, Runnable delegate) throws IllegalArgumentException {
        if (threadState == null) {
            throw new IllegalArgumentException("ThreadState argument cannot be null.");
        }
        this.threadState = threadState;
        if (delegate == null) {
            throw new IllegalArgumentException("Runnable argument cannot be null.");
        }
        this.runnable = delegate;
    }

    @Override
    public void run() {
        try {
            this.threadState.bind();
            this.doRun(this.runnable);
        }
        finally {
            this.threadState.restore();
        }
    }

    protected void doRun(Runnable runnable) {
        runnable.run();
    }
}

