/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.mail.javamail;

import jakarta.mail.internet.AddressException;
import jakarta.mail.internet.InternetAddress;
import java.beans.PropertyEditorSupport;
import org.springframework.util.StringUtils;

public class InternetAddressEditor
extends PropertyEditorSupport {
    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (StringUtils.hasText((String)text)) {
            try {
                this.setValue(new InternetAddress(text));
            }
            catch (AddressException ex) {
                throw new IllegalArgumentException("Could not parse mail address: " + ex.getMessage());
            }
        } else {
            this.setValue(null);
        }
    }

    @Override
    public String getAsText() {
        InternetAddress value = (InternetAddress)this.getValue();
        return value != null ? value.toUnicodeString() : "";
    }
}

