/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.enduser;

import java.util.List;
import java.util.Map;
import org.apache.syncope.client.enduser.EnduserProperties;
import org.apache.syncope.client.enduser.SyncopeWebApplication;
import org.apache.syncope.client.enduser.init.ClassPathScanImplementationLookup;
import org.apache.syncope.client.ui.commons.DynamicMenuStringResourceLoader;
import org.apache.syncope.client.ui.commons.actuate.SyncopeCoreHealthIndicator;
import org.apache.syncope.common.keymaster.client.api.ServiceOps;
import org.apache.syncope.common.keymaster.client.api.model.NetworkService;
import org.apache.syncope.common.keymaster.client.api.startstop.KeymasterStart;
import org.apache.syncope.common.keymaster.client.api.startstop.KeymasterStop;
import org.apache.wicket.request.resource.IResource;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.ResourceLoader;

@SpringBootApplication(proxyBeanMethods=false)
@EnableConfigurationProperties(value={EnduserProperties.class})
public class SyncopeEnduserApplication
extends SpringBootServletInitializer {
    public static void main(String[] args) {
        new SpringApplicationBuilder(new Class[]{SyncopeEnduserApplication.class}).properties(new String[]{"spring.config.name:enduser"}).build().run(args);
    }

    protected SpringApplicationBuilder configure(SpringApplicationBuilder builder) {
        return builder.properties(Map.of("wicket.external.websocket.registerServerEndpoint.enabled", false, "spring.config.name", "enduser")).sources(new Class[]{SyncopeEnduserApplication.class});
    }

    @ConditionalOnMissingBean
    @Bean
    public SyncopeWebApplication syncopeWebApplication(ResourceLoader resourceLoader, EnduserProperties props, ClassPathScanImplementationLookup lookup, ServiceOps serviceOps, List<IResource> resources, DynamicMenuStringResourceLoader dynamicMenuStringResourceLoader) {
        return new SyncopeWebApplication(resourceLoader, props, lookup, serviceOps, resources, dynamicMenuStringResourceLoader);
    }

    @ConditionalOnMissingBean
    @Bean
    public SyncopeCoreHealthIndicator syncopeCoreHealthIndicator(ServiceOps serviceOps, EnduserProperties props) {
        return new SyncopeCoreHealthIndicator(serviceOps, props.getAnonymousUser(), props.getAnonymousKey(), props.isUseGZIPCompression());
    }

    @ConditionalOnProperty(prefix="keymaster", name={"enableAutoRegistration"}, havingValue="true", matchIfMissing=true)
    @Bean
    public KeymasterStart keymasterStart() {
        return new KeymasterStart(NetworkService.Type.ENDUSER);
    }

    @ConditionalOnProperty(prefix="keymaster", name={"enableAutoRegistration"}, havingValue="true", matchIfMissing=true)
    @Bean
    public KeymasterStop keymasterStop() {
        return new KeymasterStop(NetworkService.Type.ENDUSER);
    }
}

