/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.provisioning.java.job;

import org.apache.syncope.common.lib.types.TaskType;
import org.apache.syncope.core.persistence.api.DomainHolder;
import org.apache.syncope.core.persistence.api.dao.ImplementationDAO;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.provisioning.api.job.JobExecutionContext;
import org.apache.syncope.core.provisioning.api.job.JobExecutionException;
import org.apache.syncope.core.provisioning.api.job.SchedTaskJobDelegate;
import org.apache.syncope.core.provisioning.java.job.Job;
import org.apache.syncope.core.spring.implementation.ImplementationManager;
import org.apache.syncope.core.spring.security.AuthContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class TaskJob
extends Job {
    private static final Logger LOG = LoggerFactory.getLogger(TaskJob.class);
    @Autowired
    private DomainHolder<?> domainHolder;
    @Autowired
    protected ImplementationDAO implementationDAO;
    private SchedTaskJobDelegate delegate;

    public SchedTaskJobDelegate getDelegate() {
        return this.delegate;
    }

    protected void delegate(JobExecutionContext context, String taskKey) throws ClassNotFoundException, JobExecutionException {
        String implKey = (String)context.getData().get("delegateImpl");
        Implementation impl = this.implementationDAO.findById(implKey).orElse(null);
        if (impl == null) {
            LOG.error("Could not find Implementation '{}', aborting", (Object)implKey);
        } else {
            this.delegate = (SchedTaskJobDelegate)ImplementationManager.build((Implementation)impl);
            this.delegate.execute((TaskType)context.getData().get("taskType"), taskKey, context);
        }
    }

    @Override
    protected void execute(JobExecutionContext context) throws JobExecutionException {
        if (!this.domainHolder.getDomains().containsKey(context.getDomain())) {
            LOG.debug("Domain {} not found, skipping", (Object)context.getDomain());
            return;
        }
        String taskKey = (String)context.getData().get("taskKey");
        try {
            AuthContextUtils.runAsAdmin((String)context.getDomain(), () -> {
                try {
                    this.delegate(context, taskKey);
                }
                catch (Exception e) {
                    if (e instanceof RuntimeException) {
                        RuntimeException re = (RuntimeException)e;
                        throw re;
                    }
                    throw new RuntimeException(e);
                }
            });
        }
        catch (RuntimeException e) {
            LOG.error("While executing task {}", (Object)taskKey, (Object)e);
            Throwable throwable = e.getCause();
            if (throwable instanceof JobExecutionException) {
                JobExecutionException jee = (JobExecutionException)throwable;
                throw jee;
            }
            throw new JobExecutionException("While executing task " + taskKey, (Throwable)e);
        }
    }

    public static enum Status {
        SUCCESS,
        FAILURE;

    }
}

