/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.support;

import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.net.WWWFormCodec;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationHolder;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationResultBuilder;
import org.apereo.cas.authentication.AuthenticationServiceSelectionPlan;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationRequest;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Response;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.configuration.model.support.captcha.GoogleRecaptchaProperties;
import org.apereo.cas.logout.slo.SingleLogoutRequestContext;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.ServicesManager;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.ticket.AuthenticationAwareTicket;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.registry.TicketRegistrySupport;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.function.FunctionUtils;
import org.apereo.cas.util.http.HttpRequestUtils;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.apereo.cas.web.BrowserStorage;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.support.ArgumentExtractor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.binding.message.MessageContext;
import org.springframework.binding.message.MessageResolver;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.webflow.context.ExternalContext;
import org.springframework.webflow.context.ExternalContextHolder;
import org.springframework.webflow.core.collection.MutableAttributeMap;
import org.springframework.webflow.engine.Flow;
import org.springframework.webflow.engine.FlowVariable;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.FlowSession;
import org.springframework.webflow.execution.RequestContext;
import org.springframework.webflow.execution.RequestContextHolder;
import org.springframework.webflow.test.MockRequestContext;

public final class WebUtils {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(WebUtils.class);
    public static final String REQUEST_SURROGATE_ACCOUNT_ATTRIBUTE = "requestSurrogateAccount";
    public static final String PARAMETER_TICKET_GRANTING_TICKET_ID = "ticketGrantingTicketId";
    public static final String PARAMETER_UNAUTHORIZED_REDIRECT_URL = "unauthorizedRedirectUrl";
    private static final String PARAMETER_CREDENTIAL = "credential";
    private static final String PARAMETER_SERVICE_TICKET_ID = "serviceTicketId";
    private static final String PARAMETER_LOGOUT_REQUESTS = "logoutRequests";
    private static final String PARAMETER_SERVICE_UI_METADATA = "serviceUIMetadata";

    public static Collection<Event> getResolvedEventsAsAttribute(RequestContext context) {
        return (Collection)context.getAttributes().get("resolvedAuthenticationEvents", Collection.class);
    }

    public static void putResolvedEventsAsAttribute(RequestContext context, Collection<Event> resolvedEvents) {
        context.getAttributes().put("resolvedAuthenticationEvents", resolvedEvents);
    }

    public static HttpServletRequest getHttpServletRequestFromExternalWebflowContext(RequestContext context) {
        return (HttpServletRequest)context.getExternalContext().getNativeRequest();
    }

    public static HttpServletRequest getHttpServletRequestFromExternalWebflowContext() {
        ExternalContext servletExternalContext = ExternalContextHolder.getExternalContext();
        if (servletExternalContext != null) {
            return (HttpServletRequest)servletExternalContext.getNativeRequest();
        }
        return null;
    }

    public static HttpServletResponse getHttpServletResponseFromExternalWebflowContext(RequestContext context) {
        return (HttpServletResponse)context.getExternalContext().getNativeResponse();
    }

    public static HttpServletResponse getHttpServletResponseFromExternalWebflowContext() {
        ExternalContext servletExternalContext = ExternalContextHolder.getExternalContext();
        if (servletExternalContext != null) {
            return (HttpServletResponse)servletExternalContext.getNativeResponse();
        }
        return null;
    }

    public static WebApplicationService getService(List<ArgumentExtractor> argumentExtractors, RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext(context);
        return HttpRequestUtils.getService(argumentExtractors, (HttpServletRequest)request);
    }

    public static WebApplicationService getService(RequestContext context) {
        return Optional.ofNullable(context).map(requestContext -> (WebApplicationService)requestContext.getFlowScope().get("service")).orElse(null);
    }

    public static RegisteredService getRegisteredService(RequestContext context) {
        return Optional.ofNullable(context).map(requestContext -> (RegisteredService)requestContext.getFlowScope().get("registeredService")).orElse(null);
    }

    public static RegisteredService getRegisteredService(HttpServletRequest request) {
        return Optional.ofNullable(request).map(requestContext -> (RegisteredService)request.getAttribute("registeredService")).orElse(null);
    }

    public static void putTicketGrantingTicket(RequestContext context, Ticket ticket) {
        context.getFlowScope().put("ticketGrantingTicket", (Object)ticket);
    }

    public static Ticket getTicketGrantingTicket(RequestContext context) {
        return (Ticket)context.getFlowScope().get("ticketGrantingTicket", Ticket.class);
    }

    public static void putTicketGrantingTicketInScopes(RequestContext context, Ticket ticket) {
        WebUtils.putTicketGrantingTicket(context, ticket);
        String ticketValue = Optional.ofNullable(ticket).map(Ticket::getId).orElse(null);
        WebUtils.putTicketGrantingTicketInScopes(context, ticketValue);
    }

    public static void putTicketGrantingTicketInScopes(RequestContext context, String ticketValue) {
        WebUtils.putTicketGrantingTicketIntoMap((MutableAttributeMap<Object>)context.getRequestScope(), ticketValue);
        WebUtils.putTicketGrantingTicketIntoMap((MutableAttributeMap<Object>)context.getFlowScope(), ticketValue);
        for (FlowSession session = context.getFlowExecutionContext().getActiveSession().getParent(); session != null; session = session.getParent()) {
            WebUtils.putTicketGrantingTicketIntoMap((MutableAttributeMap<Object>)session.getScope(), ticketValue);
        }
    }

    public static void putTicketGrantingTicketIntoMap(MutableAttributeMap<Object> map, String ticketValue) {
        FunctionUtils.doIf((boolean)StringUtils.isNotBlank((CharSequence)ticketValue), value -> map.put(PARAMETER_TICKET_GRANTING_TICKET_ID, value), value -> map.remove(PARAMETER_TICKET_GRANTING_TICKET_ID)).accept(ticketValue);
    }

    public static String getTicketGrantingTicketId(RequestContext context) {
        String tgtFromRequest = WebUtils.getTicketGrantingTicketIdFrom(context.getRequestScope());
        String tgtFromFlow = WebUtils.getTicketGrantingTicketIdFrom(context.getFlowScope());
        return Optional.ofNullable(tgtFromRequest).orElse(tgtFromFlow);
    }

    public static String getTicketGrantingTicketIdFrom(MutableAttributeMap scopeMap) {
        return (String)scopeMap.get(PARAMETER_TICKET_GRANTING_TICKET_ID);
    }

    public static void putServiceTicketInRequestScope(RequestContext context, Ticket ticketValue) {
        context.getRequestScope().put(PARAMETER_SERVICE_TICKET_ID, (Object)ticketValue.getId());
    }

    public static String getServiceTicketFromRequestScope(RequestContext context) {
        return context.getRequestScope().getString(PARAMETER_SERVICE_TICKET_ID);
    }

    public static void putUnauthorizedRedirectUrlIntoFlowScope(RequestContext context, URI url) {
        context.getFlowScope().put(PARAMETER_UNAUTHORIZED_REDIRECT_URL, (Object)url);
    }

    public static URI getUnauthorizedRedirectUrlFromFlowScope(RequestContext context) {
        return (URI)context.getFlowScope().get(PARAMETER_UNAUTHORIZED_REDIRECT_URL, URI.class);
    }

    public static void putLogoutRequests(RequestContext context, List<SingleLogoutRequestContext> requests) {
        context.getFlowScope().put(PARAMETER_LOGOUT_REQUESTS, requests);
    }

    public static void putLogoutUrls(RequestContext context, Map urls) {
        context.getFlowScope().put("logoutUrls", (Object)urls);
    }

    public static List<SingleLogoutRequestContext> getLogoutRequests(RequestContext context) {
        return (List)context.getFlowScope().get(PARAMETER_LOGOUT_REQUESTS);
    }

    public static void putServiceIntoFlowScope(RequestContext context, Service service) {
        context.getFlowScope().put("service", (Object)service);
    }

    public static void putServiceIntoFlashScope(RequestContext context, Service service) {
        context.getFlashScope().put("service", (Object)service);
    }

    public static void putWarningCookie(RequestContext context, Boolean cookieValue) {
        context.getFlowScope().put("warnCookieValue", (Object)cookieValue);
    }

    public static boolean getWarningCookie(RequestContext context) {
        String val = ObjectUtils.defaultIfNull((Object)context.getFlowScope().get("warnCookieValue"), (Object)Boolean.FALSE.toString()).toString();
        return Boolean.parseBoolean(val);
    }

    public static void putRegisteredService(HttpServletRequest request, RegisteredService registeredService) {
        request.setAttribute("registeredService", (Object)registeredService);
    }

    public static void putRegisteredService(RequestContext context, RegisteredService registeredService) {
        context.getFlowScope().put("registeredService", (Object)registeredService);
    }

    public static <T extends Credential> T getCredential(RequestContext context, @NonNull Class<T> clazz) {
        if (clazz == null) {
            throw new NullPointerException("clazz is marked non-null but is null");
        }
        Credential credential = WebUtils.getCredential(context);
        if (credential == null) {
            return null;
        }
        if (!clazz.isAssignableFrom(credential.getClass())) {
            throw new ClassCastException("credential [" + credential.getId() + " is of type " + String.valueOf(credential.getClass()) + " when we were expecting " + String.valueOf(clazz));
        }
        return (T)credential;
    }

    public static Credential getCredential(RequestContext context) {
        Credential cFromRequest = (Credential)context.getRequestScope().get(PARAMETER_CREDENTIAL);
        Credential cFromFlashScope = (Credential)context.getFlashScope().get(PARAMETER_CREDENTIAL);
        Credential cFromFlow = (Credential)context.getFlowScope().get(PARAMETER_CREDENTIAL);
        Credential cFromConversation = (Credential)context.getConversationScope().get(PARAMETER_CREDENTIAL);
        Credential credential = cFromRequest;
        if (credential == null || StringUtils.isBlank((CharSequence)credential.getId())) {
            credential = cFromFlow;
        }
        if (credential == null || StringUtils.isBlank((CharSequence)credential.getId())) {
            credential = cFromFlashScope;
        }
        if ((credential == null || StringUtils.isBlank((CharSequence)credential.getId())) && (credential = cFromConversation) != null && !StringUtils.isBlank((CharSequence)credential.getId())) {
            context.getFlowScope().put(PARAMETER_CREDENTIAL, (Object)credential);
        }
        if (credential == null) {
            FlowSession session = context.getFlowExecutionContext().getActiveSession();
            credential = (Credential)session.getScope().get(PARAMETER_CREDENTIAL, Credential.class);
        }
        if (credential != null && StringUtils.isBlank((CharSequence)credential.getId())) {
            return null;
        }
        return credential;
    }

    public static void putCredential(RequestContext context, Credential credential) {
        if (credential == null) {
            context.getRequestScope().remove(PARAMETER_CREDENTIAL);
            context.getFlowScope().remove(PARAMETER_CREDENTIAL);
            context.getConversationScope().remove(PARAMETER_CREDENTIAL);
        } else {
            WebUtils.putCredentialIntoScope((MutableAttributeMap<Object>)context.getRequestScope(), credential);
            WebUtils.putCredentialIntoScope((MutableAttributeMap<Object>)context.getFlowScope(), credential);
            WebUtils.putCredentialIntoScope((MutableAttributeMap<Object>)context.getConversationScope(), credential);
        }
    }

    public static void putCredentialIntoScope(MutableAttributeMap<Object> scope, Credential credential) {
        scope.put(PARAMETER_CREDENTIAL, (Object)credential);
    }

    public static void removeCredential(RequestContext context) {
        WebUtils.putCredential(context, null);
    }

    public static boolean isAuthenticatingAtPublicWorkstation(RequestContext ctx) {
        boolean foundParameter = ctx.getFlowScope().contains("publicWorkstation");
        if (foundParameter && BooleanUtils.toBoolean((Boolean)ctx.getFlowScope().getBoolean("publicWorkstation"))) {
            LOGGER.debug("Public workstation flag detected. SSO session will be considered renewed.");
            return true;
        }
        return false;
    }

    public static void putPublicWorkstationToFlowIfRequestParameterPresent(RequestContext context) {
        boolean foundParameter = context.getRequestParameters().contains("publicWorkstation");
        if (foundParameter && context.getRequestParameters().getBoolean("publicWorkstation").booleanValue()) {
            context.getFlowScope().put("publicWorkstation", (Object)Boolean.TRUE);
        }
    }

    public static void putWarnCookieIfRequestParameterPresent(CasCookieBuilder warnCookieGenerator, RequestContext context) {
        if (warnCookieGenerator != null) {
            LOGGER.trace("Evaluating request to determine if warning cookie should be generated");
            boolean foundParameter = context.getRequestParameters().contains("warn");
            if (foundParameter && context.getRequestParameters().getBoolean("warn").booleanValue()) {
                HttpServletResponse response = WebUtils.getHttpServletResponseFromExternalWebflowContext(context);
                HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext(context);
                warnCookieGenerator.addCookie(request, response, "true");
            }
        } else {
            LOGGER.trace("No warning cookie generator is defined");
        }
    }

    public static void putAuthentication(Authentication authentication, RequestContext requestContext) {
        WebUtils.putAuthentication(authentication, requestContext.getConversationScope());
        WebUtils.putAuthentication(authentication, requestContext.getFlowScope());
    }

    public static void putAuthentication(Ticket ticket, RequestContext requestContext) {
        if (ticket instanceof AuthenticationAwareTicket) {
            AuthenticationAwareTicket aat = (AuthenticationAwareTicket)ticket;
            WebUtils.putAuthentication(aat.getAuthentication(), requestContext);
        }
    }

    public static void putAuthentication(Authentication authentication, MutableAttributeMap scope) {
        scope.put("authentication", (Object)authentication);
    }

    public static Authentication getAuthentication(RequestContext ctx) {
        return WebUtils.getAuthentication((MutableAttributeMap<Object>)ctx.getConversationScope());
    }

    public static Authentication getAuthentication(MutableAttributeMap<Object> ctx) {
        return (Authentication)ctx.get("authentication", Authentication.class);
    }

    public static void putAuthenticationResultBuilder(AuthenticationResultBuilder builder, RequestContext ctx) {
        ctx.getConversationScope().put("authenticationResultBuilder", (Object)builder);
    }

    public static Principal getPrincipalFromRequestContext(RequestContext requestContext, TicketRegistrySupport ticketRegistrySupport) {
        String tgt = WebUtils.getTicketGrantingTicketId(requestContext);
        if (StringUtils.isBlank((CharSequence)tgt)) {
            throw new IllegalArgumentException("No ticket-granting ticket could be found in the context");
        }
        return ticketRegistrySupport.getAuthenticatedPrincipalFrom(tgt);
    }

    public static Principal getPrincipalFromRequestContext(RequestContext requestContext) {
        return (Principal)requestContext.getFlowScope().get("principal", Principal.class);
    }

    public static AuthenticationResultBuilder getAuthenticationResultBuilder(RequestContext ctx) {
        return (AuthenticationResultBuilder)ctx.getConversationScope().get("authenticationResultBuilder", AuthenticationResultBuilder.class);
    }

    public static void putAuthenticationResult(AuthenticationResult authenticationResult, RequestContext context) {
        context.getConversationScope().put("authenticationResult", (Object)authenticationResult);
    }

    public static AuthenticationResult getAuthenticationResult(RequestContext ctx) {
        return (AuthenticationResult)ctx.getConversationScope().get("authenticationResult", AuthenticationResult.class);
    }

    public static String getHttpServletRequestUserAgentFromRequestContext() {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext();
        return HttpRequestUtils.getHttpServletRequestUserAgent((HttpServletRequest)request);
    }

    public static String getHttpServletRequestUserAgentFromRequestContext(RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext(context);
        return WebUtils.getHttpServletRequestUserAgentFromRequestContext(request);
    }

    public static String getHttpServletRequestUserAgentFromRequestContext(HttpServletRequest request) {
        return HttpRequestUtils.getHttpServletRequestUserAgent((HttpServletRequest)request);
    }

    public static GeoLocationRequest getHttpServletRequestGeoLocationFromRequestContext() {
        HttpServletRequest servletRequest = WebUtils.getHttpServletRequestFromExternalWebflowContext();
        return WebUtils.getHttpServletRequestGeoLocation(servletRequest);
    }

    public static GeoLocationRequest getHttpServletRequestGeoLocationFromRequestContext(RequestContext context) {
        HttpServletRequest servletRequest = WebUtils.getHttpServletRequestFromExternalWebflowContext(context);
        return WebUtils.getHttpServletRequestGeoLocation(servletRequest);
    }

    public static GeoLocationRequest getHttpServletRequestGeoLocation(HttpServletRequest servletRequest) {
        if (servletRequest != null) {
            return HttpRequestUtils.getHttpServletRequestGeoLocation((HttpServletRequest)servletRequest);
        }
        return null;
    }

    public static void putGeoLocationTrackingIntoFlowScope(RequestContext context, Object value) {
        context.getFlowScope().put("trackGeoLocation", value);
    }

    public static Boolean isGeoLocationTrackingIntoFlowScope(RequestContext context) {
        return (Boolean)context.getFlowScope().get("trackGeoLocation", Boolean.class);
    }

    public static void putRecaptchaPropertiesFlowScope(RequestContext context, GoogleRecaptchaProperties googleRecaptcha) {
        MutableAttributeMap flowScope = context.getFlowScope();
        if (googleRecaptcha.isEnabled()) {
            flowScope.put("recaptchaSiteKey", (Object)SpringExpressionLanguageValueResolver.getInstance().resolve(googleRecaptcha.getSiteKey()));
            flowScope.put("recaptchaInvisible", (Object)googleRecaptcha.isInvisible());
            flowScope.put("recaptchaPosition", (Object)googleRecaptcha.getPosition());
            flowScope.put("recaptchaVersion", (Object)googleRecaptcha.getVersion().name().toLowerCase(Locale.ENGLISH));
        }
    }

    public static String getRecaptchaSiteKey(RequestContext context) {
        MutableAttributeMap flowScope = context.getFlowScope();
        return SpringExpressionLanguageValueResolver.getInstance().resolve((String)flowScope.get("recaptchaSiteKey", String.class));
    }

    public static void putStaticAuthenticationIntoFlowScope(RequestContext context, Object value) {
        context.getFlowScope().put("staticAuthentication", value);
    }

    public static void putPasswordManagementEnabled(RequestContext context, Boolean value) {
        context.getFlowScope().put("passwordManagementEnabled", (Object)value);
    }

    public static void putForgotUsernameEnabled(RequestContext context, Boolean value) {
        context.getFlowScope().put("forgotUsernameEnabled", (Object)value);
    }

    public static void putAccountProfileManagementEnabled(RequestContext context, Boolean value) {
        context.getFlowScope().put("accountProfileManagementEnabled", (Object)value);
    }

    public static void putSecurityQuestionsEnabled(RequestContext context, Boolean value) {
        context.getFlowScope().put("securityQuestionsEnabled", (Object)value);
    }

    public static boolean isPasswordManagementEnabled(RequestContext context) {
        return (Boolean)context.getFlowScope().get("passwordManagementEnabled", Boolean.class);
    }

    public static boolean isForgotUsernameEnabled(RequestContext context) {
        return (Boolean)context.getFlowScope().get("forgotUsernameEnabled", Boolean.class);
    }

    public static void putPrincipal(RequestContext requestContext, Principal authenticationPrincipal) {
        requestContext.getFlowScope().put("principal", (Object)authenticationPrincipal);
    }

    public static void putLogoutRedirectUrl(RequestContext context, String service) {
        context.getFlowScope().put("logoutRedirectUrl", (Object)service);
    }

    public static void putLogoutRedirectUrl(HttpServletRequest request, String service) {
        request.setAttribute("logoutRedirectUrl", (Object)service);
    }

    public static <T> T getLogoutRedirectUrl(HttpServletRequest request, Class<T> clazz) {
        Object value = request.getAttribute("logoutRedirectUrl");
        return Optional.ofNullable(value).map(clazz::cast).orElse(null);
    }

    public static <T> T getLogoutRedirectUrl(RequestContext context, Class<T> clazz) {
        return (T)context.getFlowScope().get("logoutRedirectUrl", clazz);
    }

    public static void removeLogoutRedirectUrl(RequestContext context) {
        context.getFlowScope().remove("logoutRedirectUrl");
    }

    public static void putRememberMeAuthenticationEnabled(RequestContext context, Boolean enabled) {
        context.getFlowScope().put("rememberMeAuthenticationEnabled", (Object)enabled);
    }

    public static Boolean isRememberMeAuthenticationEnabled(RequestContext context) {
        return context.getFlowScope().getBoolean("rememberMeAuthenticationEnabled", Boolean.FALSE);
    }

    public static void putServiceUserInterfaceMetadata(RequestContext requestContext, Serializable mdui) {
        if (mdui != null) {
            requestContext.getFlowScope().put(PARAMETER_SERVICE_UI_METADATA, (Object)mdui);
        }
    }

    public static <T> T getServiceUserInterfaceMetadata(RequestContext requestContext, Class<T> clz) {
        if (requestContext.getFlowScope().contains(PARAMETER_SERVICE_UI_METADATA)) {
            return (T)requestContext.getFlowScope().get(PARAMETER_SERVICE_UI_METADATA, clz);
        }
        return null;
    }

    public static String getServiceRedirectUrl(RequestContext requestContext) {
        return (String)requestContext.getRequestScope().get("url", String.class);
    }

    public static void putServiceRedirectUrl(RequestContext requestContext, String url) {
        requestContext.getRequestScope().put("url", (Object)url);
    }

    public static void putServiceResponseIntoRequestScope(RequestContext requestContext, Response response) {
        requestContext.getRequestScope().put("parameters", (Object)response.attributes());
        WebUtils.putServiceRedirectUrl(requestContext, response.url());
    }

    public static void putServiceOriginalUrlIntoRequestScope(RequestContext requestContext, WebApplicationService service) {
        requestContext.getRequestScope().put("originalUrl", (Object)service.getOriginalUrl());
    }

    public static ModelAndView produceUnauthorizedErrorView(Exception ex) {
        RuntimeException error = UnauthorizedServiceException.wrap((Throwable)ex);
        return WebUtils.produceErrorView(error);
    }

    public static ModelAndView produceErrorView(String view, Throwable e) {
        RuntimeException er;
        Throwable rootCause = e instanceof RuntimeException && (er = (RuntimeException)e).getCause() != null ? ExceptionUtils.getRootCause((Throwable)e) : e;
        ModelAndView mv = new ModelAndView(view, CollectionUtils.wrap((String)"rootCauseException", (Object)rootCause));
        mv.setStatus((HttpStatusCode)HttpStatus.BAD_REQUEST);
        LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        return mv;
    }

    public static void produceErrorView(HttpServletRequest request, HttpStatus status, String message) {
        request.setAttribute("status", (Object)status.value());
        request.setAttribute("error", (Object)status.name());
        request.setAttribute("message", (Object)message);
    }

    public static ModelAndView produceErrorView(Throwable e) {
        return WebUtils.produceErrorView("error/casServiceErrorView", e);
    }

    public static Authentication getInProgressAuthentication() {
        RequestContext context = RequestContextHolder.getRequestContext();
        return Optional.ofNullable(context).map(WebUtils::getAuthentication).orElseGet(AuthenticationHolder::getCurrentAuthentication);
    }

    public static void putSurrogateAuthenticationRequest(RequestContext context, Boolean value) {
        context.getFlowScope().put(REQUEST_SURROGATE_ACCOUNT_ATTRIBUTE, (Object)value);
    }

    public static boolean hasSurrogateAuthenticationRequest(RequestContext requestContext) {
        return BooleanUtils.toBoolean((Boolean)requestContext.getFlowScope().getBoolean(REQUEST_SURROGATE_ACCOUNT_ATTRIBUTE, Boolean.FALSE));
    }

    public static void removeSurrogateAuthenticationRequest(RequestContext requestContext) {
        requestContext.getFlowScope().remove(REQUEST_SURROGATE_ACCOUNT_ATTRIBUTE);
    }

    public static void putSurrogateAuthenticationAccounts(RequestContext requestContext, List<String> surrogates) {
        requestContext.getFlowScope().put("surrogates", surrogates);
    }

    public static List<String> getSurrogateAuthenticationAccounts(RequestContext requestContext) {
        return (List)requestContext.getFlowScope().get("surrogates", List.class);
    }

    public static void putGraphicalUserAuthenticationEnabled(RequestContext requestContext, Boolean value) {
        requestContext.getFlowScope().put("guaEnabled", (Object)value);
    }

    public static boolean isGraphicalUserAuthenticationEnabled(RequestContext requestContext) {
        return BooleanUtils.isTrue((Boolean)((Boolean)requestContext.getFlowScope().get("guaEnabled", Boolean.class)));
    }

    public static void putGraphicalUserAuthenticationUsername(RequestContext requestContext, String username) {
        requestContext.getFlowScope().put("guaUsername", (Object)username);
    }

    public static boolean containsGraphicalUserAuthenticationUsername(RequestContext requestContext) {
        return requestContext.getFlowScope().contains("guaUsername");
    }

    public static void putGraphicalUserAuthenticationImage(RequestContext requestContext, String image) {
        requestContext.getFlowScope().put("guaUserImage", (Object)image);
    }

    public static boolean containsGraphicalUserAuthenticationImage(RequestContext requestContext) {
        return requestContext.getFlowScope().contains("guaUserImage");
    }

    public static void putAvailableAuthenticationHandleNames(RequestContext context, Collection<String> availableHandlers) {
        context.getFlowScope().put("availableAuthenticationHandlerNames", availableHandlers);
    }

    public static Collection<String> getAvailableAuthenticationHandleNames(RequestContext context) {
        return (Collection)context.getFlowScope().get("availableAuthenticationHandlerNames", Collection.class);
    }

    public static void putAcceptableUsagePolicyStatusIntoFlowScope(RequestContext context, Object status) {
        context.getFlowScope().put("aupStatus", status);
    }

    public static void putAcceptableUsagePolicyTermsIntoFlowScope(RequestContext context, Object terms) {
        context.getFlowScope().put("aupPolicy", terms);
    }

    public static <T> T getAcceptableUsagePolicyTermsFromFlowScope(RequestContext requestContext, Class<T> clazz) {
        if (requestContext.getFlowScope().contains("aupPolicy")) {
            return (T)requestContext.getFlowScope().get("aupPolicy", clazz);
        }
        return null;
    }

    public static void putCustomLoginFormFields(RequestContext context, Map customLoginFormFields) {
        context.getFlowScope().put("customLoginFormFields", (Object)customLoginFormFields);
    }

    public static void putInitialHttpRequestPostParameters(RequestContext context) {
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext(context);
        String queryParams = StringUtils.defaultString((String)request.getQueryString());
        Map<String, String[]> parameters = request.getParameterMap().entrySet().stream().filter(param -> !queryParams.contains((String)param.getKey() + "=")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        context.getFlashScope().put("httpRequestInitialPostParameters", parameters);
    }

    public static void putExistingSingleSignOnSessionAvailable(RequestContext context, boolean value) {
        context.getFlowScope().put("existingSingleSignOnSessionAvailable", (Object)value);
    }

    public static Boolean isExistingSingleSignOnSessionAvailable(MockRequestContext context) {
        return (Boolean)context.getFlowScope().get("existingSingleSignOnSessionAvailable", Boolean.class);
    }

    public static void putExistingSingleSignOnSessionPrincipal(RequestContext context, Principal value) {
        context.getFlashScope().put("existingSingleSignOnSessionPrincipal", (Object)value);
    }

    public static void putCasLoginFormViewable(RequestContext context, boolean viewable) {
        context.getFlowScope().put("casLoginFormViewable", (Object)viewable);
    }

    public static boolean isCasLoginFormViewable(RequestContext context) {
        return context.getFlowScope().getBoolean("casLoginFormViewable", Boolean.TRUE);
    }

    public static boolean isCasLoginFormSetToViewable(RequestContext context) {
        return context.getFlowScope().getBoolean("casLoginFormViewable", Boolean.FALSE);
    }

    public static String getHttpRequestFullUrl(RequestContext requestContext) {
        return WebUtils.getHttpRequestFullUrl(WebUtils.getHttpServletRequestFromExternalWebflowContext(requestContext));
    }

    public static String getHttpRequestFullUrl(HttpServletRequest request) {
        StringBuffer requestURL = request.getRequestURL();
        String queryString = request.getQueryString();
        return Optional.ofNullable(queryString).map(query -> requestURL.append('?').append((String)query).toString()).orElseGet(requestURL::toString);
    }

    public static void createCredential(RequestContext requestContext) {
        WebUtils.removeCredential(requestContext);
        Flow flow = (Flow)requestContext.getActiveFlow();
        FlowVariable flowVariable = flow.getVariable(PARAMETER_CREDENTIAL);
        if (flowVariable != null) {
            flowVariable.create(requestContext);
        }
    }

    public static void putSingleLogoutRequest(HttpServletRequest request, String logoutRequest) {
        request.setAttribute("singleLogoutRequest", (Object)logoutRequest);
    }

    public static String getSingleLogoutRequest(HttpServletRequest request) {
        return (String)request.getAttribute("singleLogoutRequest");
    }

    public static void putAuthorizedServices(RequestContext requestContext, List<RegisteredService> authorizedServices) {
        requestContext.getFlowScope().put("authorizedServices", authorizedServices);
    }

    public static void putSingleSignOnSessions(RequestContext requestContext, List<? extends Serializable> sessions) {
        requestContext.getFlowScope().put("singleSignOnSessions", sessions);
    }

    public static List<? extends Serializable> getSingleSignOnSessions(RequestContext requestContext) {
        return (List)requestContext.getFlowScope().get("singleSignOnSessions", List.class);
    }

    public static List<RegisteredService> getAuthorizedServices(RequestContext requestContext) {
        return (List)requestContext.getFlowScope().get("authorizedServices", List.class);
    }

    public static void putRecaptchaForgotUsernameEnabled(RequestContext requestContext, GoogleRecaptchaProperties properties) {
        requestContext.getFlowScope().put("recaptchaForgotUsernameEnabled", (Object)properties.isEnabled());
    }

    public static Boolean isRecaptchaForgotUsernameEnabled(RequestContext requestContext) {
        return (Boolean)requestContext.getFlowScope().get("recaptchaForgotUsernameEnabled", Boolean.class);
    }

    public static void putRecaptchaPasswordManagementEnabled(RequestContext requestContext, GoogleRecaptchaProperties recaptcha) {
        requestContext.getFlowScope().put("recaptchaPasswordManagementEnabled", (Object)recaptcha.isEnabled());
    }

    public static Boolean isRecaptchaPasswordManagementEnabled(RequestContext requestContext) {
        return (Boolean)requestContext.getFlowScope().get("recaptchaPasswordManagementEnabled", Boolean.class);
    }

    public static RegisteredService resolveRegisteredService(RequestContext requestContext, ServicesManager servicesManager, AuthenticationServiceSelectionPlan serviceSelectionStrategy) throws Throwable {
        RegisteredService registeredService = WebUtils.getRegisteredService(requestContext);
        if (registeredService != null) {
            return registeredService;
        }
        WebApplicationService service = WebUtils.getService(requestContext);
        Service serviceToUse = serviceSelectionStrategy.resolveService((Service)service);
        if (serviceToUse != null) {
            return servicesManager.findServiceBy(serviceToUse);
        }
        return null;
    }

    public static void addErrorMessageToContext(RequestContext requestContext, String code, String defaultText, Object[] args) {
        WebUtils.addErrorMessageToContext(requestContext.getMessageContext(), code, defaultText, args);
    }

    public static void addErrorMessageToContext(RequestContext requestContext, String code, String defaultText) {
        WebUtils.addErrorMessageToContext(requestContext.getMessageContext(), code, defaultText, ArrayUtils.EMPTY_OBJECT_ARRAY);
    }

    public static void addErrorMessageToContext(RequestContext requestContext, String code) {
        WebUtils.addErrorMessageToContext(requestContext.getMessageContext(), code, null, null);
    }

    public static void addErrorMessageToContext(MessageContext messageContext, String code, String defaultText, Object[] args) {
        MessageResolver msg = new MessageBuilder().error().code(code).args(args).defaultText(defaultText).build();
        messageContext.addMessage(msg);
    }

    public static void addInfoMessageToContext(RequestContext requestContext, String code) {
        MessageResolver msg = new MessageBuilder().info().code(code).build();
        requestContext.getMessageContext().addMessage(msg);
    }

    public static void putLogoutPostUrl(RequestContext requestContext, String postUrl) {
        requestContext.getFlowScope().put("logoutPostUrl", (Object)postUrl);
    }

    public static void putLogoutPostData(RequestContext requestContext, Map<String, Object> postData) {
        requestContext.getFlowScope().put("logoutPostData", postData);
    }

    public static String getLogoutPostUrl(RequestContext requestContext) {
        return (String)requestContext.getFlowScope().get("logoutPostUrl", String.class);
    }

    public static Map<String, Object> getLogoutPostData(RequestContext requestContext) {
        return (Map)requestContext.getFlowScope().get("logoutPostData", Map.class);
    }

    public static void putPasswordPolicyPattern(RequestContext requestContext, String policyPattern) {
        MutableAttributeMap flowScope = requestContext.getFlowScope();
        flowScope.put("passwordPolicyPattern", (Object)policyPattern);
    }

    public static String getPasswordPolicyPattern(RequestContext requestContext) {
        MutableAttributeMap flowScope = requestContext.getFlowScope();
        return (String)flowScope.get("passwordPolicyPattern", String.class);
    }

    public static boolean isInterruptAuthenticationFlowFinalized(RequestContext requestContext) {
        return requestContext.getRequestScope().contains("authenticationFlowInterruptFinalized");
    }

    public static void putInterruptAuthenticationFlowFinalized(RequestContext requestContext) {
        requestContext.getRequestScope().put("authenticationFlowInterruptFinalized", (Object)Boolean.TRUE);
    }

    public static void putWsFederationDelegatedClients(RequestContext context, List<? extends Serializable> clients) {
        context.getFlowScope().put("wsfedUrls", clients);
    }

    public static <T extends Serializable> List<T> getWsFederationDelegatedClients(RequestContext context, Class<T> clazz) {
        return (List)context.getFlowScope().get("wsfedUrls", List.class);
    }

    public static void putWildcardedRegisteredService(RequestContext context, boolean result) {
        context.getFlowScope().put("wildcardedRegisteredService", (Object)result);
    }

    public static void putTargetTransition(RequestContext requestContext, String target) {
        requestContext.getFlashScope().put("targetTransitionToActivate", (Object)target);
    }

    public static String getTargetTransition(RequestContext requestContext) {
        return (String)requestContext.getFlashScope().get("targetTransitionToActivate", String.class);
    }

    public static void putPasswordManagementQuery(RequestContext requestContext, Serializable query) {
        requestContext.getFlowScope().put("passwordManagementQuery", (Object)query);
    }

    public static <T> T getPasswordManagementQuery(RequestContext requestContext, Class<T> clazz) {
        return (T)requestContext.getFlowScope().get("passwordManagementQuery", clazz);
    }

    public static void putActiveFlow(RequestContext requestContext) {
        String id = requestContext.getActiveFlow().getId();
        requestContext.getFlashScope().put("activeFlowId", (Object)id);
        requestContext.getFlowScope().put("activeFlowId", (Object)id);
        requestContext.getConversationScope().put("activeFlowId", (Object)id);
    }

    public static String getActiveFlow(RequestContext requestContext) {
        return (String)requestContext.getFlashScope().get("activeFlowId", requestContext.getFlowScope().get("activeFlowId", requestContext.getConversationScope().get("activeFlowId")));
    }

    public static String getBrowserStorageContextKey(RequestContext requestContext, String defaultKey) {
        return (String)requestContext.getFlowScope().get("browserStorageContextKey", String.class, (Object)defaultKey);
    }

    public static void putBrowserStorageContextKey(RequestContext requestContext, String browserStorageContextKey) {
        requestContext.getFlowScope().put("browserStorageContextKey", (Object)browserStorageContextKey);
    }

    public static Optional<String> getBrowserStoragePayload(RequestContext requestContext) throws Exception {
        if (requestContext.getRequestParameters().contains("browserStorage")) {
            return Optional.of(requestContext.getRequestParameters().getRequired("browserStorage")).stream().filter(StringUtils::isNotBlank).findFirst();
        }
        HttpServletRequest httpServletRequest = WebUtils.getHttpServletRequestFromExternalWebflowContext(requestContext);
        return WebUtils.getBrowserStoragePayload(httpServletRequest);
    }

    public static Optional<String> getBrowserStoragePayload(HttpServletRequest httpServletRequest) {
        Map<String, String> parameters = WebUtils.getHttpRequestParametersFromRequestBody(httpServletRequest);
        FunctionUtils.doIfNotBlank((CharSequence)httpServletRequest.getParameter("browserStorage"), value -> parameters.put("browserStorage", (String)value));
        return parameters.entrySet().stream().filter(param -> ((String)param.getKey()).equalsIgnoreCase("browserStorage")).map(Map.Entry::getValue).filter(StringUtils::isNotBlank).findFirst().or(() -> Optional.ofNullable((String)httpServletRequest.getAttribute("browserStorage")));
    }

    public static void putBrowserStorage(RequestContext requestContext, BrowserStorage browserStorage) {
        requestContext.getFlowScope().put("browserStorage", (Object)browserStorage);
    }

    public static BrowserStorage getBrowserStorage(RequestContext requestContext) {
        return (BrowserStorage)requestContext.getFlowScope().get("browserStorage", BrowserStorage.class);
    }

    public static void putTargetState(RequestContext requestContext, String id) {
        requestContext.getFlowScope().put("targetState", (Object)id);
    }

    public static String getTargetState(RequestContext requestContext) {
        return (String)requestContext.getFlowScope().get("targetState", String.class);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> getHttpRequestParametersFromRequestBody(HttpServletRequest httpServletRequest) {
        if (!HttpMethod.POST.matches(httpServletRequest.getMethod())) return new HashMap<String, String>();
        if (!StringUtils.equalsIgnoreCase((CharSequence)httpServletRequest.getContentType(), (CharSequence)"application/x-www-form-urlencoded")) return new HashMap<String, String>();
        try (ServletInputStream is = httpServletRequest.getInputStream();){
            if (is.isFinished()) return new HashMap<String, String>();
            String requestBody = IOUtils.toString((InputStream)is, (Charset)StandardCharsets.UTF_8);
            List encodedParams = WWWFormCodec.parse((CharSequence)requestBody, (Charset)StandardCharsets.UTF_8);
            Map<String, String> map = encodedParams.stream().filter(param -> StringUtils.isNotBlank((CharSequence)param.getValue())).peek(param -> httpServletRequest.setAttribute(param.getName(), (Object)param.getValue())).collect(Collectors.toMap(NameValuePair::getName, NameValuePair::getValue));
            return map;
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
        }
        return new HashMap<String, String>();
    }

    public static Optional<String> getRequestParameterOrAttribute(RequestContext requestContext, String name) {
        HttpServletRequest httpServletRequest = WebUtils.getHttpServletRequestFromExternalWebflowContext(requestContext);
        return WebUtils.getRequestParameterOrAttribute(httpServletRequest, name);
    }

    public static Optional<String> getRequestParameterOrAttribute(HttpServletRequest request, String name) {
        return Optional.ofNullable(request.getParameter(name)).or(() -> Optional.ofNullable((String)request.getAttribute(name))).filter(StringUtils::isNotBlank);
    }

    public static void trackFailedAuthenticationAttempt(RequestContext requestContext) {
        MutableAttributeMap flowScope = requestContext.getFlowScope();
        int attempts = flowScope.contains("authenticationFailureCount", Integer.class) ? (Integer)flowScope.get("authenticationFailureCount", Integer.class) : 0;
        flowScope.put("authenticationFailureCount", (Object)(attempts + 1));
    }

    public static Integer countFailedAuthenticationAttempts(RequestContext requestContext) {
        return (Integer)requestContext.getFlowScope().get("authenticationFailureCount", Integer.class);
    }

    public static ModelAndView toModelAndView(HttpStatus status, String viewName) {
        ModelAndView mv = new ModelAndView();
        mv.setStatus(HttpStatusCode.valueOf((int)status.value()));
        mv.setViewName(viewName);
        return mv;
    }

    @Generated
    private WebUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

