/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.web.flow.resolver.impl;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.MultifactorAuthenticationUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.authentication.principal.WebApplicationService;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.web.flow.authentication.BaseMultifactorAuthenticationProviderEventResolver;
import org.apereo.cas.web.flow.resolver.impl.CasWebflowEventResolutionConfigurationContext;
import org.apereo.cas.web.flow.util.MultifactorAuthenticationWebflowUtils;
import org.apereo.cas.web.support.WebUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.webflow.execution.Event;
import org.springframework.webflow.execution.RequestContext;

public class SelectiveMultifactorAuthenticationProviderWebflowEventResolver
extends BaseMultifactorAuthenticationProviderEventResolver {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SelectiveMultifactorAuthenticationProviderWebflowEventResolver.class);

    public SelectiveMultifactorAuthenticationProviderWebflowEventResolver(CasWebflowEventResolutionConfigurationContext webflowEventResolutionConfigurationContext) {
        super(webflowEventResolutionConfigurationContext);
    }

    public Set<Event> resolveInternal(RequestContext context) throws Throwable {
        Collection resolvedEvents = WebUtils.getResolvedEventsAsAttribute((RequestContext)context);
        Authentication authentication = WebUtils.getAuthentication((RequestContext)context);
        WebApplicationService service = WebUtils.getService((RequestContext)context);
        RegisteredService registeredService = this.resolveRegisteredServiceInRequestContext(context);
        HttpServletRequest request = WebUtils.getHttpServletRequestFromExternalWebflowContext((RequestContext)context);
        return this.resolveEventsInternal(resolvedEvents, authentication, registeredService, request, context, (Service)service);
    }

    protected Set<Event> resolveEventsInternal(Collection<Event> resolveEvents, Authentication authentication, RegisteredService registeredService, HttpServletRequest request, RequestContext context, Service service) throws Throwable {
        if (resolveEvents.isEmpty()) {
            LOGGER.trace("No events resolved for authentication transaction [{}] and service [{}]", (Object)authentication, (Object)registeredService);
        } else {
            LOGGER.trace("Collection of resolved events for this authentication sequence are:");
            resolveEvents.forEach(e -> LOGGER.trace("Event id [{}] resolved from [{}]", (Object)e.getId(), (Object)e.getSource().getClass().getName()));
        }
        Optional<Pair<Collection<Event>, Collection<MultifactorAuthenticationProvider>>> result = this.filterEventsByMultifactorAuthenticationProvider(resolveEvents, authentication, registeredService, request, service);
        return result.map(pair -> {
            MultifactorAuthenticationWebflowUtils.putResolvedMultifactorAuthenticationProviders(context, (Collection)pair.getValue());
            return new HashSet((Collection)pair.getKey());
        }).orElseGet(HashSet::new);
    }

    protected Optional<Pair<Collection<Event>, Collection<MultifactorAuthenticationProvider>>> filterEventsByMultifactorAuthenticationProvider(Collection<Event> resolveEvents, Authentication authentication, RegisteredService registeredService, HttpServletRequest request, Service service) throws Throwable {
        LOGGER.debug("Locating multifactor providers to determine support for this authentication sequence");
        Map providers = MultifactorAuthenticationUtils.getAvailableMultifactorAuthenticationProviders((ApplicationContext)this.getConfigurationContext().getApplicationContext());
        if (providers.isEmpty()) {
            LOGGER.debug("No providers are available to honor this request. Moving on...");
            return Optional.of(Pair.of(resolveEvents, new HashSet()));
        }
        Collection providerValues = providers.values();
        providerValues.removeIf(p -> resolveEvents.stream().noneMatch(e -> p.matches(e.getId())));
        resolveEvents.removeIf(e -> providerValues.stream().noneMatch(p -> p.matches(e.getId())));
        LOGGER.debug("Finalized set of resolved events are [{}]", resolveEvents);
        MultifactorAuthenticationProvider selectedProvider = this.getConfigurationContext().getMultifactorAuthenticationProviderSelector().resolve(providerValues, registeredService, authentication.getPrincipal());
        Event finalEvent = resolveEvents.stream().filter(event -> selectedProvider.matches(event.getId())).findFirst().orElseThrow(() -> new IllegalArgumentException("Unable to locate multifactor authentication provider by id " + selectedProvider.getId()));
        return Optional.of(Pair.of(List.of(finalEvent), List.of(selectedProvider)));
    }
}

