/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.common.engine.impl.el;

import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.flowable.common.engine.api.delegate.FlowableFunctionDelegate;
import org.flowable.common.engine.impl.el.FlowableFunctionResolver;

public class FunctionDelegatesFlowableFunctionResolver
implements FlowableFunctionResolver {
    protected final Map<String, FlowableFunctionDelegate> functionDelegateMap;
    protected final Map<String, Method> functionsCache = new HashMap<String, Method>();

    public FunctionDelegatesFlowableFunctionResolver(Collection<FlowableFunctionDelegate> functionDelegates) {
        this.functionDelegateMap = new LinkedHashMap<String, FlowableFunctionDelegate>();
        for (FlowableFunctionDelegate functionDelegate : functionDelegates) {
            for (String prefix : functionDelegate.prefixes()) {
                for (String localName : functionDelegate.localNames()) {
                    this.functionDelegateMap.put(prefix + ":" + localName, functionDelegate);
                }
            }
        }
    }

    @Override
    public Method resolveFunction(String prefix, String localName) throws NoSuchMethodException {
        String functionName = prefix + ":" + localName;
        if (this.functionsCache.containsKey(functionName)) {
            return this.functionsCache.get(functionName);
        }
        Method functionMethod = this.resolveFunction(this.functionDelegateMap.get(functionName), prefix, localName);
        this.functionsCache.put(functionName, functionMethod);
        return functionMethod;
    }

    protected Method resolveFunction(FlowableFunctionDelegate functionDelegate, String prefix, String localName) throws NoSuchMethodException {
        return functionDelegate != null ? functionDelegate.functionMethod(prefix, localName) : null;
    }
}

