/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.storage.impl.client;

import java.util.Collection;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.storage.impl.client.ClientStorageSaveContext;
import org.opensaml.storage.impl.client.ClientStorageService;
import org.opensaml.storage.impl.client.ClientStorageServiceOperation;
import org.slf4j.Logger;

public class PopulateClientStorageSaveContext
extends AbstractProfileAction {
    @Nonnull
    @NotEmpty
    public static final String SAVE_NOT_NEEDED = "NoSaveNeeded";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PopulateClientStorageSaveContext.class);
    @Nonnull
    private Collection<ClientStorageService> storageServices = CollectionSupport.emptyList();

    public void setStorageServices(@Nullable Collection<ClientStorageService> services) {
        this.checkSetterPreconditions();
        this.storageServices = services != null ? CollectionSupport.copyToList(services) : CollectionSupport.emptyList();
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)SAVE_NOT_NEEDED);
            return false;
        }
        if (this.storageServices.isEmpty()) {
            this.log.debug("{} No ClientStorageServices supplied, nothing to do", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)SAVE_NOT_NEEDED);
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        ClientStorageSaveContext saveCtx = new ClientStorageSaveContext();
        for (ClientStorageService service : this.storageServices) {
            ClientStorageServiceOperation operation = service.save();
            if (operation == null) continue;
            saveCtx.getStorageOperations().add(operation);
        }
        if (saveCtx.getStorageOperations().isEmpty()) {
            this.log.debug("{} No ClientStorageServices require saving, nothing to do", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)SAVE_NOT_NEEDED);
        } else {
            profileRequestContext.addSubcontext((BaseContext)saveCtx, true);
            if (this.log.isDebugEnabled()) {
                Collection ids = saveCtx.getStorageOperations().stream().map(ClientStorageServiceOperation::getStorageServiceID).collect(Collectors.toList());
                this.log.debug("{} ClientStorageServices requiring save: {}", (Object)this.getLogPrefix(), (Object)ids);
            }
        }
    }
}

