/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.web.servlet.function;

import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpOutputMessage;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.server.DelegatingServerHttpResponse;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.http.server.ServletServerHttpResponse;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.context.request.async.DeferredResult;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.function.AbstractServerResponse;
import org.springframework.web.servlet.function.DefaultAsyncServerResponse;
import org.springframework.web.servlet.function.ServerResponse;

final class StreamingServerResponse
extends AbstractServerResponse {
    private final Consumer<ServerResponse.StreamBuilder> streamConsumer;
    @Nullable
    private final Duration timeout;

    private StreamingServerResponse(HttpStatusCode statusCode, HttpHeaders headers, MultiValueMap<String, Cookie> cookies, Consumer<ServerResponse.StreamBuilder> streamConsumer, @Nullable Duration timeout) {
        super(statusCode, headers, cookies);
        this.streamConsumer = streamConsumer;
        this.timeout = timeout;
    }

    static ServerResponse create(HttpStatusCode statusCode, HttpHeaders headers, MultiValueMap<String, Cookie> cookies, Consumer<ServerResponse.StreamBuilder> streamConsumer, @Nullable Duration timeout) {
        Assert.notNull((Object)statusCode, (String)"statusCode must not be null");
        Assert.notNull((Object)headers, (String)"headers must not be null");
        Assert.notNull(cookies, (String)"cookies must not be null");
        Assert.notNull(streamConsumer, (String)"streamConsumer must not be null");
        return new StreamingServerResponse(statusCode, headers, cookies, streamConsumer, timeout);
    }

    @Override
    @Nullable
    protected ModelAndView writeToInternal(HttpServletRequest request, HttpServletResponse response, ServerResponse.Context context) throws Exception {
        DeferredResult result = this.timeout != null ? new DeferredResult(Long.valueOf(this.timeout.toMillis())) : new DeferredResult();
        DefaultAsyncServerResponse.writeAsync(request, response, result);
        this.streamConsumer.accept(new DefaultStreamBuilder(response, context, result, this.headers()));
        return null;
    }

    private static class DefaultStreamBuilder
    implements ServerResponse.StreamBuilder {
        private final ServerHttpResponse outputMessage;
        private final DeferredResult<?> deferredResult;
        private final List<HttpMessageConverter<?>> messageConverters;
        private final HttpHeaders httpHeaders;
        private boolean sendFailed;

        public DefaultStreamBuilder(HttpServletResponse response, ServerResponse.Context context, DeferredResult<?> deferredResult, HttpHeaders httpHeaders) {
            this.outputMessage = new ServletServerHttpResponse(response);
            this.deferredResult = deferredResult;
            this.messageConverters = context.messageConverters();
            this.httpHeaders = httpHeaders;
        }

        @Override
        public ServerResponse.StreamBuilder write(Object object) throws IOException {
            this.write(object, null);
            return this;
        }

        @Override
        public ServerResponse.StreamBuilder write(Object object, @Nullable MediaType mediaType) throws IOException {
            Assert.notNull((Object)object, (String)"data must not be null");
            try {
                if (object instanceof byte[]) {
                    byte[] bytes = (byte[])object;
                    this.outputMessage.getBody().write(bytes);
                } else if (object instanceof String) {
                    String str = (String)object;
                    this.outputMessage.getBody().write(str.getBytes(StandardCharsets.UTF_8));
                } else {
                    this.writeObject(object, mediaType);
                }
            }
            catch (IOException ex) {
                this.sendFailed = true;
                throw ex;
            }
            return this;
        }

        private void writeObject(Object data, @Nullable MediaType mediaType) throws IOException {
            Class<?> elementClass = data.getClass();
            for (HttpMessageConverter<?> converter : this.messageConverters) {
                if (!converter.canWrite(elementClass, mediaType)) continue;
                HttpMessageConverter<?> objectConverter = converter;
                MutableHeadersServerHttpResponse response = new MutableHeadersServerHttpResponse(this.outputMessage, this.httpHeaders);
                objectConverter.write(data, mediaType, (HttpOutputMessage)response);
                return;
            }
        }

        @Override
        public void flush() throws IOException {
            if (this.sendFailed) {
                return;
            }
            try {
                this.outputMessage.flush();
            }
            catch (IOException ex) {
                this.sendFailed = true;
                throw ex;
            }
        }

        @Override
        public void error(Throwable t) {
            if (this.sendFailed) {
                return;
            }
            this.deferredResult.setErrorResult((Object)t);
        }

        @Override
        public void complete() {
            if (this.sendFailed) {
                return;
            }
            try {
                this.outputMessage.flush();
                this.deferredResult.setResult(null);
            }
            catch (IOException ex) {
                this.deferredResult.setErrorResult((Object)ex);
            }
        }

        @Override
        public ServerResponse.StreamBuilder onTimeout(Runnable onTimeout) {
            this.deferredResult.onTimeout(onTimeout);
            return this;
        }

        @Override
        public ServerResponse.StreamBuilder onError(Consumer<Throwable> onError2) {
            this.deferredResult.onError(onError2);
            return this;
        }

        @Override
        public ServerResponse.StreamBuilder onComplete(Runnable onCompletion) {
            this.deferredResult.onCompletion(onCompletion);
            return this;
        }

        private static final class MutableHeadersServerHttpResponse
        extends DelegatingServerHttpResponse {
            private final HttpHeaders mutableHeaders = new HttpHeaders();

            public MutableHeadersServerHttpResponse(ServerHttpResponse delegate, HttpHeaders headers) {
                super(delegate);
                this.mutableHeaders.putAll((Map)delegate.getHeaders());
                this.mutableHeaders.putAll((Map)headers);
            }

            public HttpHeaders getHeaders() {
                return this.mutableHeaders;
            }
        }
    }
}

