/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.raft;

import java.util.Optional;
import java.util.Set;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Timer;
import org.apache.kafka.raft.ElectionState;
import org.apache.kafka.raft.EpochState;
import org.apache.kafka.raft.LogOffsetMetadata;
import org.apache.kafka.raft.internals.ReplicaKey;
import org.slf4j.Logger;

public class VotedState
implements EpochState {
    private final int epoch;
    private final ReplicaKey votedKey;
    private final Set<Integer> voters;
    private final int electionTimeoutMs;
    private final Timer electionTimer;
    private final Optional<LogOffsetMetadata> highWatermark;
    private final Logger log;

    public VotedState(Time time, int epoch, ReplicaKey votedKey, Set<Integer> voters, Optional<LogOffsetMetadata> highWatermark, int electionTimeoutMs, LogContext logContext) {
        this.epoch = epoch;
        this.votedKey = votedKey;
        this.voters = voters;
        this.highWatermark = highWatermark;
        this.electionTimeoutMs = electionTimeoutMs;
        this.electionTimer = time.timer((long)electionTimeoutMs);
        this.log = logContext.logger(VotedState.class);
    }

    @Override
    public ElectionState election() {
        return ElectionState.withVotedCandidate(this.epoch, this.votedKey, this.voters);
    }

    public ReplicaKey votedKey() {
        return this.votedKey;
    }

    @Override
    public int epoch() {
        return this.epoch;
    }

    @Override
    public String name() {
        return "Voted";
    }

    public long remainingElectionTimeMs(long currentTimeMs) {
        this.electionTimer.update(currentTimeMs);
        return this.electionTimer.remainingMs();
    }

    public boolean hasElectionTimeoutExpired(long currentTimeMs) {
        this.electionTimer.update(currentTimeMs);
        return this.electionTimer.isExpired();
    }

    @Override
    public boolean canGrantVote(ReplicaKey candidateKey, boolean isLogUpToDate) {
        if (this.votedKey.id() == candidateKey.id()) {
            return !this.votedKey.directoryId().isPresent() || this.votedKey.directoryId().equals(candidateKey.directoryId());
        }
        this.log.debug("Rejecting vote request from candidate ({}), already have voted for another candidate ({}) in epoch {}", new Object[]{candidateKey, this.votedKey, this.epoch});
        return false;
    }

    @Override
    public Optional<LogOffsetMetadata> highWatermark() {
        return this.highWatermark;
    }

    public String toString() {
        return String.format("Voted(epoch=%d, votedKey=%s, voters=%s, electionTimeoutMs=%d, highWatermark=%s)", this.epoch, this.votedKey, this.voters, this.electionTimeoutMs, this.highWatermark);
    }

    @Override
    public void close() {
    }
}

