/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa.entity.task;

import jakarta.persistence.CascadeType;
import jakarta.persistence.Entity;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToMany;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import jakarta.persistence.UniqueConstraint;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.syncope.core.persistence.api.entity.Implementation;
import org.apache.syncope.core.persistence.api.entity.task.AnyTemplateLiveSyncTask;
import org.apache.syncope.core.persistence.api.entity.task.LiveSyncTask;
import org.apache.syncope.core.persistence.api.entity.task.SchedTask;
import org.apache.syncope.core.persistence.api.entity.task.TaskExec;
import org.apache.syncope.core.persistence.jpa.entity.JPAImplementation;
import org.apache.syncope.core.persistence.jpa.entity.task.AbstractInboundTask;
import org.apache.syncope.core.persistence.jpa.entity.task.JPAAnyTemplateLiveSyncTask;
import org.apache.syncope.core.persistence.jpa.entity.task.JPALiveSyncTaskExec;

@Entity
@Table(name="LiveSyncTask", uniqueConstraints={@UniqueConstraint(columnNames={"resource_id"})})
public class JPALiveSyncTask
extends AbstractInboundTask<LiveSyncTask>
implements LiveSyncTask {
    private static final long serialVersionUID = 7741318722366524409L;
    public static final String TABLE = "LiveSyncTask";
    @Min(value=1L)
    @NotNull
    private @Min(value=1L) @NotNull Integer delaySecondsAcrossInvocations = 5;
    @ManyToOne(fetch=FetchType.EAGER)
    private JPAImplementation liveSyncDeltaMapper;
    @ManyToMany(fetch=FetchType.EAGER)
    @JoinTable(name="LiveSyncTaskAction", joinColumns={@JoinColumn(name="task_id")}, inverseJoinColumns={@JoinColumn(name="implementation_id")}, uniqueConstraints={@UniqueConstraint(columnNames={"task_id", "implementation_id"})})
    private List<JPAImplementation> actions = new ArrayList<JPAImplementation>();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.EAGER, mappedBy="liveSyncTask")
    private List<JPAAnyTemplateLiveSyncTask> templates = new ArrayList<JPAAnyTemplateLiveSyncTask>();
    @OneToMany(targetEntity=JPALiveSyncTaskExec.class, cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="task")
    private List<TaskExec<SchedTask>> executions = new ArrayList<TaskExec<SchedTask>>();
    private static int pcInheritedFieldCount = AbstractInboundTask.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;

    public int getDelaySecondsAcrossInvocations() {
        return Optional.ofNullable(JPALiveSyncTask.pcGetdelaySecondsAcrossInvocations(this)).orElse(5);
    }

    public void setDelaySecondsAcrossInvocations(int delaySecondsAcrossInvocations) {
        JPALiveSyncTask.pcSetdelaySecondsAcrossInvocations(this, delaySecondsAcrossInvocations);
    }

    public Implementation getLiveSyncDeltaMapper() {
        return JPALiveSyncTask.pcGetliveSyncDeltaMapper(this);
    }

    public void setLiveSyncDeltaMapper(Implementation liveSyncDeltaMapper) {
        this.checkType(liveSyncDeltaMapper, JPAImplementation.class);
        this.checkImplementationType(liveSyncDeltaMapper, "LIVE_SYNC_DELTA_MAPPER");
        JPALiveSyncTask.pcSetliveSyncDeltaMapper(this, (JPAImplementation)liveSyncDeltaMapper);
    }

    public boolean add(Implementation action) {
        this.checkType(action, JPAImplementation.class);
        this.checkImplementationType(action, "INBOUND_ACTIONS");
        return JPALiveSyncTask.pcGetactions(this).contains((JPAImplementation)action) || JPALiveSyncTask.pcGetactions(this).add((JPAImplementation)action);
    }

    public List<? extends Implementation> getActions() {
        return JPALiveSyncTask.pcGetactions(this);
    }

    public boolean add(AnyTemplateLiveSyncTask template) {
        this.checkType(template, JPAAnyTemplateLiveSyncTask.class);
        return JPALiveSyncTask.pcGettemplates(this).add((JPAAnyTemplateLiveSyncTask)template);
    }

    public Optional<? extends AnyTemplateLiveSyncTask> getTemplate(String anyType) {
        return JPALiveSyncTask.pcGettemplates(this).stream().filter(template -> anyType != null && anyType.equals(template.getAnyType().getKey())).findFirst();
    }

    public List<? extends AnyTemplateLiveSyncTask> getTemplates() {
        return JPALiveSyncTask.pcGettemplates(this);
    }

    @Override
    protected Class<? extends TaskExec<SchedTask>> executionClass() {
        return JPALiveSyncTaskExec.class;
    }

    @Override
    protected List<TaskExec<SchedTask>> executions() {
        return JPALiveSyncTask.pcGetexecutions(this);
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 255933283;
    }

    static {
        pcPCSuperclass = AbstractInboundTask.class;
        pcFieldNames = new String[]{"actions", "delaySecondsAcrossInvocations", "executions", "liveSyncDeltaMapper", "templates"};
        pcFieldTypes = new Class[]{List.class, Integer.class, List.class, JPAImplementation.class, List.class};
        pcFieldFlags = new byte[]{10, 26, 5, 26, 10};
        PCRegistry.register(JPALiveSyncTask.class, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"JPALiveSyncTask", (PersistenceCapable)new JPALiveSyncTask());
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.actions = null;
        this.delaySecondsAcrossInvocations = null;
        this.executions = null;
        this.liveSyncDeltaMapper = null;
        this.templates = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        JPALiveSyncTask jPALiveSyncTask = new JPALiveSyncTask();
        if (bl) {
            jPALiveSyncTask.pcClearFields();
        }
        jPALiveSyncTask.pcStateManager = stateManager;
        jPALiveSyncTask.pcCopyKeyFieldsFromObjectId(object);
        return jPALiveSyncTask;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        JPALiveSyncTask jPALiveSyncTask = new JPALiveSyncTask();
        if (bl) {
            jPALiveSyncTask.pcClearFields();
        }
        jPALiveSyncTask.pcStateManager = stateManager;
        return jPALiveSyncTask;
    }

    protected static int pcGetManagedFieldCount() {
        return 5 + AbstractInboundTask.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.actions = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.delaySecondsAcrossInvocations = (Integer)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.executions = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.liveSyncDeltaMapper = (JPAImplementation)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.templates = (List)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcReplaceField(nArray[i]);
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.actions);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.delaySecondsAcrossInvocations);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.executions);
                return;
            }
            case 3: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.liveSyncDeltaMapper);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, this.templates);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        for (int i = 0; i < nArray.length; ++i) {
            this.pcProvideField(nArray[i]);
        }
    }

    protected void pcCopyField(JPALiveSyncTask jPALiveSyncTask, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(jPALiveSyncTask, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.actions = jPALiveSyncTask.actions;
                return;
            }
            case 1: {
                this.delaySecondsAcrossInvocations = jPALiveSyncTask.delaySecondsAcrossInvocations;
                return;
            }
            case 2: {
                this.executions = jPALiveSyncTask.executions;
                return;
            }
            case 3: {
                this.liveSyncDeltaMapper = jPALiveSyncTask.liveSyncDeltaMapper;
                return;
            }
            case 4: {
                this.templates = jPALiveSyncTask.templates;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        JPALiveSyncTask jPALiveSyncTask = (JPALiveSyncTask)object;
        if (jPALiveSyncTask.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        for (int i = 0; i < nArray.length; ++i) {
            this.pcCopyField(jPALiveSyncTask, nArray[i]);
        }
    }

    @Override
    public Class pcGetIDOwningClass() {
        return JPALiveSyncTask.class;
    }

    private static final List pcGetactions(JPALiveSyncTask jPALiveSyncTask) {
        if (jPALiveSyncTask.pcStateManager == null) {
            return jPALiveSyncTask.actions;
        }
        int n = pcInheritedFieldCount + 0;
        jPALiveSyncTask.pcStateManager.accessingField(n);
        return jPALiveSyncTask.actions;
    }

    private static final void pcSetactions(JPALiveSyncTask jPALiveSyncTask, List list) {
        if (jPALiveSyncTask.pcStateManager == null) {
            jPALiveSyncTask.actions = list;
            return;
        }
        jPALiveSyncTask.pcStateManager.settingObjectField((PersistenceCapable)jPALiveSyncTask, pcInheritedFieldCount + 0, jPALiveSyncTask.actions, (Object)list, 0);
    }

    private static final Integer pcGetdelaySecondsAcrossInvocations(JPALiveSyncTask jPALiveSyncTask) {
        if (jPALiveSyncTask.pcStateManager == null) {
            return jPALiveSyncTask.delaySecondsAcrossInvocations;
        }
        int n = pcInheritedFieldCount + 1;
        jPALiveSyncTask.pcStateManager.accessingField(n);
        return jPALiveSyncTask.delaySecondsAcrossInvocations;
    }

    private static final void pcSetdelaySecondsAcrossInvocations(JPALiveSyncTask jPALiveSyncTask, Integer n) {
        if (jPALiveSyncTask.pcStateManager == null) {
            jPALiveSyncTask.delaySecondsAcrossInvocations = n;
            return;
        }
        jPALiveSyncTask.pcStateManager.settingObjectField((PersistenceCapable)jPALiveSyncTask, pcInheritedFieldCount + 1, (Object)jPALiveSyncTask.delaySecondsAcrossInvocations, (Object)n, 0);
    }

    private static final List pcGetexecutions(JPALiveSyncTask jPALiveSyncTask) {
        if (jPALiveSyncTask.pcStateManager == null) {
            return jPALiveSyncTask.executions;
        }
        int n = pcInheritedFieldCount + 2;
        jPALiveSyncTask.pcStateManager.accessingField(n);
        return jPALiveSyncTask.executions;
    }

    private static final void pcSetexecutions(JPALiveSyncTask jPALiveSyncTask, List list) {
        if (jPALiveSyncTask.pcStateManager == null) {
            jPALiveSyncTask.executions = list;
            return;
        }
        jPALiveSyncTask.pcStateManager.settingObjectField((PersistenceCapable)jPALiveSyncTask, pcInheritedFieldCount + 2, jPALiveSyncTask.executions, (Object)list, 0);
    }

    private static final JPAImplementation pcGetliveSyncDeltaMapper(JPALiveSyncTask jPALiveSyncTask) {
        if (jPALiveSyncTask.pcStateManager == null) {
            return jPALiveSyncTask.liveSyncDeltaMapper;
        }
        int n = pcInheritedFieldCount + 3;
        jPALiveSyncTask.pcStateManager.accessingField(n);
        return jPALiveSyncTask.liveSyncDeltaMapper;
    }

    private static final void pcSetliveSyncDeltaMapper(JPALiveSyncTask jPALiveSyncTask, JPAImplementation jPAImplementation) {
        if (jPALiveSyncTask.pcStateManager == null) {
            jPALiveSyncTask.liveSyncDeltaMapper = jPAImplementation;
            return;
        }
        jPALiveSyncTask.pcStateManager.settingObjectField((PersistenceCapable)jPALiveSyncTask, pcInheritedFieldCount + 3, (Object)jPALiveSyncTask.liveSyncDeltaMapper, (Object)jPAImplementation, 0);
    }

    private static final List pcGettemplates(JPALiveSyncTask jPALiveSyncTask) {
        if (jPALiveSyncTask.pcStateManager == null) {
            return jPALiveSyncTask.templates;
        }
        int n = pcInheritedFieldCount + 4;
        jPALiveSyncTask.pcStateManager.accessingField(n);
        return jPALiveSyncTask.templates;
    }

    private static final void pcSettemplates(JPALiveSyncTask jPALiveSyncTask, List list) {
        if (jPALiveSyncTask.pcStateManager == null) {
            jPALiveSyncTask.templates = list;
            return;
        }
        jPALiveSyncTask.pcStateManager.settingObjectField((PersistenceCapable)jPALiveSyncTask, pcInheritedFieldCount + 4, jPALiveSyncTask.templates, (Object)list, 0);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        boolean bl = this.pcSerializing();
        objectOutputStream.defaultWriteObject();
        if (bl) {
            this.pcSetDetachedState(null);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.pcSetDetachedState(PersistenceCapable.DESERIALIZED);
        objectInputStream.defaultReadObject();
    }
}

