/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.support.leader;

import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.SmartLifecycle;
import org.springframework.core.log.LogAccessor;
import org.springframework.core.task.AsyncTaskExecutor;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.integration.leader.Candidate;
import org.springframework.integration.leader.Context;
import org.springframework.integration.leader.DefaultCandidate;
import org.springframework.integration.leader.event.DefaultLeaderEventPublisher;
import org.springframework.integration.leader.event.LeaderEventPublisher;
import org.springframework.integration.support.locks.LockRegistry;
import org.springframework.util.Assert;

public class LockRegistryLeaderInitiator
implements SmartLifecycle,
DisposableBean,
ApplicationEventPublisherAware {
    public static final long DEFAULT_HEART_BEAT_TIME = 500L;
    public static final long DEFAULT_BUSY_WAIT_TIME = 50L;
    private static final LogAccessor LOGGER = new LogAccessor(LockRegistryLeaderInitiator.class);
    private final Lock lock = new ReentrantLock();
    private final LockRegistry locks;
    private final Candidate candidate;
    private final Context nullContext = new Context(){

        @Override
        public boolean isLeader() {
            return false;
        }

        @Override
        public String getRole() {
            return LockRegistryLeaderInitiator.this.candidate.getRole();
        }
    };
    private AsyncTaskExecutor taskExecutor = new SimpleAsyncTaskExecutor("lock-leadership-");
    private long heartBeatMillis = 500L;
    private boolean publishFailedEvents = false;
    private LeaderSelector leaderSelector;
    private ApplicationEventPublisher applicationEventPublisher;
    private LeaderEventPublisher leaderEventPublisher;
    private boolean autoStartup = true;
    private int phase = 2147482647;
    private volatile long busyWaitMillis = 50L;
    private volatile boolean running;
    private volatile Future<?> future;

    public LockRegistryLeaderInitiator(LockRegistry locks) {
        this(locks, new DefaultCandidate());
    }

    public LockRegistryLeaderInitiator(LockRegistry locks, Candidate candidate) {
        Assert.notNull((Object)locks, (String)"'locks' must not be null");
        Assert.notNull((Object)candidate, (String)"'candidate' must not be null");
        this.locks = locks;
        this.candidate = candidate;
    }

    public void setTaskExecutor(AsyncTaskExecutor taskExecutor) {
        Assert.notNull((Object)taskExecutor, (String)"A 'taskExecutor' must not be null.");
        this.taskExecutor = taskExecutor;
    }

    public void setHeartBeatMillis(long heartBeatMillis) {
        this.heartBeatMillis = heartBeatMillis;
    }

    public void setBusyWaitMillis(long busyWaitMillis) {
        this.busyWaitMillis = busyWaitMillis;
    }

    public void setLeaderEventPublisher(LeaderEventPublisher leaderEventPublisher) {
        this.leaderEventPublisher = leaderEventPublisher;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public boolean isRunning() {
        return this.running;
    }

    public int getPhase() {
        return this.phase;
    }

    public void setPhase(int phase) {
        this.phase = phase;
    }

    public boolean isAutoStartup() {
        return this.autoStartup;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public Context getContext() {
        if (this.leaderSelector == null) {
            return this.nullContext;
        }
        return this.leaderSelector.context;
    }

    public boolean isPublishFailedEvents() {
        return this.publishFailedEvents;
    }

    public void setPublishFailedEvents(boolean publishFailedEvents) {
        this.publishFailedEvents = publishFailedEvents;
    }

    public void start() {
        this.lock.lock();
        try {
            if (this.leaderEventPublisher == null && this.applicationEventPublisher != null) {
                this.leaderEventPublisher = new DefaultLeaderEventPublisher(this.applicationEventPublisher);
            }
            if (!this.running) {
                this.leaderSelector = new LeaderSelector(this.buildLeaderPath());
                this.running = true;
                this.future = this.taskExecutor.submit((Callable)this.leaderSelector);
                LOGGER.debug((CharSequence)"Started LeaderInitiator");
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public void destroy() {
        this.stop();
    }

    public void stop() {
        this.lock.lock();
        try {
            if (this.running) {
                this.running = false;
                if (this.future != null) {
                    this.future.cancel(true);
                }
                this.future = null;
                LOGGER.debug(() -> "Stopped LeaderInitiator for " + String.valueOf(this.getContext()));
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private String buildLeaderPath() {
        return this.candidate.getRole();
    }

    protected class LeaderSelector
    implements Callable<Void> {
        private final Lock lock;
        private final String lockKey;
        private final LockContext context;
        private volatile boolean locked;
        private volatile boolean yielding;

        LeaderSelector(String lockKey) {
            this.context = new LockContext();
            this.locked = false;
            this.yielding = false;
            this.lock = LockRegistryLeaderInitiator.this.locks.obtain(lockKey);
            this.lockKey = lockKey;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public Void call() {
            try {
                while (LockRegistryLeaderInitiator.this.isRunning()) {
                    if (Thread.currentThread().isInterrupted()) {
                        this.restartSelectorBecauseOfError(new InterruptedException());
                        Void void_ = null;
                        return void_;
                    }
                    if (this.yielding) {
                        this.yielding = false;
                        this.unlockAndHandleException(null);
                        continue;
                    }
                    try {
                        this.tryAcquireLock();
                    }
                    catch (Exception e) {
                        if (this.unlockAndHandleException(e)) {
                            Void void_ = null;
                            if (!this.locked) return void_;
                            this.locked = false;
                            try {
                                this.lock.unlock();
                            }
                            catch (Exception ex) {
                                LOGGER.debug((Throwable)ex, () -> "Could not unlock during stop for " + String.valueOf(this.context) + " - treat as broken. Revoking...");
                            }
                            this.handleRevoked();
                            return void_;
                        }
                        try {
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                            return null;
                        }
                    }
                }
            }
            finally {
                if (this.locked) {
                    this.locked = false;
                    try {
                        this.lock.unlock();
                    }
                    catch (Exception ex) {
                        LOGGER.debug((Throwable)ex, () -> "Could not unlock during stop for " + String.valueOf(this.context) + " - treat as broken. Revoking...");
                    }
                    this.handleRevoked();
                }
            }
        }

        private void tryAcquireLock() throws InterruptedException {
            LOGGER.debug(() -> "Acquiring the lock for " + String.valueOf(this.context));
            boolean acquired = this.lock.tryLock(LockRegistryLeaderInitiator.this.heartBeatMillis, TimeUnit.MILLISECONDS);
            if (!this.locked) {
                if (acquired) {
                    this.locked = true;
                    this.handleGranted();
                } else if (LockRegistryLeaderInitiator.this.isPublishFailedEvents()) {
                    this.publishFailedToAcquire();
                }
            } else if (acquired) {
                this.lock.unlock();
                if (LockRegistryLeaderInitiator.this.isRunning()) {
                    Thread.sleep(LockRegistryLeaderInitiator.this.heartBeatMillis);
                }
            } else {
                this.locked = false;
                this.handleRevoked();
                if (LockRegistryLeaderInitiator.this.isRunning()) {
                    Thread.sleep(LockRegistryLeaderInitiator.this.busyWaitMillis);
                }
            }
        }

        private boolean unlockAndHandleException(Exception ex) {
            if (this.locked) {
                this.locked = false;
                try {
                    this.lock.unlock();
                }
                catch (Exception e1) {
                    LOGGER.debug((Throwable)e1, () -> "Could not unlock - treat as broken " + String.valueOf(this.context) + ". Revoking " + (LockRegistryLeaderInitiator.this.isRunning() ? " and retrying..." : "..."));
                }
                this.handleRevoked();
            }
            if (ex instanceof InterruptedException || Thread.currentThread().isInterrupted()) {
                Thread.currentThread().interrupt();
                if (LockRegistryLeaderInitiator.this.isRunning()) {
                    this.restartSelectorBecauseOfError(ex);
                }
                return true;
            }
            if (LockRegistryLeaderInitiator.this.isRunning()) {
                try {
                    Thread.sleep(LockRegistryLeaderInitiator.this.busyWaitMillis);
                }
                catch (InterruptedException e1) {
                    Thread.currentThread().interrupt();
                }
            }
            LOGGER.debug((Throwable)ex, () -> "Error acquiring the lock for " + String.valueOf(this.context) + ". " + (LockRegistryLeaderInitiator.this.isRunning() ? "Retrying..." : ""));
            return false;
        }

        private void restartSelectorBecauseOfError(Exception ex) {
            LOGGER.warn((Throwable)ex, () -> "Restarting LeaderSelector for " + String.valueOf(this.context) + " because of error.");
            LockRegistryLeaderInitiator.this.future = LockRegistryLeaderInitiator.this.taskExecutor.submit(() -> {
                Thread.sleep(LockRegistryLeaderInitiator.this.busyWaitMillis);
                return this.call();
            });
        }

        public boolean isLeader() {
            return this.locked;
        }

        private void handleGranted() throws InterruptedException {
            LockRegistryLeaderInitiator.this.candidate.onGranted(this.context);
            if (LockRegistryLeaderInitiator.this.leaderEventPublisher != null) {
                try {
                    LockRegistryLeaderInitiator.this.leaderEventPublisher.publishOnGranted(LockRegistryLeaderInitiator.this, this.context, this.lockKey);
                }
                catch (Exception ex) {
                    LOGGER.warn((Throwable)ex, (CharSequence)"Error publishing OnGranted event.");
                }
            }
        }

        private void handleRevoked() {
            LockRegistryLeaderInitiator.this.candidate.onRevoked(this.context);
            if (LockRegistryLeaderInitiator.this.leaderEventPublisher != null) {
                try {
                    LockRegistryLeaderInitiator.this.leaderEventPublisher.publishOnRevoked(LockRegistryLeaderInitiator.this, this.context, LockRegistryLeaderInitiator.this.candidate.getRole());
                }
                catch (Exception ex) {
                    LOGGER.warn((Throwable)ex, (CharSequence)"Error publishing OnRevoked event.");
                }
            }
        }

        private void publishFailedToAcquire() {
            if (LockRegistryLeaderInitiator.this.leaderEventPublisher != null) {
                try {
                    LockRegistryLeaderInitiator.this.leaderEventPublisher.publishOnFailedToAcquire(LockRegistryLeaderInitiator.this, this.context, LockRegistryLeaderInitiator.this.candidate.getRole());
                }
                catch (Exception ex) {
                    LOGGER.warn((Throwable)ex, (CharSequence)"Error publishing OnFailedToAcquire event.");
                }
            }
        }
    }

    private class LockContext
    implements Context {
        LockContext() {
        }

        @Override
        public boolean isLeader() {
            return LockRegistryLeaderInitiator.this.leaderSelector.isLeader();
        }

        @Override
        public void yield() {
            LOGGER.debug(() -> "Yielding leadership from " + String.valueOf(this));
            LockRegistryLeaderInitiator.this.leaderSelector.yielding = true;
        }

        @Override
        public String getRole() {
            return LockRegistryLeaderInitiator.this.candidate.getRole();
        }

        public String toString() {
            return "LockContext{role=" + LockRegistryLeaderInitiator.this.candidate.getRole() + ", id=" + LockRegistryLeaderInitiator.this.candidate.getId() + ", isLeader=" + this.isLeader() + "}";
        }
    }
}

