/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.mfa.simple.web.flow;

import java.util.Map;
import java.util.function.Supplier;
import lombok.Generated;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.model.support.mfa.simple.CasSimpleMultifactorAuthenticationProperties;
import org.apereo.cas.configuration.model.support.phone.PhoneProperties;
import org.apereo.cas.notifications.CommunicationsManager;
import org.apereo.cas.notifications.call.PhoneCallBodyBuilder;
import org.apereo.cas.notifications.call.PhoneCallRequest;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.util.function.FunctionUtils;
import org.jooq.lambda.Unchecked;
import org.springframework.webflow.execution.RequestContext;

public class CasSimpleMultifactorMakePhoneCall {
    private final CommunicationsManager communicationsManager;
    private final CasSimpleMultifactorAuthenticationProperties properties;

    protected boolean call(Principal principal, Ticket tokenTicket, RequestContext requestContext) {
        return (Boolean)FunctionUtils.doIf((boolean)this.communicationsManager.isPhoneOperatorDefined(), (Supplier)Unchecked.supplier(() -> {
            PhoneProperties phoneProperties = this.properties.getPhone();
            String token = tokenTicket.getId();
            String tokenWithoutPrefix = token.substring("CASMFA".length() + 1);
            String messageBody = this.buildMessageBody(phoneProperties, token, tokenWithoutPrefix);
            PhoneCallRequest callRequest = PhoneCallRequest.builder().from(phoneProperties.getFrom()).principal(principal).attribute(phoneProperties.getAttributeName()).text(messageBody).build();
            return this.communicationsManager.phoneCall(callRequest);
        }), () -> false).get();
    }

    protected String buildMessageBody(PhoneProperties phoneProperties, String token, String tokenWithoutPrefix) {
        return (String)FunctionUtils.doIfNotBlank((CharSequence)phoneProperties.getText(), () -> PhoneCallBodyBuilder.builder().properties(phoneProperties).parameters(Map.of("token", token, "tokenWithoutPrefix", tokenWithoutPrefix)).build().get(), () -> token);
    }

    @Generated
    private CasSimpleMultifactorMakePhoneCall(CommunicationsManager communicationsManager, CasSimpleMultifactorAuthenticationProperties properties) {
        this.communicationsManager = communicationsManager;
        this.properties = properties;
    }

    @Generated
    protected static CasSimpleMultifactorMakePhoneCall of(CommunicationsManager communicationsManager, CasSimpleMultifactorAuthenticationProperties properties) {
        return new CasSimpleMultifactorMakePhoneCall(communicationsManager, properties);
    }
}

