/*
 * Decompiled with CFR 0.152.
 */
package org.wicketstuff.egrid.attribute;

import java.io.Serializable;
import org.wicketstuff.egrid.attribute.Options;

public class StyleAttribute
implements Serializable {
    public static final String HEIGHT = "height";
    public static final String WIDTH = "width";
    public static final String DISPLAY = "display";
    public static final String VISIBILITY = "visibility";
    public static final String TOP = "top";
    public static final String LEFT = "left";
    public static final String TEXT_ALIGN = "text-align";
    public static final String COLOR = "color";
    public static final String FONT_WEIGHT = "font-weight";
    public static final String FONT_SIZE = "font-size";
    public static final String ALIGN_CENTER = "center";
    public static final String ALIGN_RIGHT = "right";
    public static final String ALIGN_LEFT = "left";
    public static final String FONT_BOLD = "bold";
    private static final long serialVersionUID = 1L;
    private Options styleOptions = new Options();

    public final StyleAttribute setTop(String top) {
        this.put(TOP, top);
        return this;
    }

    public final StyleAttribute setLeft(String left) {
        this.put("left", left);
        return this;
    }

    public final StyleAttribute setHeight(String height) {
        this.put(HEIGHT, height);
        return this;
    }

    public final StyleAttribute setWidth(String width) {
        this.put(WIDTH, width);
        return this;
    }

    public final StyleAttribute setDisplay(String display) {
        this.put(DISPLAY, display);
        return this;
    }

    public final StyleAttribute setVisibility(String visibility) {
        this.put(VISIBILITY, visibility);
        return this;
    }

    public final StyleAttribute setTextAlign(String alignment) {
        this.put(TEXT_ALIGN, alignment);
        return this;
    }

    public final StyleAttribute setColor(String color) {
        this.put(COLOR, color);
        return this;
    }

    public final StyleAttribute setRedColor() {
        this.put(COLOR, "red");
        return this;
    }

    public final StyleAttribute setFontWeight(String fontWeight) {
        this.put(FONT_WEIGHT, fontWeight);
        return this;
    }

    public final StyleAttribute setFontSize(int size) {
        this.put(TOP, size + "px");
        return this;
    }

    public final StyleAttribute setBoldFont() {
        this.put(FONT_WEIGHT, FONT_BOLD);
        return this;
    }

    public final StyleAttribute alignCenter() {
        this.setTextAlign(ALIGN_CENTER);
        return this;
    }

    public final StyleAttribute alignLeft() {
        this.setTextAlign("left");
        return this;
    }

    public final StyleAttribute alignRight() {
        this.setTextAlign(ALIGN_RIGHT);
        return this;
    }

    public final String getStyles() {
        return this.styleOptions.getCSSOptions();
    }

    public final void put(String attribute, String value) {
        this.styleOptions.put(attribute, value);
    }
}

