/*
 * Decompiled with CFR 0.152.
 */
package io.github.bucket4j;

import io.github.bucket4j.Bandwidth;
import io.github.bucket4j.BucketExceptions;
import java.time.Duration;
import java.time.Instant;

public class BandwidthBuilder {
    public static BandwidthBuilderCapacityStage builder() {
        return new BandwidthBuilderImpl();
    }

    private static final class BandwidthBuilderImpl
    implements BandwidthBuilderCapacityStage,
    BandwidthBuilderRefillStage,
    BandwidthBuilderBuildStage {
        private long capacity;
        private long refillPeriodNanos;
        private long refillTokens;
        private long initialTokens;
        private boolean refillIntervally;
        private long timeOfFirstRefillMillis = Long.MIN_VALUE;
        private boolean useAdaptiveInitialTokens;
        private String id = Bandwidth.UNDEFINED_ID;

        private BandwidthBuilderImpl() {
        }

        @Override
        public BandwidthBuilderRefillStage capacity(long tokens) {
            if (tokens <= 0L) {
                throw BucketExceptions.nonPositiveCapacity(tokens);
            }
            this.capacity = tokens;
            this.initialTokens = tokens;
            return this;
        }

        @Override
        public BandwidthBuilderBuildStage refillGreedy(long tokens, Duration period) {
            this.setRefill(tokens, period, false);
            return this;
        }

        @Override
        public BandwidthBuilderBuildStage refillIntervally(long tokens, Duration period) {
            this.setRefill(tokens, period, true);
            return this;
        }

        @Override
        public BandwidthBuilderBuildStage refillIntervallyAligned(long tokens, Duration period, Instant timeOfFirstRefill) {
            long timeOfFirstRefillMillis = timeOfFirstRefill.toEpochMilli();
            if (timeOfFirstRefillMillis < 0L) {
                throw BucketExceptions.nonPositiveTimeOfFirstRefill(timeOfFirstRefill);
            }
            this.setRefill(tokens, period, true);
            this.timeOfFirstRefillMillis = timeOfFirstRefillMillis;
            return this;
        }

        @Override
        public BandwidthBuilderBuildStage refillIntervallyAlignedWithAdaptiveInitialTokens(long tokens, Duration period, Instant timeOfFirstRefill) {
            long timeOfFirstRefillMillis = timeOfFirstRefill.toEpochMilli();
            if (timeOfFirstRefillMillis < 0L) {
                throw BucketExceptions.nonPositiveTimeOfFirstRefill(timeOfFirstRefill);
            }
            this.setRefill(tokens, period, true);
            this.timeOfFirstRefillMillis = timeOfFirstRefillMillis;
            this.useAdaptiveInitialTokens = true;
            return this;
        }

        @Override
        public BandwidthBuilderBuildStage id(String id) {
            this.id = id;
            return this;
        }

        @Override
        public BandwidthBuilderBuildStage initialTokens(long initialTokens) {
            if (initialTokens < 0L) {
                throw BucketExceptions.nonPositiveInitialTokens(initialTokens);
            }
            if (this.timeOfFirstRefillMillis != Long.MIN_VALUE && this.useAdaptiveInitialTokens) {
                throw BucketExceptions.intervallyAlignedRefillWithAdaptiveInitialTokensIncompatipleWithManualSpecifiedInitialTokens();
            }
            this.initialTokens = initialTokens;
            return this;
        }

        @Override
        public Bandwidth build() {
            return new Bandwidth(this.capacity, this.refillPeriodNanos, this.refillTokens, this.initialTokens, this.refillIntervally, this.timeOfFirstRefillMillis, this.useAdaptiveInitialTokens, this.id);
        }

        private void setRefill(long tokens, Duration period, boolean refillIntervally) {
            if (period == null) {
                throw BucketExceptions.nullRefillPeriod();
            }
            if (tokens <= 0L) {
                throw BucketExceptions.nonPositivePeriodTokens(tokens);
            }
            long refillPeriodNanos = period.toNanos();
            if (refillPeriodNanos <= 0L) {
                throw BucketExceptions.nonPositivePeriod(refillPeriodNanos);
            }
            if (tokens > refillPeriodNanos) {
                throw BucketExceptions.tooHighRefillRate(refillPeriodNanos, tokens);
            }
            this.refillPeriodNanos = refillPeriodNanos;
            this.refillIntervally = refillIntervally;
            this.refillTokens = tokens;
        }
    }

    public static interface BandwidthBuilderBuildStage {
        public Bandwidth build();

        public BandwidthBuilderBuildStage id(String var1);

        public BandwidthBuilderBuildStage initialTokens(long var1);
    }

    public static interface BandwidthBuilderRefillStage {
        public BandwidthBuilderBuildStage refillGreedy(long var1, Duration var3);

        public BandwidthBuilderBuildStage refillIntervally(long var1, Duration var3);

        public BandwidthBuilderBuildStage refillIntervallyAligned(long var1, Duration var3, Instant var4);

        public BandwidthBuilderBuildStage refillIntervallyAlignedWithAdaptiveInitialTokens(long var1, Duration var3, Instant var4);
    }

    public static interface BandwidthBuilderCapacityStage {
        public BandwidthBuilderRefillStage capacity(long var1);
    }
}

