/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.bypass;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.apache.hc.core5.http.HttpResponse;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.bypass.BaseMultifactorAuthenticationProviderBypassEvaluator;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.configuration.model.support.mfa.MultifactorAuthenticationProviderBypassProperties;
import org.apereo.cas.configuration.model.support.mfa.RestfulMultifactorAuthenticationProviderBypassProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.http.HttpExecutionRequest;
import org.apereo.cas.util.http.HttpUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;

public class RestMultifactorAuthenticationProviderBypassEvaluator
extends BaseMultifactorAuthenticationProviderBypassEvaluator {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(RestMultifactorAuthenticationProviderBypassEvaluator.class);
    private static final long serialVersionUID = -7553888418344342672L;
    private final MultifactorAuthenticationProviderBypassProperties bypassProperties;

    public RestMultifactorAuthenticationProviderBypassEvaluator(MultifactorAuthenticationProviderBypassProperties bypassProperties, String providerId, ConfigurableApplicationContext applicationContext) {
        super(providerId, (ApplicationContext)applicationContext);
        this.bypassProperties = bypassProperties;
    }

    @Override
    public boolean shouldMultifactorAuthenticationProviderExecuteInternal(Authentication authentication, RegisteredService registeredService, MultifactorAuthenticationProvider provider, HttpServletRequest request) {
        try {
            HttpExecutionRequest exec;
            HttpResponse response;
            Principal principal = this.resolvePrincipal(authentication.getPrincipal());
            RestfulMultifactorAuthenticationProviderBypassProperties rest = this.bypassProperties.getRest();
            LOGGER.debug("Evaluating multifactor authentication bypass properties for principal [{}], service [{}] and provider [{}] via REST endpoint [{}]", new Object[]{principal.getId(), registeredService, provider, rest.getUrl()});
            Map parameters = CollectionUtils.wrap((String)"principal", (Object)principal.getId(), (String)"provider", (Object)provider.getId());
            if (registeredService != null) {
                parameters.put("service", registeredService.getServiceId());
            }
            return (response = HttpUtils.execute((HttpExecutionRequest)(exec = HttpExecutionRequest.builder().basicAuthPassword(rest.getBasicAuthPassword()).basicAuthUsername(rest.getBasicAuthUsername()).method(HttpMethod.valueOf((String)rest.getMethod().toUpperCase(Locale.ENGLISH).trim())).headers(rest.getHeaders()).url(rest.getUrl()).parameters(parameters).build()))) != null && HttpStatus.valueOf((int)response.getCode()).is2xxSuccessful();
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return true;
        }
    }
}

