/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.webauthn.metadata;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.yubico.webauthn.attestation.AttestationTrustSource;
import com.yubico.webauthn.data.ByteArray;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;

public class CompositeAttestationTrustSource
implements AttestationTrustSource {
    private final List<AttestationTrustSource> trustSources = new ArrayList<AttestationTrustSource>();

    public AttestationTrustSource.TrustRootsResult findTrustRoots(List<X509Certificate> list, Optional<ByteArray> aaguid) {
        return this.trustSources.stream().map(source -> source.findTrustRoots(list, aaguid)).filter(result -> result != null && !result.getTrustRoots().isEmpty()).findFirst().orElseGet(() -> AttestationTrustSource.TrustRootsResult.builder().trustRoots(Set.of()).build());
    }

    @CanIgnoreReturnValue
    public CompositeAttestationTrustSource addAttestationTrustSource(AttestationTrustSource source) {
        this.trustSources.add(source);
        return this;
    }

    @Generated
    public CompositeAttestationTrustSource() {
    }

    @Generated
    public List<AttestationTrustSource> getTrustSources() {
        return this.trustSources;
    }

    static {
        System.setProperty("com.sun.security.enableCRLDP", "true");
    }
}

