/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.BranchStatement;
import org.eclipse.jdt.internal.compiler.ast.StatementWithFinallyBlock;
import org.eclipse.jdt.internal.compiler.ast.TryStatement;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.InsideStatementWithFinallyBlockFlowContext;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;

public class ContinueStatement
extends BranchStatement {
    public ContinueStatement(char[] label, int sourceStart, int sourceEnd) {
        super(label, sourceStart, sourceEnd);
    }

    @Override
    public FlowInfo analyseCode(BlockScope currentScope, FlowContext flowContext, FlowInfo flowInfo) {
        FlowContext targetContext;
        FlowContext flowContext2 = targetContext = this.label == null ? flowContext.getTargetContextForDefaultContinue() : flowContext.getTargetContextForContinueLabel(this.label);
        if (targetContext == null) {
            if (this.label == null) {
                currentScope.problemReporter().invalidContinue(this);
            } else {
                currentScope.problemReporter().undefinedLabel(this);
            }
            return flowInfo;
        }
        if (targetContext == FlowContext.NonLocalGotoThroughSwitchContext) {
            currentScope.problemReporter().continueOutOfSwitchExpression(this);
            return flowInfo;
        }
        targetContext.recordAbruptExit();
        targetContext.expireNullCheckedFieldInfo();
        if (targetContext == FlowContext.NotContinuableContext) {
            currentScope.problemReporter().invalidContinue(this);
            return flowInfo;
        }
        this.initStateIndex = currentScope.methodScope().recordInitializationStates(flowInfo);
        this.targetLabel = targetContext.continueLabel();
        FlowContext traversedContext = flowContext;
        int stmtCount = 0;
        this.statementsWithFinallyBlock = new StatementWithFinallyBlock[5];
        do {
            StatementWithFinallyBlock stmt;
            if ((stmt = traversedContext.statementWithFinallyBlock()) != null) {
                if (stmtCount == this.statementsWithFinallyBlock.length) {
                    this.statementsWithFinallyBlock = new StatementWithFinallyBlock[stmtCount * 2];
                    System.arraycopy(this.statementsWithFinallyBlock, 0, this.statementsWithFinallyBlock, 0, stmtCount);
                }
                this.statementsWithFinallyBlock[stmtCount++] = stmt;
                if (stmt.isFinallyBlockEscaping()) break;
            }
            traversedContext.recordReturnFrom(flowInfo.unconditionalInits());
            if (traversedContext instanceof InsideStatementWithFinallyBlockFlowContext) {
                ASTNode node = traversedContext.associatedNode;
                if (!(node instanceof TryStatement)) continue;
                TryStatement tryStatement = (TryStatement)node;
                flowInfo.addInitializationsFrom(tryStatement.finallyBlockInits);
                continue;
            }
            if (traversedContext != targetContext) continue;
            targetContext.recordContinueFrom(flowContext, flowInfo);
            break;
        } while ((traversedContext = traversedContext.getLocalParent()) != null);
        if (stmtCount != this.statementsWithFinallyBlock.length) {
            this.statementsWithFinallyBlock = new StatementWithFinallyBlock[stmtCount];
            System.arraycopy(this.statementsWithFinallyBlock, 0, this.statementsWithFinallyBlock, 0, stmtCount);
        }
        return FlowInfo.DEAD_END;
    }

    @Override
    public StringBuilder printStatement(int tab, StringBuilder output) {
        ContinueStatement.printIndent(tab, output).append("continue ");
        if (this.label != null) {
            output.append(this.label);
        }
        return output.append(';');
    }

    @Override
    public void traverse(ASTVisitor visitor, BlockScope blockScope) {
        visitor.visit(this, blockScope);
        visitor.endVisit(this, blockScope);
    }

    @Override
    public boolean doesNotCompleteNormally() {
        return true;
    }

    @Override
    public boolean completesByContinue() {
        return true;
    }
}

