/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http2;

import java.util.function.IntPredicate;
import org.apache.coyote.http2.ConnectionException;
import org.apache.coyote.http2.Http2Error;
import org.apache.coyote.http2.Http2Exception;
import org.apache.coyote.http2.StreamException;
import org.apache.tomcat.util.res.StringManager;

enum FrameType {
    DATA(0, false, true, null, false),
    HEADERS(1, false, true, null, true),
    PRIORITY(2, false, true, x -> x == 5, false),
    RST(3, false, true, x -> x == 4, false),
    SETTINGS(4, true, false, x -> x % 6 == 0, true),
    PUSH_PROMISE(5, false, true, x -> x >= 4, true),
    PING(6, true, false, x -> x == 8, false),
    GOAWAY(7, true, false, x -> x >= 8, false),
    WINDOW_UPDATE(8, true, true, x -> x == 4, true),
    CONTINUATION(9, false, true, null, true),
    PRIORITY_UPDATE(16, true, false, x -> x >= 4, true),
    UNKNOWN(256, true, true, null, false);

    private static final StringManager sm;
    private final int id;
    private final boolean streamZero;
    private final boolean streamNonZero;
    private final IntPredicate payloadSizeValidator;
    private final boolean payloadErrorFatal;

    private FrameType(int id, boolean streamZero, boolean streamNonZero, IntPredicate payloadSizeValidator, boolean payloadErrorFatal) {
        this.id = id;
        this.streamZero = streamZero;
        this.streamNonZero = streamNonZero;
        this.payloadSizeValidator = payloadSizeValidator;
        this.payloadErrorFatal = payloadErrorFatal;
    }

    int getId() {
        return this.id;
    }

    byte getIdByte() {
        return (byte)this.id;
    }

    void check(int streamId, int payloadSize) throws Http2Exception {
        if (streamId == 0 && !this.streamZero || streamId != 0 && !this.streamNonZero) {
            throw new ConnectionException(sm.getString("frameType.checkStream", new Object[]{this}), Http2Error.PROTOCOL_ERROR);
        }
        if (this.payloadSizeValidator != null && !this.payloadSizeValidator.test(payloadSize)) {
            if (this.payloadErrorFatal || streamId == 0) {
                throw new ConnectionException(sm.getString("frameType.checkPayloadSize", new Object[]{Integer.toString(payloadSize), this}), Http2Error.FRAME_SIZE_ERROR);
            }
            throw new StreamException(sm.getString("frameType.checkPayloadSize", new Object[]{Integer.toString(payloadSize), this}), Http2Error.FRAME_SIZE_ERROR, streamId);
        }
    }

    static FrameType valueOf(int i) {
        return switch (i) {
            case 0 -> DATA;
            case 1 -> HEADERS;
            case 2 -> PRIORITY;
            case 3 -> RST;
            case 4 -> SETTINGS;
            case 5 -> PUSH_PROMISE;
            case 6 -> PING;
            case 7 -> GOAWAY;
            case 8 -> WINDOW_UPDATE;
            case 9 -> CONTINUATION;
            case 16 -> PRIORITY_UPDATE;
            default -> UNKNOWN;
        };
    }

    static {
        sm = StringManager.getManager(FrameType.class);
    }
}

