/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.ejbd;

import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import org.apache.openejb.client.LogoutRequest;
import org.apache.openejb.client.LogoutResponse;
import org.apache.openejb.client.ProtocolMetaData;
import org.apache.openejb.client.Response;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.server.ejbd.EjbDaemon;
import org.apache.openejb.server.ejbd.RequestHandler;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

class LogoutRequestHandler
extends RequestHandler {
    private static final Logger LOGGER = Logger.getInstance((LogCategory)LogCategory.OPENEJB_SERVER_REMOTE.createChild("auth"), (String)"org.apache.openejb.server.util.resources");
    private static final boolean DEBUG = LOGGER.isDebugEnabled();

    protected LogoutRequestHandler(EjbDaemon daemon) {
        super(daemon);
    }

    @Override
    public String getName() {
        return "Logout";
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Response processRequest(ObjectInputStream in, ProtocolMetaData metaData) throws Exception {
        LogoutRequest req = new LogoutRequest();
        req.setMetaData(metaData);
        LogoutResponse res = new LogoutResponse();
        res.setMetaData(metaData);
        try {
            req.readExternal((ObjectInput)in);
            ((SecurityService)SystemInstance.get().getComponent(SecurityService.class)).logout(req.getSecurityIdentity());
            res.setResponseCode(27);
        }
        catch (Throwable t) {
            res.setResponseCode(28);
            res.setDeniedCause(t);
        }
        finally {
            if (DEBUG) {
                try {
                    LOGGER.debug("LOGOUT REQUEST: " + String.valueOf(req) + " -- RESPONSE: " + String.valueOf(res));
                }
                catch (Exception exception) {}
            }
        }
        return res;
    }

    @Override
    public void processResponse(Response response, ObjectOutputStream out, ProtocolMetaData metaData) throws Exception {
        if (LogoutResponse.class.isInstance(response)) {
            LogoutResponse res = (LogoutResponse)LogoutResponse.class.cast(response);
            res.setMetaData(metaData);
            try {
                res.writeExternal((ObjectOutput)out);
            }
            catch (Exception e) {
                LOGGER.fatal("Could not write AuthenticationResponse to output stream", (Throwable)e);
            }
        } else {
            LOGGER.error("AuthRequestHandler cannot process an instance of: " + response.getClass().getName());
        }
    }
}

