/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.jee.oejb3;

import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;

public class PropertiesAdapter
extends XmlAdapter<String, Properties> {
    public Properties unmarshal(String s) throws Exception {
        SortedProperties properties = new SortedProperties();
        ByteArrayInputStream in = new ByteArrayInputStream(s.getBytes());
        properties.load(in);
        return properties;
    }

    public String marshal(Properties properties) throws Exception {
        if (properties == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        (!SortedProperties.class.isInstance(properties) ? new SortedProperties(properties) : properties).store(out, null);
        String string = new String(out.toByteArray());
        return string.replaceFirst("#.*?" + System.lineSeparator(), "");
    }

    private static class SortedProperties
    extends Properties {
        private SortedProperties() {
        }

        private SortedProperties(Properties copy) {
            this.putAll((Map<?, ?>)copy);
        }

        @Override
        public Set<String> stringPropertyNames() {
            return new TreeSet<String>(super.stringPropertyNames());
        }

        @Override
        public Enumeration<Object> keys() {
            ArrayList<Object> list = new ArrayList<Object>(Collections.list(super.keys()));
            Collections.sort(list, new Comparator<Object>(){

                @Override
                public int compare(Object o1, Object o2) {
                    return String.valueOf(o1).compareTo(String.valueOf(o2));
                }
            });
            return Collections.enumeration(list);
        }

        @Override
        public Set<Map.Entry<Object, Object>> entrySet() {
            Set<Map.Entry<Object, Object>> entrySet = super.entrySet();
            TreeSet<Map.Entry<Object, Object>> entries = new TreeSet<Map.Entry<Object, Object>>(new Comparator<Map.Entry<Object, Object>>(){

                @Override
                public int compare(Map.Entry<Object, Object> o1, Map.Entry<Object, Object> o2) {
                    return String.valueOf(o1.getKey()).compareTo(String.valueOf(o2.getKey()));
                }
            });
            entries.addAll(entrySet);
            return entries;
        }
    }
}

