/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.api.instrumenter.network;

import io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.context.Context;
import io.opentelemetry.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.network.ServerAttributesGetter;
import io.opentelemetry.instrumentation.api.instrumenter.network.internal.AddressAndPortExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.network.internal.InternalServerAttributesExtractor;
import io.opentelemetry.instrumentation.api.instrumenter.network.internal.ServerAddressAndPortExtractor;
import io.opentelemetry.instrumentation.api.internal.SemconvStability;
import javax.annotation.Nullable;

public final class ServerAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    private final InternalServerAttributesExtractor<REQUEST> internalExtractor;

    public static <REQUEST, RESPONSE> ServerAttributesExtractor<REQUEST, RESPONSE> create(ServerAttributesGetter<REQUEST, RESPONSE> getter) {
        return new ServerAttributesExtractor<REQUEST, RESPONSE>(getter, InternalServerAttributesExtractor.Mode.PEER);
    }

    @Deprecated
    public static <REQUEST, RESPONSE> ServerAttributesExtractor<REQUEST, RESPONSE> createForServerSide(ServerAttributesGetter<REQUEST, RESPONSE> getter) {
        return new ServerAttributesExtractor<REQUEST, RESPONSE>(getter, InternalServerAttributesExtractor.Mode.HOST);
    }

    ServerAttributesExtractor(ServerAttributesGetter<REQUEST, RESPONSE> getter, InternalServerAttributesExtractor.Mode mode) {
        this.internalExtractor = new InternalServerAttributesExtractor<REQUEST>(new ServerAddressAndPortExtractor<REQUEST>(getter, AddressAndPortExtractor.noop()), SemconvStability.emitStableHttpSemconv(), SemconvStability.emitOldHttpSemconv(), mode);
    }

    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        this.internalExtractor.onStart(attributes, request);
    }

    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
    }
}

