/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.jaxrs;

import jakarta.json.Json;
import jakarta.json.JsonReader;
import jakarta.json.JsonReaderFactory;
import jakarta.json.JsonStructure;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.ext.MessageBodyReader;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collections;
import org.apache.johnzon.mapper.internal.Streams;

@Consumes(value={"application/json", "*/json", "*/*+json", "*/x-json", "*/javascript", "*/x-javascript"})
public class JsrMessageBodyReader
implements MessageBodyReader<JsonStructure> {
    private final JsonReaderFactory factory;
    private final boolean closeStream;

    public JsrMessageBodyReader() {
        this(Json.createReaderFactory(Collections.emptyMap()), false);
    }

    public JsrMessageBodyReader(JsonReaderFactory factory, boolean closeStream) {
        this.factory = factory;
        this.closeStream = closeStream;
    }

    public boolean isReadable(Class<?> aClass, Type type, Annotation[] annotations, MediaType mediaType) {
        return JsonStructure.class.isAssignableFrom(aClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonStructure readFrom(Class<JsonStructure> jsonStructureClass, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> stringStringMultivaluedMap, InputStream inputStream) throws IOException, WebApplicationException {
        try (JsonReader reader = null;){
            reader = this.factory.createReader(this.closeStream ? inputStream : Streams.noClose((InputStream)inputStream));
            JsonStructure jsonStructure = reader.read();
            return jsonStructure;
        }
    }
}

