/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomee.catalina;

import java.security.Principal;
import java.security.cert.X509Certificate;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.Realm;
import org.apache.catalina.Wrapper;
import org.apache.catalina.connector.Request;
import org.apache.catalina.realm.CombinedRealm;
import org.apache.catalina.realm.GenericPrincipal;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.threads.task.CUTask;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.tomee.catalina.OpenEJBSecurityListener;
import org.apache.tomee.catalina.TomcatSecurityService;
import org.ietf.jgss.GSSContext;

public class TomEERealm
extends CombinedRealm {
    public static final String SECURITY_NOTE = TomEERealm.class.getName() + ".securityContext";
    private TomcatSecurityService securityService;

    protected void startInternal() throws LifecycleException {
        super.startInternal();
        this.securityService = (TomcatSecurityService)((Object)SystemInstance.get().getComponent(SecurityService.class));
    }

    public Principal authenticate(String username, String password) {
        return this.logInTomEE(super.authenticate(username, password));
    }

    public Principal authenticate(X509Certificate[] certs) {
        return this.logInTomEE(super.authenticate(certs));
    }

    public Principal authenticate(String username, String clientDigest, String nonce, String nc, String cnonce, String qop, String realmName, String md5a2) {
        return this.logInTomEE(super.authenticate(username, clientDigest, nonce, nc, cnonce, qop, realmName, md5a2));
    }

    public Principal authenticate(GSSContext gssContext, boolean storeCreds) {
        return this.logInTomEE(super.authenticate(gssContext, storeCreds));
    }

    public boolean hasRole(Wrapper wrapper, Principal principal, String rawRole) {
        String realRole;
        String role = rawRole;
        if (wrapper != null && (realRole = wrapper.findSecurityReference(role)) != null) {
            role = realRole;
        }
        if (principal == null || role == null) {
            return false;
        }
        if (principal instanceof GenericPrincipal) {
            return ((GenericPrincipal)principal).hasRole(role);
        }
        for (Realm realm : this.realms) {
            if (!realm.hasRole(wrapper, principal, rawRole)) continue;
            return true;
        }
        return false;
    }

    private Principal logInTomEE(Principal pcp) {
        Request request;
        if (pcp == null) {
            return null;
        }
        if (this.securityService == null) {
            this.securityService = (TomcatSecurityService)((Object)SystemInstance.get().getComponent(SecurityService.class));
        }
        if ((request = OpenEJBSecurityListener.requests.get()) != null) {
            Object securityContext = this.securityService.enterWebApp((Realm)this, pcp, OpenEJBSecurityListener.requests.get().getWrapper().getRunAs());
            request.setNote(SECURITY_NOTE, securityContext);
        } else {
            CUTask.Context context = (CUTask.Context)CUTask.Context.CURRENT.get();
            if (context != null) {
                final Object state = this.securityService.enterWebApp((Realm)this, pcp, null);
                context.pushExitTask(new Runnable(){

                    @Override
                    public void run() {
                        TomEERealm.this.securityService.exitWebApp(state);
                    }
                });
            } else {
                Logger instance = Logger.getInstance((LogCategory)LogCategory.OPENEJB_SECURITY, TomEERealm.class);
                if (instance.isDebugEnabled()) {
                    instance.debug("No request or concurrency-utilities context so skipping login context propagation, thread=" + Thread.currentThread().getName());
                }
            }
        }
        return pcp;
    }
}

