/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.server.cxf.rs.johnzon;

import jakarta.json.bind.annotation.JsonbProperty;
import jakarta.json.bind.annotation.JsonbVisibility;
import jakarta.json.bind.config.PropertyVisibilityStrategy;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.johnzon.mapper.JohnzonProperty;

public class TomEEJsonbPropertyVisibilityStrategy
implements PropertyVisibilityStrategy {
    private final ConcurrentMap<Class<?>, PropertyVisibilityStrategy> strategies = new ConcurrentHashMap();

    public boolean isVisible(Field field) {
        return field.getAnnotation(JsonbProperty.class) != null || field.getAnnotation(JohnzonProperty.class) != null || Modifier.isPublic(field.getModifiers()) || this.strategies.computeIfAbsent(field.getDeclaringClass(), this::visibilityStrategy).isVisible(field);
    }

    public boolean isVisible(Method method) {
        return method.getAnnotation(JsonbProperty.class) != null || method.getAnnotation(JohnzonProperty.class) != null || Modifier.isPublic(method.getModifiers()) || this.strategies.computeIfAbsent(method.getDeclaringClass(), this::visibilityStrategy).isVisible(method);
    }

    private PropertyVisibilityStrategy visibilityStrategy(Class<?> type) {
        JsonbVisibility visibility = type.getAnnotation(JsonbVisibility.class);
        if (visibility != null) {
            try {
                return (PropertyVisibilityStrategy)visibility.value().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                throw new IllegalArgumentException(e);
            }
        }
        Package p = type.getPackage();
        while (p != null) {
            visibility = p.getAnnotation(JsonbVisibility.class);
            if (visibility != null) {
                try {
                    return (PropertyVisibilityStrategy)visibility.value().newInstance();
                }
                catch (IllegalAccessException | InstantiationException e) {
                    throw new IllegalArgumentException(e);
                }
            }
            String name = p.getName();
            int end = name.lastIndexOf(46);
            if (end < 0) break;
            p = Package.getPackage(name.substring(0, end));
        }
        return new PropertyVisibilityStrategy(){

            public boolean isVisible(Field field) {
                return false;
            }

            public boolean isVisible(Method method) {
                return false;
            }
        };
    }
}

