/*
 * Decompiled with CFR 0.152.
 */
package io.churchkey.util;

import io.churchkey.shade.util.PrintString;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.ListIterator;
import java.util.Map;

public class Pem {
    private final String header;
    private final String footer;
    private final String type;
    private final byte[] data;
    private final int wrap;
    private final Map<String, String> attributes;

    Pem(String header, String footer, String type, byte[] data, int wrap, Map<String, String> attributes) {
        this.header = header;
        this.footer = footer;
        this.type = type;
        this.data = data;
        this.wrap = wrap;
        this.attributes = attributes;
    }

    public static Pem parse(byte[] bytes) {
        return Pem.parse(new String(bytes));
    }

    public static Pem parse(String string) {
        ArrayList<String> lines = new ArrayList<String>(Arrays.asList(string.split("[\r\n]")));
        String header = (String)lines.remove(0);
        String footer = (String)lines.remove(lines.size() - 1);
        ListIterator iterator = lines.listIterator();
        HashMap<String, String> attributes = new HashMap<String, String>();
        String line = "";
        while (iterator.hasNext() && (line = (String)iterator.next()).contains(":")) {
            int colon = line.indexOf(":");
            String name = line.substring(0, colon).trim();
            String value = line.substring(colon + 1).trim().replaceAll("^\"|\"$", "");
            attributes.put(name, value);
        }
        StringBuilder encoded = new StringBuilder();
        encoded.append(line);
        int wrap = line.length();
        while (iterator.hasNext()) {
            encoded.append((String)iterator.next());
        }
        byte[] data = Base64.getDecoder().decode(encoded.toString());
        String type = Pem.getType(header);
        return new Pem(header, footer, type, data, wrap, attributes);
    }

    private static String getType(String header) {
        return header.replaceAll("^-+ ?BEGIN | ?-+$", "");
    }

    public static Builder builder() {
        return new Builder();
    }

    public String format() {
        PrintString out = new PrintString();
        out.println(this.header);
        for (Map.Entry<String, String> entry : this.attributes.entrySet()) {
            out.printf("%s: \"%s\"%n", entry.getKey(), entry.getValue());
        }
        ByteArrayInputStream encoded = new ByteArrayInputStream(Base64.getEncoder().encode(this.data));
        try {
            int length;
            byte[] line = new byte[this.wrap];
            while ((length = encoded.read(line)) != -1) {
                out.println(new String(line, 0, length));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        out.println(this.footer);
        return out.toString();
    }

    public String getHeader() {
        return this.header;
    }

    public String getFooter() {
        return this.footer;
    }

    public String getType() {
        return this.type;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getWrap() {
        return this.wrap;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pem)) {
            return false;
        }
        Pem other = (Pem)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getWrap() != other.getWrap()) {
            return false;
        }
        String this$header = this.getHeader();
        String other$header = other.getHeader();
        if (this$header == null ? other$header != null : !this$header.equals(other$header)) {
            return false;
        }
        String this$footer = this.getFooter();
        String other$footer = other.getFooter();
        if (this$footer == null ? other$footer != null : !this$footer.equals(other$footer)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        if (!Arrays.equals(this.getData(), other.getData())) {
            return false;
        }
        Map<String, String> this$attributes = this.getAttributes();
        Map<String, String> other$attributes = other.getAttributes();
        return !(this$attributes == null ? other$attributes != null : !((Object)this$attributes).equals(other$attributes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Pem;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getWrap();
        String $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : $header.hashCode());
        String $footer = this.getFooter();
        result = result * 59 + ($footer == null ? 43 : $footer.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        result = result * 59 + Arrays.hashCode(this.getData());
        Map<String, String> $attributes = this.getAttributes();
        result = result * 59 + ($attributes == null ? 43 : ((Object)$attributes).hashCode());
        return result;
    }

    public String toString() {
        return "Pem(header=" + this.getHeader() + ", footer=" + this.getFooter() + ", type=" + this.getType() + ", data=" + Arrays.toString(this.getData()) + ", wrap=" + this.getWrap() + ", attributes=" + this.getAttributes() + ")";
    }

    public static class Builder {
        private String header;
        private String footer;
        private String type;
        private byte[] data;
        private int wrap = 64;
        private Map<String, String> attributes = new HashMap<String, String>();

        Builder() {
        }

        public Builder type(String type) {
            this.type = type;
            String upperCaseType = type.toUpperCase();
            this.header(String.format("-----BEGIN %s-----", upperCaseType));
            this.footer(String.format("-----END %s-----", upperCaseType));
            return this;
        }

        public Builder data(String base64Data) {
            return this.data(Base64.getDecoder().decode(base64Data));
        }

        public Builder data(byte[] binaryData) {
            this.data = binaryData;
            return this;
        }

        public Builder attribute(String name, String value) {
            this.attributes.put(name, value);
            return this;
        }

        public String format() {
            return this.build().format();
        }

        public Builder header(String header) {
            this.header = header;
            return this;
        }

        public Builder footer(String footer) {
            this.footer = footer;
            return this;
        }

        public Builder wrap(int wrap) {
            this.wrap = wrap;
            return this;
        }

        public Builder attributes(Map<String, String> attributes) {
            this.attributes = attributes;
            return this;
        }

        public Pem build() {
            return new Pem(this.header, this.footer, this.type != null ? this.type : Pem.getType(this.header), this.data, this.wrap, this.attributes);
        }

        public String toString() {
            return "Pem.Builder(header=" + this.header + ", footer=" + this.footer + ", type=" + this.type + ", data=" + Arrays.toString(this.data) + ", wrap=" + this.wrap + ", attributes=" + this.attributes + ")";
        }
    }
}

