/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.clients.elasticsearch._types.query_dsl;

import co.elastic.clients.elasticsearch._types.query_dsl.DecayFunction;
import co.elastic.clients.elasticsearch._types.query_dsl.FieldValueFactorScoreFunction;
import co.elastic.clients.elasticsearch._types.query_dsl.FunctionScoreVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.Query;
import co.elastic.clients.elasticsearch._types.query_dsl.QueryVariant;
import co.elastic.clients.elasticsearch._types.query_dsl.RandomScoreFunction;
import co.elastic.clients.elasticsearch._types.query_dsl.ScriptScoreFunction;
import co.elastic.clients.json.JsonEnum;
import co.elastic.clients.json.JsonpDeserializable;
import co.elastic.clients.json.JsonpDeserializer;
import co.elastic.clients.json.JsonpMapper;
import co.elastic.clients.json.JsonpSerializable;
import co.elastic.clients.json.JsonpUtils;
import co.elastic.clients.json.ObjectBuilderDeserializer;
import co.elastic.clients.json.ObjectDeserializer;
import co.elastic.clients.util.ApiTypeHelper;
import co.elastic.clients.util.ObjectBuilder;
import co.elastic.clients.util.TaggedUnion;
import co.elastic.clients.util.TaggedUnionUtils;
import co.elastic.clients.util.WithJsonObjectBuilderBase;
import jakarta.json.stream.JsonGenerator;
import java.util.function.Function;
import javax.annotation.Nullable;

@JsonpDeserializable
public class FunctionScore
implements TaggedUnion<Kind, Object>,
JsonpSerializable {
    @Nullable
    private final Kind _kind;
    @Nullable
    private final Object _value;
    @Nullable
    private final Query filter;
    @Nullable
    private final Double weight;
    public static final JsonpDeserializer<FunctionScore> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, FunctionScore::setupFunctionScoreDeserializer, Builder::build);

    @Override
    @Nullable
    public final Kind _kind() {
        return this._kind;
    }

    @Override
    @Nullable
    public final Object _get() {
        return this._value;
    }

    public FunctionScore(@Nullable FunctionScoreVariant value) {
        if (value != null) {
            this._kind = ApiTypeHelper.requireNonNull(value._functionScoreKind(), this, "<variant kind>");
            this._value = ApiTypeHelper.requireNonNull(value, this, "<variant value>");
        } else {
            this._kind = null;
            this._value = null;
        }
        this.filter = null;
        this.weight = null;
    }

    private FunctionScore(Builder builder) {
        if (builder._value != null) {
            this._kind = ApiTypeHelper.requireNonNull(builder._kind, builder, "<variant kind>");
            this._value = ApiTypeHelper.requireNonNull(builder._value, builder, "<variant value>");
        } else {
            this._kind = null;
            this._value = null;
        }
        this.filter = builder.filter;
        this.weight = builder.weight;
    }

    public static FunctionScore of(Function<Builder, ObjectBuilder<FunctionScore>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nullable
    public final Query filter() {
        return this.filter;
    }

    @Nullable
    public final Double weight() {
        return this.weight;
    }

    public boolean isExp() {
        return this._kind == Kind.Exp;
    }

    public DecayFunction exp() {
        return (DecayFunction)TaggedUnionUtils.get(this, Kind.Exp);
    }

    public boolean isGauss() {
        return this._kind == Kind.Gauss;
    }

    public DecayFunction gauss() {
        return (DecayFunction)TaggedUnionUtils.get(this, Kind.Gauss);
    }

    public boolean isLinear() {
        return this._kind == Kind.Linear;
    }

    public DecayFunction linear() {
        return (DecayFunction)TaggedUnionUtils.get(this, Kind.Linear);
    }

    public boolean isFieldValueFactor() {
        return this._kind == Kind.FieldValueFactor;
    }

    public FieldValueFactorScoreFunction fieldValueFactor() {
        return (FieldValueFactorScoreFunction)TaggedUnionUtils.get(this, Kind.FieldValueFactor);
    }

    public boolean isRandomScore() {
        return this._kind == Kind.RandomScore;
    }

    public RandomScoreFunction randomScore() {
        return (RandomScoreFunction)TaggedUnionUtils.get(this, Kind.RandomScore);
    }

    public boolean isScriptScore() {
        return this._kind == Kind.ScriptScore;
    }

    public ScriptScoreFunction scriptScore() {
        return (ScriptScoreFunction)TaggedUnionUtils.get(this, Kind.ScriptScore);
    }

    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        if (this.filter != null) {
            generator.writeKey("filter");
            this.filter.serialize(generator, mapper);
        }
        if (this.weight != null) {
            generator.writeKey("weight");
            generator.write(this.weight.doubleValue());
        }
        if (this._value != null) {
            generator.writeKey(this._kind.jsonValue());
            if (this._value instanceof JsonpSerializable) {
                ((JsonpSerializable)this._value).serialize(generator, mapper);
            }
        }
        generator.writeEnd();
    }

    public String toString() {
        return JsonpUtils.toString((JsonpSerializable)this);
    }

    protected static void setupFunctionScoreDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::exp, DecayFunction._DESERIALIZER, "exp");
        op.add(Builder::gauss, DecayFunction._DESERIALIZER, "gauss");
        op.add(Builder::linear, DecayFunction._DESERIALIZER, "linear");
        op.add(Builder::fieldValueFactor, FieldValueFactorScoreFunction._DESERIALIZER, "field_value_factor");
        op.add(Builder::randomScore, RandomScoreFunction._DESERIALIZER, "random_score");
        op.add(Builder::scriptScore, ScriptScoreFunction._DESERIALIZER, "script_score");
        op.add(Builder::filter, Query._DESERIALIZER, "filter");
        op.add(Builder::weight, JsonpDeserializer.doubleDeserializer(), "weight");
    }

    public static enum Kind implements JsonEnum
    {
        Exp("exp"),
        Gauss("gauss"),
        Linear("linear"),
        FieldValueFactor("field_value_factor"),
        RandomScore("random_score"),
        ScriptScore("script_score");

        private final String jsonValue;

        private Kind(String jsonValue) {
            this.jsonValue = jsonValue;
        }

        public String jsonValue() {
            return this.jsonValue;
        }
    }

    public static class Builder
    extends WithJsonObjectBuilderBase<Builder>
    implements ObjectBuilder<FunctionScore> {
        private Kind _kind;
        private Object _value;
        @Nullable
        private Query filter;
        @Nullable
        private Double weight;

        public final Builder filter(@Nullable Query value) {
            this.filter = value;
            return this;
        }

        public final Builder filter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
            return this.filter(fn.apply(new Query.Builder()).build());
        }

        public final Builder filter(QueryVariant value) {
            this.filter = value._toQuery();
            return this;
        }

        public final Builder weight(@Nullable Double value) {
            this.weight = value;
            return this;
        }

        @Override
        protected Builder self() {
            return this;
        }

        public ContainerBuilder exp(DecayFunction v) {
            this._kind = Kind.Exp;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder exp(Function<DecayFunction.Builder, ObjectBuilder<DecayFunction>> fn) {
            return this.exp(fn.apply(new DecayFunction.Builder()).build());
        }

        public ContainerBuilder gauss(DecayFunction v) {
            this._kind = Kind.Gauss;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder gauss(Function<DecayFunction.Builder, ObjectBuilder<DecayFunction>> fn) {
            return this.gauss(fn.apply(new DecayFunction.Builder()).build());
        }

        public ContainerBuilder linear(DecayFunction v) {
            this._kind = Kind.Linear;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder linear(Function<DecayFunction.Builder, ObjectBuilder<DecayFunction>> fn) {
            return this.linear(fn.apply(new DecayFunction.Builder()).build());
        }

        public ContainerBuilder fieldValueFactor(FieldValueFactorScoreFunction v) {
            this._kind = Kind.FieldValueFactor;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder fieldValueFactor(Function<FieldValueFactorScoreFunction.Builder, ObjectBuilder<FieldValueFactorScoreFunction>> fn) {
            return this.fieldValueFactor(fn.apply(new FieldValueFactorScoreFunction.Builder()).build());
        }

        public ContainerBuilder randomScore(RandomScoreFunction v) {
            this._kind = Kind.RandomScore;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder randomScore(Function<RandomScoreFunction.Builder, ObjectBuilder<RandomScoreFunction>> fn) {
            return this.randomScore(fn.apply(new RandomScoreFunction.Builder()).build());
        }

        public ContainerBuilder scriptScore(ScriptScoreFunction v) {
            this._kind = Kind.ScriptScore;
            this._value = v;
            return new ContainerBuilder();
        }

        public ContainerBuilder scriptScore(Function<ScriptScoreFunction.Builder, ObjectBuilder<ScriptScoreFunction>> fn) {
            return this.scriptScore(fn.apply(new ScriptScoreFunction.Builder()).build());
        }

        @Override
        public FunctionScore build() {
            this._checkSingleUse();
            return new FunctionScore(this);
        }

        public class ContainerBuilder
        implements ObjectBuilder<FunctionScore> {
            public final ContainerBuilder filter(@Nullable Query value) {
                Builder.this.filter = value;
                return this;
            }

            public final ContainerBuilder filter(Function<Query.Builder, ObjectBuilder<Query>> fn) {
                return this.filter(fn.apply(new Query.Builder()).build());
            }

            public final ContainerBuilder filter(QueryVariant value) {
                Builder.this.filter = value._toQuery();
                return this;
            }

            public final ContainerBuilder weight(@Nullable Double value) {
                Builder.this.weight = value;
                return this;
            }

            @Override
            public FunctionScore build() {
                return Builder.this.build();
            }
        }
    }
}

