/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.markup.html.image;

import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.request.IRequestCycle;
import org.apache.wicket.request.UrlUtils;
import org.apache.wicket.request.cycle.RequestCycle;

public class ContextPathGenerator
extends Behavior {
    private static final long serialVersionUID = 1L;
    private final IModel<String> contextRelativePath;

    public ContextPathGenerator(IModel<String> contextRelativePath) {
        this.contextRelativePath = contextRelativePath;
    }

    public ContextPathGenerator(String contextRelativePath) {
        this.contextRelativePath = new Model<String>(contextRelativePath);
    }

    @Override
    public void onComponentTag(Component component, ComponentTag tag) {
        String path = this.contextRelativePath.getObject();
        String rewritten = UrlUtils.rewriteToContextRelative((String)path, (IRequestCycle)RequestCycle.get());
        tag.put("src", rewritten);
    }

    @Override
    public void detach(Component component) {
        this.contextRelativePath.detach();
        super.detach(component);
    }
}

