/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.crypt;

import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;

public class CipherUtils {
    public static SecretKey generateKey(String algorithm, int keyLength, SecureRandom secureRandom) {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(algorithm);
            keyGenerator.init(keyLength, secureRandom);
            SecretKey key = keyGenerator.generateKey();
            return key;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static SecretKey generatePBEKey(String password, String pbeAlgorithm, String keyAlgorithm, byte[] salt, int iterationCount, int keyLength) {
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance(pbeAlgorithm);
            PBEKeySpec spec = new PBEKeySpec(password.toCharArray(), salt, iterationCount, keyLength);
            SecretKeySpec secret = new SecretKeySpec(factory.generateSecret(spec).getEncoded(), keyAlgorithm);
            return secret;
        }
        catch (NoSuchAlgorithmException | InvalidKeySpecException e) {
            throw new RuntimeException(e);
        }
    }
}

