/*
 * Decompiled with CFR 0.152.
 */
package git4idea.checkin;

import com.intellij.notification.NotificationType;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ThrowableConsumer;
import git4idea.checkin.GitCheckinEnvironment;
import git4idea.checkin.GitCommitOptions;
import git4idea.checkin.GitEmptyCommitProblemDetector;
import git4idea.checkin.GitGpgCommitException;
import git4idea.checkin.GitGpgProblemDetector;
import git4idea.checkin.GitPinentryProblemDetector;
import git4idea.checkin.GitRepositoryCommitterKt;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.commit.signing.GpgAgentConfigurationNotificator;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitRepository;
import java.io.File;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0017R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u0018"}, d2={"Lgit4idea/checkin/GitRepositoryCommitter;", "", "repository", "Lgit4idea/repo/GitRepository;", "commitOptions", "Lgit4idea/checkin/GitCommitOptions;", "<init>", "(Lgit4idea/repo/GitRepository;Lgit4idea/checkin/GitCommitOptions;)V", "getRepository", "()Lgit4idea/repo/GitRepository;", "project", "Lcom/intellij/openapi/project/Project;", "getProject", "()Lcom/intellij/openapi/project/Project;", "root", "Lcom/intellij/openapi/vfs/VirtualFile;", "getRoot", "()Lcom/intellij/openapi/vfs/VirtualFile;", "commitStaged", "", "commitMessage", "", "messageFile", "Ljava/io/File;", "intellij.vcs.git"})
@SourceDebugExtension(value={"SMAP\nGitRepositoryCommitter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitRepositoryCommitter.kt\ngit4idea/checkin/GitRepositoryCommitter\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,165:1\n30#2,2:166\n*S KotlinDebug\n*F\n+ 1 GitRepositoryCommitter.kt\ngit4idea/checkin/GitRepositoryCommitter\n*L\n79#1:166,2\n*E\n"})
public final class GitRepositoryCommitter {
    @NotNull
    private final GitRepository repository;
    @NotNull
    private final GitCommitOptions commitOptions;

    public GitRepositoryCommitter(@NotNull GitRepository repository2, @NotNull GitCommitOptions commitOptions) {
        Intrinsics.checkNotNullParameter((Object)repository2, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)commitOptions, (String)"commitOptions");
        this.repository = repository2;
        this.commitOptions = commitOptions;
    }

    @NotNull
    public final GitRepository getRepository() {
        return this.repository;
    }

    @NotNull
    public final Project getProject() {
        Project project = this.repository.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        return project;
    }

    @NotNull
    public final VirtualFile getRoot() {
        VirtualFile virtualFile = this.repository.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getRoot(...)");
        return virtualFile;
    }

    public final void commitStaged(@NotNull String commitMessage) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)commitMessage, (String)"commitMessage");
        GitCheckinEnvironment.Companion.runWithMessageFile(this.getProject(), this.getRoot(), commitMessage, (ThrowableConsumer<? super File, ? extends VcsException>)((ThrowableConsumer)arg_0 -> GitRepositoryCommitter.commitStaged$lambda$1(arg_0 -> GitRepositoryCommitter.commitStaged$lambda$0(this, arg_0), arg_0)));
    }

    public final void commitStaged(@NotNull File messageFile) throws VcsException {
        Intrinsics.checkNotNullParameter((Object)messageFile, (String)"messageFile");
        GitPinentryProblemDetector pinentryProblemDetector = new GitPinentryProblemDetector();
        GitGpgProblemDetector gpgProblemDetector = new GitGpgProblemDetector();
        GitEmptyCommitProblemDetector emptyCommitProblemDetector = new GitEmptyCommitProblemDetector();
        GitLineHandler handler = new GitLineHandler(this.getProject(), this.getRoot(), GitCommand.COMMIT);
        handler.setStdoutSuppressed(false);
        handler.addLineListener(gpgProblemDetector);
        handler.addLineListener(pinentryProblemDetector);
        handler.addLineListener(emptyCommitProblemDetector);
        GitRepositoryCommitterKt.access$setCommitMessage(handler, messageFile);
        GitRepositoryCommitterKt.access$setCommitOptions(handler, this.commitOptions);
        handler.endOptions();
        GitCommandResult gitCommandResult = Git.getInstance().runCommand(handler);
        Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"runCommand(...)");
        GitCommandResult command = gitCommandResult;
        try {
            command.throwOnError(new int[0]);
        }
        catch (VcsException e) {
            if (pinentryProblemDetector.isDetected()) {
                ComponentManager $this$service$iv = (ComponentManager)this.getProject();
                boolean $i$f$service = false;
                Class<GpgAgentConfigurationNotificator> serviceClass$iv = GpgAgentConfigurationNotificator.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
                }
                ((GpgAgentConfigurationNotificator)object).proposeCustomPinentryAgentConfigurationSync(NotificationType.WARNING);
            }
            if (gpgProblemDetector.isDetected()) {
                throw new GitGpgCommitException(e);
            }
            if (emptyCommitProblemDetector.isDetected()) {
                throw new VcsException(GitBundle.message("git.commit.nothing.to.commit.error.message", new Object[0]));
            }
            throw e;
        }
    }

    private static final Unit commitStaged$lambda$0(GitRepositoryCommitter this$0, File messageFile) {
        Intrinsics.checkNotNull((Object)messageFile);
        this$0.commitStaged(messageFile);
        return Unit.INSTANCE;
    }

    private static final void commitStaged$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }
}

