\name{LaplacianSharpeningImageFilter}
\alias{LaplacianSharpeningImageFilter}
\title{LaplacianSharpeningImageFilter}
\Rdversion{1.1}
\docType{class}
\description{
This filter sharpens an image using a Laplacian. LaplacianSharpening
highlights regions of rapid intensity change and therefore highlights
or enhances the edges. The result is an image that appears more in
focus.
LaplacianSharpeningImageFilter}
\details{
The LaplacianSharpening at each pixel location is computed by
convolution with the itk::LaplacianOperator .
Inputs and Outputs
The input to this filter is a scalar-valued itk::Image of arbitrary dimension. The output is a scalar-valued itk::Image .
See:
Image
Neighborhood
NeighborhoodOperator
NeighborhoodIterator
LaplacianOperator
LaplacianSharpening for the procedural interface
itk::LaplacianSharpeningImageFilter for the Doxygen on the original ITK class.
LaplacianSharpeningImageFilter}
%C++ includes: sitkLaplacianSharpeningImageFilter.h
\section{Methods}{
\describe{
\item{Image Execute(const Image &image1):}{
Execute the filter on the input image
}
\item{std::string GetName() const:}{
Name of this class
}
\item{bool GetUseImageSpacing() const:}{
Set/Get whether or not the filter will use the spacing of the input
image in its calculations
}
\item{ LaplacianSharpeningImageFilter():}{
Default Constructor that takes no arguments and initializes default
parameters
}
\item{Self SetUseImageSpacing(bool UseImageSpacing):}{
Set/Get whether or not the filter will use the spacing of the input
image in its calculations
}
\item{std::string ToString() const:}{
Print ourselves out
}
\item{Self UseImageSpacingOff():}{}
\item{Self UseImageSpacingOn():}{
Set the value of UseImageSpacing to true or false respectfully.
}
\item{ ~LaplacianSharpeningImageFilter():}{
Destructor
}
}
}
